/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.waveform;

import edu.iris.dmc.seedcodec.Codec;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import pickewanalysis.waveform.WaveForm;

public class WaveFormGroup
extends ArrayList<WaveForm> {
    private static SimpleDateFormat miniseedDateFormat = new SimpleDateFormat("yyyy,DDD,HH:mm:ss.SSS");
    public double maxVal = 0.0;
    public double minVal = 0.0;

    public WaveForm addEmptyWaveForm(String stat, String chan, String net, String loc, long starttime, double samprate, int nsamp) {
        WaveForm output = new WaveForm(stat, chan, net, loc, starttime, samprate, new double[nsamp]);
        this.add(output);
        return output;
    }

    public long getStartTime() {
        if (this.isEmpty()) {
            return -1L;
        }
        long earliestTime = Long.MAX_VALUE;
        for (WaveForm wave : this) {
            if (wave.getStartTime() >= earliestTime) continue;
            earliestTime = wave.getStartTime();
        }
        return earliestTime;
    }

    public long getEndTime() {
        if (this.isEmpty()) {
            return -1L;
        }
        long latestTime = 0L;
        for (WaveForm wave : this) {
            if (wave.getEndTime() <= latestTime) continue;
            latestTime = wave.getEndTime();
        }
        return latestTime;
    }

    public WaveFormGroup splitStation(String stat, String chan, String net, String loc) {
        WaveFormGroup output = new WaveFormGroup();
        for (WaveForm wave : this) {
            if (!wave.isSCNL(stat, chan, net, loc)) continue;
            output.add(wave);
        }
        return output;
    }

    public boolean containsStation(String stat, String chan, String net, String loc) {
        for (WaveForm wave : this) {
            if (!wave.isSCNL(stat, chan, net, loc)) continue;
            return true;
        }
        return false;
    }

    public List<WaveFormGroup> splitStations() {
        ArrayList<WaveFormGroup> groups = new ArrayList<WaveFormGroup>();
        boolean foundGroup = false;
        for (WaveForm wave : this) {
            for (WaveFormGroup curGroup : groups) {
                if (!curGroup.containsStation(wave.stat, wave.chan, wave.net, wave.loc)) continue;
                curGroup.add(wave);
                foundGroup = true;
                break;
            }
            if (foundGroup) continue;
            WaveFormGroup newGroup = new WaveFormGroup();
            newGroup.add(wave);
            groups.add(newGroup);
        }
        return groups;
    }

    public static WaveFormGroup parseTankFile(String filename) throws Exception {
        RandomAccessFile Finput = new RandomAccessFile(filename, "r");
        byte[] data = new byte[(int)Finput.length()];
        long readBytes = Finput.read(data);
        if (readBytes != (long)data.length) {
            throw new Exception("Unable to read file");
        }
        Finput.close();
        return WaveFormGroup.parseTraceBuf2(data);
    }

    public static WaveFormGroup parseTraceBuf2(byte[] data) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        WaveFormGroup waveGroup = new WaveFormGroup();
        byte[] aux = new byte[9];
        while (buffer.hasRemaining()) {
            int i;
            WaveForm wave = new WaveForm();
            int curPos = buffer.position();
            char sampleType = (char)buffer.get(curPos + 57);
            char sampleSize = (char)buffer.get(curPos + 58);
            if (sampleType == 'i') {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int pinno = buffer.getInt();
            wave.nsamp = buffer.getInt();
            wave.starttime = (long)(buffer.getDouble() * 1000.0);
            wave.endtime = (long)(buffer.getDouble() * 1000.0);
            wave.samprate = buffer.getDouble();
            buffer.get(aux, 0, 7);
            wave.stat = new String(aux, 0, 7).trim();
            buffer.get(aux, 0, 9);
            wave.net = new String(aux, 0, 9).trim();
            buffer.get(aux, 0, 4);
            wave.chan = new String(aux, 0, 4).trim();
            buffer.get(aux, 0, 3);
            wave.loc = new String(aux, 0, 3).trim();
            buffer.position(buffer.position() + 9);
            wave.samples = new double[wave.nsamp];
            if (sampleSize == '4') {
                for (i = 0; i < wave.nsamp; ++i) {
                    wave.samples[i] = buffer.getInt();
                }
            } else {
                for (i = 0; i < wave.nsamp; ++i) {
                    wave.samples[i] = buffer.getShort();
                }
            }
            wave.average = 0.0;
            for (i = 0; i < wave.nsamp; ++i) {
                wave.average += wave.samples[i];
            }
            wave.average /= (double)wave.nsamp;
            waveGroup.add(wave);
        }
        return waveGroup;
    }

    public static WaveFormGroup parseMSEEDFile(String filename) throws Exception {
        RandomAccessFile Finput = new RandomAccessFile(filename, "r");
        byte[] data = new byte[(int)Finput.length()];
        long readBytes = Finput.read(data);
        if (readBytes != (long)data.length) {
            throw new Exception("Unable to read file");
        }
        Finput.close();
        WaveFormGroup waveGroup = new WaveFormGroup();
        DataInputStream Binput = new DataInputStream(new ByteArrayInputStream(data));
        while (Binput.available() > 0) {
            int i;
            WaveForm wave = new WaveForm();
            SeedRecord sr = SeedRecord.read(Binput);
            DataRecord dr = (DataRecord)sr;
            DataHeader dh = dr.getHeader();
            byte[] basedata = dr.getData();
            Blockette1000 b1000 = (Blockette1000)sr.getBlockettes(1000)[0];
            int[] intSamples = new Codec().decompress(b1000.getEncodingFormat(), basedata, dh.getNumSamples(), b1000.isLittleEndian()).getAsInt();
            wave.nsamp = intSamples.length;
            wave.samples = new double[wave.nsamp];
            for (i = 0; i < wave.nsamp; ++i) {
                wave.samples[i] = intSamples[i];
            }
            wave.average = 0.0;
            for (i = 0; i < wave.nsamp; ++i) {
                wave.average += wave.samples[i];
            }
            wave.average /= (double)wave.nsamp;
            wave.starttime = miniseedDateFormat.parse(dh.getStartTime().substring(0, 21)).getTime();
            wave.endtime = miniseedDateFormat.parse(dh.getEndTime().substring(0, 21)).getTime();
            wave.stat = dh.getStationIdentifier().trim();
            wave.chan = dh.getChannelIdentifier().trim();
            wave.net = dh.getNetworkCode().trim();
            wave.loc = dh.getLocationIdentifier();
            wave.samprate = dh.getSampleRate();
            waveGroup.add(wave);
        }
        return waveGroup;
    }

    @Override
    public String toString() {
        String output = String.format(Locale.UK, "%5s.%3s.%2s.%2s %23s %23s %5s\n", "STAT", "CHN", "NT", "LC", "START TIME", "END TIME", "NSAMP");
        for (WaveForm wave : this) {
            output = output + wave.toString() + "\n";
        }
        return output;
    }

    public double[] getAllSamples(long starttime, long endtime) {
        double samprate = ((WaveForm)this.get((int)0)).samprate;
        int nsamp = (int)((double)(endtime - starttime) * samprate / 1000.0);
        double[] samples = new double[nsamp];
        for (WaveForm wave : this) {
            if (wave.getStartTime() >= endtime || wave.getEndTime() <= starttime) continue;
            double[] wavesamp = wave.getSamples();
            int recordOffset = (int)((double)(wave.getStartTime() - starttime) * samprate / 1000.0);
            int readOffset = 0;
            if (recordOffset < 0) {
                readOffset = -recordOffset;
                recordOffset = 0;
            }
            int readLength = wave.getSampleCount() - readOffset;
            if (endtime < wave.getEndTime()) {
                readLength = (int)((double)(endtime - wave.getStartTime()) * samprate / 1000.0) - readOffset;
            }
            System.arraycopy(wavesamp, readOffset, samples, recordOffset, readLength);
        }
        return samples;
    }

    public double[] getAllSamplesZeroAverage(long starttime, long endtime) {
        return this.getAllSamplesZeroAverage(starttime, endtime, false);
    }

    public double[] getAllSamplesZeroAverage(long starttime, long endtime, boolean zeroaverage) {
        double[] samples = this.getAllSamples(starttime, endtime);
        double average = 0.0;
        if (!zeroaverage) {
            for (int i = 0; i < samples.length; ++i) {
                average += samples[i];
            }
            average /= (double)samples.length;
        }
        double[] zsamples = new double[samples.length];
        this.maxVal = Double.NEGATIVE_INFINITY;
        this.minVal = Double.POSITIVE_INFINITY;
        for (int i = 0; i < samples.length; ++i) {
            zsamples[i] = samples[i] - average;
            if (zsamples[i] > this.maxVal) {
                this.maxVal = zsamples[i];
            }
            if (!(zsamples[i] < this.minVal)) continue;
            this.minVal = zsamples[i];
        }
        return zsamples;
    }
}

