/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.wavesources;

import java.util.List;
import pickewanalysis.waveform.WaveForm;
import pickewanalysis.waveform.WaveFormGroup;
import pickewanalysis.wavesources.WaveSource;
import pickewanalysis.wavesources.WaveSourceStation;

public class TankFile
extends WaveSource {
    List<WaveFormGroup> groups;

    @Override
    public void update() throws Exception {
        this.clear();
        this.groups = WaveFormGroup.parseTankFile(this.sourceName).splitStations();
        for (WaveFormGroup group : this.groups) {
            WaveSourceStation station = new WaveSourceStation(((WaveForm)group.get(0)).getStation(), ((WaveForm)group.get(0)).getChannel(), ((WaveForm)group.get(0)).getNetwork(), ((WaveForm)group.get(0)).getLocation(), ((WaveForm)group.get(0)).getStartTime(), ((WaveForm)group.get(group.size() - 1)).getEndTime());
            this.add(station);
        }
    }

    @Override
    public WaveFormGroup read(String stat, String chan, String net, String loc, long starttime, long endtime) throws Exception {
        if (this.groups == null) {
            this.clear();
            this.groups = WaveFormGroup.parseTankFile(this.sourceName).splitStations();
        }
        for (WaveFormGroup group : this.groups) {
            if (!group.containsStation(stat, chan, net, loc)) continue;
            WaveFormGroup output = new WaveFormGroup();
            for (WaveForm wave : group) {
                if (wave.getStartTime() >= endtime || wave.getEndTime() <= starttime) continue;
                output.add(wave);
            }
            return output;
        }
        return null;
    }
}

