/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.wavesources;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Locale;
import pickewanalysis.waveform.WaveFormGroup;
import pickewanalysis.wavesources.WSMenu;
import pickewanalysis.wavesources.WSMenuItem;
import pickewanalysis.wavesources.WaveSource;
import pickewanalysis.wavesources.WaveSourceStation;

public class WaveServer
extends WaveSource {
    private static int requestID = 1;
    private Socket socket;
    private DataInputStream Sinput;
    private DataOutputStream Soutput;
    public int TimeOutInterval = 5000;
    public int ReadMargin = 30000;

    @Override
    public void update() throws Exception {
        this.clear();
        WSMenu wsm = this.getMenu();
        if (wsm == null) {
            return;
        }
        for (WSMenuItem item : wsm) {
            WaveSourceStation station = new WaveSourceStation(item.getStation(), item.getChannel(), item.getNetwork(), item.getLocation(), item.getStartTime(), item.getEndTime());
            this.add(station);
        }
    }

    public String getIP() {
        String[] parts = this.sourceName.split("[:]+");
        return parts[0];
    }

    public int getPort() {
        String[] parts = this.sourceName.split("[:]+");
        return Integer.valueOf(parts[1]);
    }

    @Override
    public WaveFormGroup read(String stat, String chan, String net, String loc, long starttime, long endtime) throws Exception {
        int counter;
        byte b;
        this.getMenu();
        this.connect();
        int curReqID = this.getReqID();
        String request = String.format(Locale.UK, "GETSCNLRAW: %d %s %s %s %s %8.6f %8.6f SCNL\n", curReqID, stat, chan, net, loc, (double)(starttime - (long)this.ReadMargin) / 1000.0, (double)(endtime + (long)this.ReadMargin) / 1000.0);
        this.Soutput.write(request.getBytes());
        this.Soutput.flush();
        String response = "";
        while ((b = this.Sinput.readByte()) != 10) {
            response = response + (char)b;
        }
        String[] parts = null;
        parts = response.trim().split("[\\s]+");
        if (parts == null || !parts[6].equals("F")) {
            this.close();
            return null;
        }
        int nbytes = Integer.valueOf(parts[10]);
        int ntries = 0;
        byte[] rawdata = new byte[nbytes];
        try {
            for (counter = 0; counter < nbytes && ntries < 10; counter += this.Sinput.read(rawdata, counter, nbytes - counter)) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.close();
        if (counter != nbytes) {
            return null;
        }
        WaveFormGroup wfg = WaveFormGroup.parseTraceBuf2(rawdata);
        return wfg;
    }

    private WSMenu getMenu() throws Exception {
        this.connect();
        int curReqID = this.getReqID();
        String request = String.format(Locale.UK, "MENU: %d SCNL\n", curReqID);
        this.Soutput.write(request.getBytes());
        this.Soutput.flush();
        BufferedReader Binput = new BufferedReader(new InputStreamReader(this.Sinput));
        String[] parts = null;
        try {
            String response;
            while (Integer.valueOf((parts = (response = Binput.readLine()).trim().split("[\\s]+"))[0]) != curReqID) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (parts == null) {
            this.close();
            return null;
        }
        int nsta = (parts.length - 1) / 8;
        if (nsta == 0) {
            this.close();
            return null;
        }
        WSMenu menu = new WSMenu(nsta);
        for (int i = 0; i < nsta; ++i) {
            int p = i * 8 + 2;
            WSMenuItem wsmi = new WSMenuItem(parts[p + 0], parts[p + 1], parts[p + 2], parts[p + 3], (long)(Double.valueOf(parts[p + 4]) * 1000.0), (long)(Double.valueOf(parts[p + 5]) * 1000.0 + 1.0));
            menu.add(wsmi);
        }
        this.close();
        return menu;
    }

    private void connect() throws Exception {
        this.socket = new Socket(this.getIP(), this.getPort());
        this.socket.setSoTimeout(this.TimeOutInterval);
        this.Sinput = new DataInputStream(this.socket.getInputStream());
        this.Soutput = new DataOutputStream(this.socket.getOutputStream());
    }

    private void close() throws Exception {
        this.Sinput.close();
        this.Soutput.close();
        this.socket.close();
    }

    private int getReqID() {
        return requestID++;
    }
}

