/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.wavesources;

import java.util.ArrayList;
import org.simpleframework.xml.Element;
import pickewanalysis.waveform.WaveFormGroup;
import pickewanalysis.wavesources.WaveSourceStation;

public abstract class WaveSource
extends ArrayList<WaveSourceStation> {
    @Element
    String sourceName;

    public boolean isSCNL(String stat, String chan, String net, String loc, long starttime, long endtime) {
        for (WaveSourceStation station : this) {
            if (!station.isSCNL(stat, chan, net, loc) || station.starttime >= endtime || station.endtime <= starttime) continue;
            return true;
        }
        return false;
    }

    public WaveSourceStation findStation(String stat, String chan, String net, String loc) {
        for (WaveSourceStation station : this) {
            if (!station.isSCNL(stat, chan, net, loc)) continue;
            return station;
        }
        return null;
    }

    public void setName(String name) {
        this.sourceName = name;
    }

    @Override
    public String toString() {
        return this.sourceName;
    }

    public abstract void update() throws Exception;

    public abstract WaveFormGroup read(String var1, String var2, String var3, String var4, long var5, long var7) throws Exception;
}

