/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.B1000Types;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.Steim1;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.USNSN;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.iris.dmc.seedcodec.Utility;

public class Codec
implements B1000Types {
    /*
     * WARNING - void declaration
     */
    public DecompressedData decompress(int type, byte[] b, int numSamples, boolean swapBytes) throws CodecException, UnsupportedCompressionType {
        void var5_11;
        int offset = 0;
        switch (type) {
            case 1: {
                if (b.length < 2 * numSamples) {
                    throw new IllegalArgumentException("Not enough bytes for " + numSamples + " 16 bit data points, only " + b.length + " bytes.");
                }
                short[] stemp = new short[numSamples];
                for (int i = 0; i < stemp.length; ++i) {
                    stemp[i] = Utility.bytesToShort(b[offset], b[offset + 1], swapBytes);
                    offset += 2;
                }
                DecompressedData out = new DecompressedData(stemp);
                break;
            }
            case 2: {
                if (b.length < 3 * numSamples) {
                    throw new IllegalArgumentException("Not enough bytes for " + numSamples + " 24 bit data points, only " + b.length + " bytes.");
                }
                int[] itemp = new int[numSamples];
                for (int i = 0; i < numSamples; ++i) {
                    itemp[i] = Utility.bytesToInt(b[offset], b[offset + 1], b[offset + 2], swapBytes);
                    offset += 3;
                }
                DecompressedData out = new DecompressedData(itemp);
                break;
            }
            case 3: {
                if (b.length < 4 * numSamples) {
                    throw new IllegalArgumentException("Not enough bytes for " + numSamples + " 32 bit data points, only " + b.length + " bytes.");
                }
                int[] itemp = new int[numSamples];
                for (int i = 0; i < numSamples; ++i) {
                    itemp[i] = Utility.bytesToInt(b[offset], b[offset + 1], b[offset + 2], b[offset + 3], swapBytes);
                    offset += 4;
                }
                DecompressedData out = new DecompressedData(itemp);
                break;
            }
            case 4: {
                if (b.length < 4 * numSamples) {
                    throw new IllegalArgumentException("Not enough bytes for " + numSamples + " 32 bit data points, only " + b.length + " bytes.");
                }
                float[] ftemp = new float[numSamples];
                for (int i = 0; i < numSamples; ++i) {
                    ftemp[i] = Float.intBitsToFloat(Utility.bytesToInt(b[offset], b[offset + 1], b[offset + 2], b[offset + 3], swapBytes));
                    offset += 4;
                }
                DecompressedData out = new DecompressedData(ftemp);
                break;
            }
            case 5: {
                if (b.length < 8 * numSamples) {
                    throw new IllegalArgumentException("Not enough bytes for " + numSamples + " 64 bit data points, only " + b.length + " bytes.");
                }
                throw new UnsupportedCompressionType("Type " + type + " is not supported at this time.");
            }
            case 10: {
                int[] itemp = Steim1.decode(b, numSamples, swapBytes, 0);
                DecompressedData out = new DecompressedData(itemp);
                break;
            }
            case 11: {
                int[] itemp = Steim2.decode(b, numSamples, swapBytes, 0);
                DecompressedData out = new DecompressedData(itemp);
                break;
            }
            case 15: {
                int[] itemp = USNSN.decode(b, numSamples, swapBytes, 0);
                DecompressedData out = new DecompressedData(itemp);
                break;
            }
            default: {
                throw new UnsupportedCompressionType("Type " + type + " is not supported at this time.");
            }
        }
        return var5_11;
    }

    public int getDecompressedType(int type) throws UnsupportedCompressionType {
        if (type == 2 || type == 3 || type == 10 || type == 11) {
            return 3;
        }
        if (type == 1) {
            return 1;
        }
        if (type == 4) {
            return 4;
        }
        if (type == 5) {
            return 5;
        }
        throw new UnsupportedCompressionType("Type " + type + " is not supported at this time.");
    }
}

