/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.builder.BuilderFilter;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.exception.BuilderException;
import java.util.Vector;

public class SeedBuilderFilter
extends BuilderFilter {
    public SeedBuilderFilter() {
        this.addParameter("TIME_ZERO", "0000,000,00:00:00.0000");
        this.addParameter("TIME_INF", "2500,365,23:59:59.9999");
        this.filterType = "SEED";
    }

    public boolean qualify(Object o) throws BuilderException {
        float blkVersion;
        Blockette blk = (Blockette)o;
        int blkType = blk.getType();
        try {
            blkVersion = blk.getVersion();
        }
        catch (Exception e) {
            throw new BuilderException(e.toString());
        }
        switch (blkType) {
            case 50: {
                boolean testStation = this.testCompare("station", null, blk, 3);
                boolean testNetwork = true;
                if ((double)blkVersion >= 2.3) {
                    testNetwork = this.testCompare("network", null, blk, 16);
                }
                boolean testLatitude = this.testCompare("min_lat", "max_lat", blk, 4);
                boolean testLongitude = this.testCompare("min_lon", "max_lon", blk, 5);
                boolean testElevation = this.testCompare("min_elev", "max_elev", blk, 6);
                boolean testStart = this.testCompare("start_time", "TIME_INF", blk, 14);
                boolean testEnd = this.testCompare("TIME_ZERO", "end_time", blk, 13);
                return testStation && testNetwork && testLatitude && testLongitude && testElevation && testStart && testEnd;
            }
            case 52: {
                boolean testLocation = this.testCompare("location", null, blk, 3);
                boolean testChannel = this.testCompare("channel", null, blk, 4);
                boolean testStart = this.testCompare("start_time", "TIME_INF", blk, 23);
                boolean testEnd = this.testCompare("TIME_ZERO", "end_time", blk, 22);
                return testLocation && testChannel && testStart && testEnd;
            }
            case 72: {
                boolean testStation = this.testCompare("station", null, blk, 3);
                boolean testLocation = this.testCompare("location", null, blk, 4);
                boolean testChannel = this.testCompare("channel", null, blk, 5);
                boolean testNetwork = true;
                if ((double)blkVersion >= 2.3) {
                    testNetwork = this.testCompare("network", null, blk, 12);
                }
                return testStation && testLocation && testChannel && testNetwork;
            }
            case 73: {
                boolean testStation = this.testCompare("station", null, blk, 4);
                boolean testLocation = this.testCompare("location", null, blk, 5);
                boolean testChannel = this.testCompare("channel", null, blk, 6);
                boolean testTime = this.testCompare("start_time", "end_time", blk, 7);
                return testStation && testLocation && testChannel && testTime;
            }
            case 74: {
                boolean testStation = this.testCompare("station", null, blk, 3);
                boolean testLocation = this.testCompare("location", null, blk, 4);
                boolean testChannel = this.testCompare("channel", null, blk, 5);
                boolean testStart = this.testCompare("start_time", "TIME_INF", blk, 9);
                boolean testEnd = this.testCompare("TIME_ZERO", "end_time", blk, 6);
                boolean testNetwork = true;
                if ((double)blkVersion >= 2.3) {
                    testNetwork = this.testCompare("network", null, blk, 16);
                }
                return testStation && testLocation && testChannel && testStart && testEnd && testNetwork;
            }
            case 999: {
                boolean testStation = this.testCompare("station", null, blk, 4);
                boolean testLocation = this.testCompare("location", null, blk, 5);
                boolean testChannel = this.testCompare("channel", null, blk, 6);
                boolean testNetwork = true;
                if ((double)blkVersion >= 2.3) {
                    testNetwork = this.testCompare("network", null, blk, 7);
                }
                boolean testTime = this.testCompare("start_time", "end_time", blk, 8);
                return testStation && testLocation && testChannel && testNetwork && testTime;
            }
        }
        return true;
    }

    public boolean testCompare(String param1, String param2, Blockette blk, int blkField) {
        String bValue = blk.toString(blkField);
        return this.testCompare(param1, param2, bValue);
    }

    public boolean testCompare(String param1, String param2, String bValue) {
        Vector vParam1 = this.getParameter(param1);
        Vector vParam2 = this.getParameter(param2);
        if (vParam1 == null) {
            return true;
        }
        int i = 0;
        while (i < vParam1.size()) {
            String eParam1 = vParam1.get(i).toString();
            if (vParam2 == null) {
                if (param1.equals("TIME_ZERO")) {
                    return true;
                }
                if (this.globMatch(eParam1, bValue)) {
                    return true;
                }
            } else if (i < vParam2.size()) {
                String eParam2 = vParam2.get(i).toString();
                if (this.numCompare(eParam1, bValue) <= 0 && this.numCompare(eParam2, bValue) >= 0) {
                    return true;
                }
            } else {
                return false;
            }
            ++i;
        }
        return false;
    }
}

