/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.exception.SeedInputException;
import edu.iris.Fissures.seed.util.Utility;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Btime
extends SeedObject {
    private int year = 2500;
    private int jday = 1;
    private int hour = 0;
    private int min = 0;
    private int sec = 0;
    private int tenthMilli = 0;
    private boolean swapFlag = false;
    private StringBuffer formatErrors;
    private int[] timeArr = new int[]{2500, 1, 0, 0, 0, 0};
    private static TimeZone tz = null;
    private static DecimalFormat twoZero = null;
    private static DecimalFormat threeZero = null;
    private static DecimalFormat fourZero = null;
    private static final int[] defaultTimes = new int[]{2500, 1, 0, 0, 0, 0};
    private static final String[] tokenizeTimes = new String[]{",", ",", ":", ":", ".", " "};

    public Btime() throws SeedInputException {
        this.formatErrors = new StringBuffer();
        GregorianCalendar mCal = new GregorianCalendar(tz);
        StringBuffer mBuf = new StringBuffer();
        mBuf.append(mCal.get(1));
        mBuf.append(",");
        mBuf.append(mCal.get(6));
        mBuf.append(",");
        mBuf.append(mCal.get(11));
        mBuf.append(":");
        mBuf.append(mCal.get(12));
        mBuf.append(":");
        mBuf.append(mCal.get(13));
        this.setString(mBuf.toString());
        this.formatCheck();
    }

    public Btime(byte[] timeArr, boolean byteSwapFlag) throws SeedInputException {
        if (timeArr.length < 10) {
            throw new SeedInputException("input array is too small (" + timeArr.length + " bytes)");
        }
        this.formatErrors = new StringBuffer();
        this.swapFlag = byteSwapFlag;
        this.year = Utility.uBytesToInt(timeArr[0], timeArr[1], this.swapFlag);
        this.jday = Utility.uBytesToInt(timeArr[2], timeArr[3], this.swapFlag);
        this.hour = timeArr[4] & 0xFF;
        this.min = timeArr[5] & 0xFF;
        this.sec = timeArr[6] & 0xFF;
        this.tenthMilli = Utility.uBytesToInt(timeArr[8], timeArr[9], this.swapFlag);
        this.formatCheck();
    }

    public Btime(byte[] timeArr) throws SeedInputException {
        if (timeArr.length < 10) {
            throw new SeedInputException("input array is too small (" + timeArr.length + " bytes)");
        }
        this.formatErrors = new StringBuffer();
        this.year = Utility.uBytesToInt(timeArr[0], timeArr[1], false);
        this.swapFlag = this.year < 1900 || this.year > 2050;
        this.year = Utility.uBytesToInt(timeArr[0], timeArr[1], this.swapFlag);
        this.jday = Utility.uBytesToInt(timeArr[2], timeArr[3], this.swapFlag);
        this.hour = timeArr[4] & 0xFF;
        this.min = timeArr[5] & 0xFF;
        this.sec = timeArr[6] & 0xFF;
        this.tenthMilli = Utility.uBytesToInt(timeArr[8], timeArr[9], this.swapFlag);
        this.formatCheck();
    }

    public Btime(String timeString) throws SeedInputException {
        this.formatErrors = new StringBuffer();
        this.setString(timeString);
        this.formatCheck();
    }

    public int getType() {
        return 10000;
    }

    public int getLookupId() {
        return (int)this.getEpochTime();
    }

    public byte[] getByteTime() {
        byte[] timeArr = new byte[10];
        System.arraycopy(Utility.intToShortBytes(this.year), 0, timeArr, 0, 2);
        System.arraycopy(Utility.intToShortBytes(this.jday), 0, timeArr, 2, 2);
        timeArr[4] = (byte)this.hour;
        timeArr[5] = (byte)this.min;
        timeArr[6] = (byte)this.sec;
        timeArr[7] = 0;
        System.arraycopy(Utility.intToShortBytes(this.tenthMilli), 0, timeArr, 8, 2);
        return timeArr;
    }

    public String getStringTime() {
        StringBuffer strTimeBuf = new StringBuffer();
        strTimeBuf.append(fourZero.format(this.year));
        strTimeBuf.append(",");
        strTimeBuf.append(threeZero.format(this.jday));
        strTimeBuf.append(",");
        strTimeBuf.append(twoZero.format(this.hour));
        strTimeBuf.append(":");
        strTimeBuf.append(twoZero.format(this.min));
        strTimeBuf.append(":");
        strTimeBuf.append(twoZero.format(this.sec));
        strTimeBuf.append(".");
        strTimeBuf.append(fourZero.format(this.tenthMilli));
        return strTimeBuf.toString();
    }

    public String toString() {
        return this.getStringTime();
    }

    public long getEpochTime() {
        long seconds = 0L;
        int i = this.year;
        while (i < 1970) {
            boolean is_leap;
            seconds -= 31536000L;
            boolean bl = is_leap = i % 4 == 0 && i % 100 != 0 || i % 400 == 0;
            if (is_leap) {
                seconds -= 86400L;
            }
            ++i;
        }
        int i2 = 1970;
        while (i2 < this.year) {
            boolean is_leap;
            seconds += 31536000L;
            boolean bl = is_leap = i2 % 4 == 0 && i2 % 100 != 0 || i2 % 400 == 0;
            if (is_leap) {
                seconds += 86400L;
            }
            ++i2;
        }
        return seconds += (long)(this.ttConvert() / 10000.0);
    }

    public boolean equals(Btime compareTime) {
        return this.toString().equals(compareTime.toString());
    }

    public long diffSeconds(Btime minusTime) {
        return this.getEpochTime() - minusTime.getEpochTime();
    }

    public boolean getSwapFlag() {
        return this.swapFlag;
    }

    public String getError() {
        return this.formatErrors.toString();
    }

    public int compareTo(Object o) throws ClassCastException {
        double thatTT;
        if (o == null) {
            throw new ClassCastException("null parameter value");
        }
        Btime compareTime = (Btime)o;
        long lDiff = this.diffSeconds(compareTime);
        if (lDiff < 0L) {
            return -1;
        }
        if (lDiff > 0L) {
            return 1;
        }
        double thisTT = this.ttConvert();
        if (thisTT < (thatTT = compareTime.ttConvert())) {
            return -1;
        }
        if (thisTT > thatTT) {
            return 1;
        }
        return 0;
    }

    public Btime projectTime(double tenThousandths) throws SeedInputException {
        boolean is_leap;
        Btime bTime = new Btime(this.getStringTime());
        int offset = 0;
        boolean bl = is_leap = this.year % 4 == 0 && this.year % 100 != 0 || this.year % 400 == 0;
        if (is_leap) {
            offset = 1;
        }
        if ((tenThousandths += this.ttConvert()) >= (double)(366 + offset) * 8.64E8) {
            ++bTime.year;
            tenThousandths -= (double)(365 + offset) * 8.64E8;
        }
        bTime.jday = (int)(tenThousandths / 8.64E8);
        ++bTime.jday;
        bTime.hour = (int)((tenThousandths -= (double)bTime.jday * 8.64E8) / 3.6E7);
        bTime.min = (int)((tenThousandths -= (double)bTime.hour * 3.6E7) / 600000.0);
        bTime.sec = (int)((tenThousandths -= (double)bTime.min * 600000.0) / 10000.0);
        bTime.tenthMilli = (int)(tenThousandths -= (double)bTime.sec * 10000.0);
        return bTime;
    }

    public static String getMonthDay(int year, int jday) {
        GregorianCalendar mCal = new GregorianCalendar(tz);
        mCal.setLenient(true);
        mCal.set(1, year);
        mCal.set(6, jday);
        mCal.set(11, 0);
        mCal.set(12, 0);
        mCal.set(13, 0);
        int month = mCal.get(2) + 1;
        String mStr = "" + fourZero.format(mCal.get(1)) + "/" + twoZero.format(month) + "/" + twoZero.format(mCal.get(5));
        return mStr;
    }

    public static String getJulianDay(int year, int month, int day) {
        GregorianCalendar mCal = new GregorianCalendar(tz);
        mCal.setLenient(true);
        mCal.set(1, year);
        mCal.set(2, month - 1);
        mCal.set(5, day);
        mCal.set(11, 0);
        mCal.set(12, 0);
        mCal.set(13, 0);
        String mStr = "" + fourZero.format(mCal.get(1)) + "/" + threeZero.format(mCal.get(6));
        return mStr;
    }

    public int getYear() {
        return this.year;
    }

    public int getDayOfYear() {
        return this.jday;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.min;
    }

    public int getSecond() {
        return this.sec;
    }

    public int getTenthMill() {
        return this.tenthMilli;
    }

    public void setYear(int i) {
        this.year = i;
    }

    public void setDayOfYear(int i) {
        this.jday = i;
    }

    public void setHour(int i) {
        this.hour = i;
    }

    public void setMinute(int i) {
        this.min = i;
    }

    public void setSecond(int i) {
        this.sec = i;
    }

    public void setTenthMill(int i) {
        this.tenthMilli = i;
    }

    protected double ttConvert() {
        double tenThousandths = (double)(this.jday - 1) * 8.64E8;
        tenThousandths += (double)this.hour * 3.6E7;
        tenThousandths += (double)this.min * 600000.0;
        tenThousandths += (double)this.sec * 10000.0;
        return tenThousandths += (double)this.tenthMilli;
    }

    private void setString(String timeString) {
        int begin = 0;
        int end = 0;
        int strLen = timeString.length();
        int i = 0;
        while (i < defaultTimes.length) {
            this.timeArr[i] = defaultTimes[i];
            if (begin < strLen) {
                end = timeString.indexOf(tokenizeTimes[i], begin);
                if (end <= begin) {
                    this.timeArr[i] = Integer.parseInt(timeString.substring(begin));
                    begin = strLen;
                } else {
                    this.timeArr[i] = Integer.parseInt(timeString.substring(begin, end));
                    begin = end + 1;
                }
            }
            ++i;
        }
        this.year = this.timeArr[0];
        this.jday = this.timeArr[1];
        this.hour = this.timeArr[2];
        this.min = this.timeArr[3];
        this.sec = this.timeArr[4];
        this.tenthMilli = this.timeArr[5];
    }

    private void formatCheck() {
        if (this.year < 1900 || this.year > 9999) {
            this.formatErrors.append("Invalid year " + this.year);
        }
        if (this.jday < 1 || this.jday > 366) {
            this.formatErrors.append("Invalid day of year " + this.jday);
        }
        if (this.hour < 0 || this.hour > 23) {
            this.formatErrors.append("Invalid hour " + this.hour);
        }
        if (this.min < 0 || this.min > 59) {
            this.formatErrors.append("Invalid minute " + this.min);
        }
        if (this.sec < 0 || this.sec > 59) {
            this.formatErrors.append("Invalid second " + this.sec);
        }
        if (this.tenthMilli < 0 || this.tenthMilli > 9999) {
            this.formatErrors.append("Invalid fraction second " + this.tenthMilli);
        }
    }

    static {
        tz = TimeZone.getTimeZone("GMT+00");
        twoZero = new DecimalFormat("00");
        threeZero = new DecimalFormat("000");
        fourZero = new DecimalFormat("0000");
    }
}

