/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.codec.Steim1;
import edu.iris.Fissures.codec.Steim2;
import edu.iris.Fissures.codec.SteimFrameBlock;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedInputException;

public class Waveform
extends SeedObject {
    private byte[] waveData = null;
    private int numSamples = 0;
    private String encoding = "none";
    private boolean swapBytes = false;

    public Waveform(byte[] record, int dataOffset, int numSamples, String encoding, boolean swapBytes) {
        this.waveData = new byte[record.length - dataOffset];
        System.arraycopy(record, dataOffset, this.waveData, 0, this.waveData.length);
        this.numSamples = numSamples;
        this.swapBytes = swapBytes;
        this.encoding = encoding;
    }

    public Waveform(int[] intData, int maxByteLen, String encoding, int bias) throws Exception {
        this.encodeWaveform(intData, maxByteLen, encoding, bias);
    }

    public Waveform(int[] intData, int maxByteLen, String encoding) throws Exception {
        this.encodeWaveform(intData, maxByteLen, encoding);
    }

    public Waveform(float[] floatData, int maxByteLen, String encoding, float bias) throws Exception {
        this.encodeWaveform(floatData, maxByteLen, encoding, bias);
    }

    public Waveform(float[] floatData, int maxByteLen, String encoding) throws Exception {
        this.encodeWaveform(floatData, maxByteLen, encoding);
    }

    public int getType() {
        return 20000;
    }

    public int getLookupId() {
        return 0;
    }

    public int[] getDecodedIntegers(int bias) throws Exception {
        if (this.waveData.length == 0 || this.numSamples < 1) {
            throw new SeedException("attempting read on empty data stream");
        }
        if (this.encoding.equals("Steim1")) {
            return Steim1.decode(this.waveData, this.numSamples, this.swapBytes, bias);
        }
        if (this.encoding.equals("Steim2")) {
            return Steim2.decode(this.waveData, this.numSamples, this.swapBytes, bias);
        }
        throw new SeedException("format " + this.encoding + " unavailable for integer decoding");
    }

    public int[] getDecodedIntegers() throws Exception {
        return this.getDecodedIntegers(0);
    }

    public float[] getDecodedFloats(float bias) throws Exception {
        int[] intDecode = null;
        if (this.encoding.equals("Steim1")) {
            intDecode = Steim1.decode(this.waveData, this.numSamples, this.swapBytes, (int)bias);
        } else if (this.encoding.equals("Steim2")) {
            intDecode = Steim2.decode(this.waveData, this.numSamples, this.swapBytes, (int)bias);
        } else {
            throw new SeedException("format " + this.encoding + " unavailable for float decoding");
        }
        if (intDecode != null) {
            float[] floatDecode = new float[intDecode.length];
            int i = 0;
            while (i < intDecode.length) {
                floatDecode[i] = intDecode[i];
                ++i;
            }
            return floatDecode;
        }
        return null;
    }

    public float[] getDecodedFloats() throws Exception {
        return this.getDecodedFloats(0.0f);
    }

    public byte[] getEncodedBytes() throws Exception {
        return this.waveData;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public boolean getSwapBytes() {
        return this.swapBytes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setNumSamples(int samples) {
        this.numSamples = samples;
    }

    public void setSwapBytes(boolean flag) {
        this.swapBytes = flag;
    }

    public void setEncoding(String format) {
        this.encoding = format;
    }

    public String toString() {
        return "Waveform data with " + this.numSamples + " samples in " + this.waveData.length + " bytes with " + this.encoding + " encoding and byte swap is " + this.swapBytes + ".";
    }

    private void encodeWaveform(int[] data, int maxByteLen, String encoding, int bias) throws Exception {
        if (data.length == 0) {
            throw new SeedInputException("data length is zero");
        }
        if (!encoding.equals("Steim1")) {
            throw new SeedException("format " + encoding + " unavailable for integer encoding");
        }
        int steimFrameLen = 64;
        int numFrames = maxByteLen / steimFrameLen;
        SteimFrameBlock steimFrames = Steim1.encode(data, numFrames, bias);
        this.waveData = steimFrames.getEncodedData();
        this.numSamples = steimFrames.getNumSamples();
        this.encoding = "Steim1";
        this.swapBytes = false;
    }

    private void encodeWaveform(int[] data, int maxByteLen, String encoding) throws Exception {
        this.encodeWaveform(data, maxByteLen, encoding, 0);
    }

    private void encodeWaveform(float[] data, int maxByteLen, String encoding, float bias) throws Exception {
        if (data.length == 0) {
            throw new SeedInputException("data length is zero");
        }
        if (encoding.equals("someEncoding")) {
            return;
        }
        throw new SeedException("format " + encoding + " unavailable for float encoding");
    }

    private void encodeWaveform(float[] data, int maxByteLen, String encoding) throws Exception {
        this.encodeWaveform(data, maxByteLen, encoding, 0.0f);
    }

    public static void main(String[] args) {
        try {
            int[] intData = new int[4096];
            int curNum = 45623;
            int i = 0;
            while (i < 4096) {
                intData[i] = curNum;
                if ((curNum += 9731) > 54622465) {
                    curNum -= 91;
                }
                ++i;
            }
            Waveform myWaveform = new Waveform(intData, 3968, "Steim1");
            if (myWaveform == null) {
                throw new SeedException("NULL myWaveform returned");
            }
            int numSamples = myWaveform.getNumSamples();
            System.out.println("I have " + myWaveform.getEncoding() + " encoded " + numSamples + " samples out of " + intData.length + " samples entered.");
            int[] intDecode = myWaveform.getDecodedIntegers();
            StringBuffer intBuffer = new StringBuffer();
            int i2 = numSamples - 100;
            while (i2 < numSamples) {
                if (i2 < 0) {
                    i2 = 0;
                }
                intBuffer.append(intDecode[i2]);
                intBuffer.append(",");
                ++i2;
            }
            System.out.println("Decoding those values gives me this: " + intBuffer.toString());
            intBuffer = new StringBuffer();
            int i3 = numSamples - 100;
            while (i3 < numSamples) {
                if (i3 < 0) {
                    i3 = 0;
                }
                intBuffer.append(intData[i3]);
                intBuffer.append(",");
                ++i3;
            }
            System.out.println("The original values consisted of   : " + intBuffer.toString());
        }
        catch (Exception e) {
            System.out.println("Caught exception: " + e);
            e.printStackTrace();
        }
    }
}

