/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.SCN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Menu {
    private List<MenuItem> items = new ArrayList<MenuItem>();
    private boolean scnl = false;

    public Menu(String menu) {
        this.parseMenu(menu);
    }

    public boolean isSCNL() {
        return this.scnl;
    }

    public List<MenuItem> getItems() {
        return this.items;
    }

    public List<MenuItem> getSortedItems() {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>(this.items);
        Collections.sort(list);
        return list;
    }

    public int numItems() {
        return this.items.size();
    }

    public MenuItem getItem(int i) {
        return this.items.get(i);
    }

    public MenuItem getItem(SCN scn) {
        return this.getItem(scn.station, scn.channel, scn.network);
    }

    public boolean channelExists(String channel) {
        int i = 0;
        while (i < this.items.size()) {
            MenuItem mi = this.items.get(i);
            if (mi.getWinstonChannel().equals(channel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MenuItem getItem(String station, String channel, String network) {
        int i = 0;
        while (i < this.items.size()) {
            MenuItem mi = this.items.get(i);
            if (mi.isSCN(station, channel, network)) {
                return mi;
            }
            ++i;
        }
        return null;
    }

    public void parseMenu(String menu) {
        int i;
        menu = menu.substring(menu.indexOf("  ") + 2);
        while ((i = menu.indexOf("  ")) != -1) {
            String item = menu.substring(0, i);
            this.items.add(new MenuItem(item));
            menu = menu.substring(i + 2);
        }
        MenuItem mi = new MenuItem(menu);
        if (mi.getLocation() != null) {
            this.scnl = true;
        }
        this.items.add(mi);
    }

    public int getStationPIN(String station, String channel, String network) {
        int i = 0;
        while (i < this.items.size()) {
            MenuItem mi = this.items.get(i);
            if (mi.isSCN(station, channel, network)) {
                return mi.getPIN();
            }
            ++i;
        }
        return -1;
    }

    public void output() {
        int i = 0;
        while (i < this.items.size()) {
            System.out.println(this.items.get(i).toFullString());
            ++i;
        }
    }
}

