/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.TraceBuf;
import gov.usgs.net.InternetClient;
import gov.usgs.util.Retriable;
import gov.usgs.vdx.data.wave.Wave;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

public class WaveServer
extends InternetClient {
    public WaveServer() {
    }

    public WaveServer(String sp) {
        super(sp);
    }

    public WaveServer(String s, int p) {
        super(s, p);
    }

    public Menu getMenu() {
        return this.getMenu("ID");
    }

    public Menu getMenu(final String reqID) {
        Retriable<Menu> mr = new Retriable<Menu>("WaveServer.getMenu()", this.maxRetries){

            @Override
            public void attemptFix() {
                WaveServer.this.close();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WaveServer.this.connected()) {
                        WaveServer.this.connect();
                    }
                    WaveServer.this.writeString("MENU: " + reqID + "\n");
                    String info = WaveServer.this.readString();
                    this.result = new Menu(info);
                    return true;
                }
                catch (Exception e) {
                    WaveServer.this.logger.warning("getMenu() IOException: " + e.getMessage());
                    return false;
                }
            }
        };
        return (Menu)mr.go();
    }

    public Menu getMenuSCNL() {
        return this.getMenuSCNL("ID");
    }

    public Menu getMenuSCNL(final String reqID) {
        Retriable<Menu> mr = new Retriable<Menu>("WaveServer.getMenuSCNL()", this.maxRetries){

            @Override
            public void attemptFix() {
                WaveServer.this.close();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WaveServer.this.connected()) {
                        WaveServer.this.connect();
                    }
                    WaveServer.this.writeString("MENU: " + reqID + " SCNL\n");
                    String info = WaveServer.this.readString();
                    this.result = new Menu(info);
                    return true;
                }
                catch (Exception e) {
                    WaveServer.this.logger.warning("getMenuSCNL() IOException: " + e.getMessage());
                    return false;
                }
            }
        };
        return (Menu)mr.go();
    }

    public MenuItem getMenuItem(final int pin) {
        Retriable<MenuItem> rt = new Retriable<MenuItem>("WaveServer.getMenuItem()", this.maxRetries){

            @Override
            public void attemptFix() {
                WaveServer.this.close();
                WaveServer.this.connect();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WaveServer.this.connected()) {
                        WaveServer.this.connect();
                    }
                    WaveServer.this.writeString("MENUPIN: ID " + pin + "\n");
                    String info = WaveServer.this.readString();
                    this.result = new MenuItem(info.substring(4));
                    return true;
                }
                catch (Exception e) {
                    WaveServer.this.logger.warning("getMenuItem() IOException: " + e.getMessage());
                    return false;
                }
            }
        };
        return (MenuItem)rt.go();
    }

    public MenuItem getMenuItem(final String st, final String ch, final String nw) {
        Retriable<MenuItem> rt = new Retriable<MenuItem>("WaveServer.getMenuItem()", this.maxRetries){

            @Override
            public void attemptFix() {
                WaveServer.this.close();
                WaveServer.this.connect();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WaveServer.this.connected()) {
                        WaveServer.this.connect();
                    }
                    WaveServer.this.writeString("MENUSCN: ID " + st + " " + ch + " " + nw + "\n");
                    String info = WaveServer.this.readString();
                    this.result = new MenuItem(info.substring(4));
                    return true;
                }
                catch (Exception e) {
                    WaveServer.this.logger.warning("getMenuSCNL() IOException: " + e.getMessage());
                    return false;
                }
            }
        };
        return (MenuItem)rt.go();
    }

    public String getAsciiData(final String station, final String comp, final String network, final double start, final double end) {
        Retriable<String> rt = new Retriable<String>("WaveServer.getAsciiData()", this.maxRetries){

            @Override
            public void attemptFix() {
                WaveServer.this.close();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WaveServer.this.connected()) {
                        WaveServer.this.connect();
                    }
                    String req = "GETSCN: GS " + station + " " + comp + " " + network + " " + start + " " + end + " 0\n";
                    WaveServer.this.writeString(req);
                    this.result = WaveServer.this.readString();
                    return true;
                }
                catch (Exception e) {
                    WaveServer.this.logger.warning("getAsciiData() IOException: " + e.getMessage());
                    return false;
                }
            }
        };
        return (String)rt.go();
    }

    public Wave getRawData(String station, String comp, String network, String location, double start, double end) {
        List<TraceBuf> tbs = this.getTraceBufs(station, comp, network, location, start, end);
        return TraceBuf.traceBufToWave(tbs, true);
    }

    public Wave getRawData(String station, String comp, String network, double start, double end) {
        return this.getRawData(station, comp, network, null, start, end);
    }

    public List<TraceBuf> getTraceBufs(final String station, final String comp, final String network, final String location, final double start, final double end) {
        Retriable<List<TraceBuf>> rt = new Retriable<List<TraceBuf>>("WaveServer.getTraceBufs()", this.maxRetries){

            @Override
            public void attemptFix() {
                WaveServer.this.close();
            }

            @Override
            public boolean attempt() {
                String[] ss;
                boolean tb2;
                int lengthIndex;
                block7: {
                    if (!WaveServer.this.connected()) {
                        WaveServer.this.connect();
                    }
                    int spanIndex = 5;
                    lengthIndex = 9;
                    String cmd = "GETSCNRAW: GS ";
                    String loc = null;
                    tb2 = false;
                    if (location != null) {
                        cmd = "GETSCNLRAW: GS ";
                        loc = location;
                        tb2 = true;
                        ++spanIndex;
                        ++lengthIndex;
                    }
                    String req = String.valueOf(cmd) + station + " " + comp + " " + network + " " + (loc == null ? "" : String.valueOf(loc) + " ") + start + " " + end + "\n";
                    WaveServer.this.socketOut.print(req);
                    WaveServer.this.socketOut.flush();
                    String info = WaveServer.this.readString();
                    ss = info.split(" ");
                    if (ss[spanIndex].equals("F")) break block7;
                    return true;
                }
                try {
                    int bytes = Integer.parseInt(ss[lengthIndex]);
                    byte[] buf = WaveServer.this.readBinary(bytes);
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
                    ArrayList<TraceBuf> tbs = new ArrayList<TraceBuf>(100);
                    while (dis.available() > 0) {
                        TraceBuf tb = new TraceBuf();
                        tb.processBytes(dis, tb2);
                        tbs.add(tb);
                    }
                    this.result = tbs;
                    return true;
                }
                catch (SocketTimeoutException e) {
                    WaveServer.this.logger.warning("getTraceBufs() timeout.");
                }
                catch (Exception e) {
                    WaveServer.this.logger.warning("getTraceBufs() exception: " + e.getMessage());
                }
                return false;
            }
        };
        return (List)rt.go();
    }

    public List<TraceBuf> getTraceBufs(String station, String comp, String network, double start, double end) {
        return this.getTraceBufs(station, comp, network, null, start, end);
    }

    @Override
    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            WaveServer ws;
            String server = args[0];
            int port = Integer.MAX_VALUE;
            try {
                port = Integer.parseInt(args[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (port == Integer.MAX_VALUE) {
                System.err.println("Bad port.");
                System.exit(1);
            }
            if (!(ws = new WaveServer(server, port)).connect()) {
                System.err.println("Could not connect to " + server + ":" + port);
                System.exit(1);
            }
            System.out.println("Getting menu...");
            Menu menu = ws.getMenu();
            menu.output();
            ws.close();
        } else {
            System.out.println("java gov.usgs.earthworm.WaveServer [host] [port]");
            System.exit(1);
        }
        System.exit(0);
    }
}

