/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

import gov.usgs.math.Complex;
import gov.usgs.util.ConfigFile;

public class Butterworth {
    private int order = 4;
    private FilterType type = FilterType.LOWPASS;
    private double corner1 = 6.0;
    private double corner2 = 0.0;
    private double samplingRate = 100.0;
    private PZRep sPlane;
    private PZRep zPlane;
    private double rawAlpha1;
    private double rawAlpha2;
    private double warpedAlpha1;
    private double warpedAlpha2;
    private Complex[] topCoeffs;
    private Complex[] botCoeffs;
    private Complex dcGain;
    private Complex hfGain;
    private Complex fcGain;
    private double[] xCoeffs;
    private double[] yCoeffs;

    public Butterworth() {
        this(FilterType.BANDPASS, 4, 100.0, 1.0, 10.0);
    }

    public Butterworth(Butterworth bw) {
        this(bw.type, bw.order, bw.samplingRate, bw.corner1, bw.corner2);
    }

    public Butterworth(FilterType t, int o, double sr, double c1, double c2) {
        this.set(t, o, sr, c1, c2);
    }

    public void set(ConfigFile cf) {
        this.type = FilterType.fromString(cf.getString("type"));
        this.order = Integer.parseInt(cf.getString("order"));
        this.corner1 = Double.parseDouble(cf.getString("corner1"));
        this.corner2 = Double.parseDouble(cf.getString("corner2"));
        this.samplingRate = Double.parseDouble(cf.getString("samplingRate"));
    }

    public void save(ConfigFile cf, String prefix) {
        cf.put(String.valueOf(prefix) + ".type", this.type.code);
        cf.put(String.valueOf(prefix) + ".order", Integer.toString(this.order));
        cf.put(String.valueOf(prefix) + ".corner1", Double.toString(this.corner1));
        cf.put(String.valueOf(prefix) + ".corner2", Double.toString(this.corner2));
        cf.put(String.valueOf(prefix) + ".samplingRate", Double.toString(this.samplingRate));
    }

    public void set(FilterType t, int o, double sr, double c1, double c2) {
        this.type = t;
        this.order = o;
        this.samplingRate = sr;
        this.corner1 = c1;
        this.corner2 = c2;
    }

    public void setSamplingRate(double s) {
        this.samplingRate = s;
    }

    public int getOrder() {
        return this.order;
    }

    public FilterType getType() {
        return this.type;
    }

    public double getCorner1() {
        return this.corner1;
    }

    public double getCorner2() {
        return this.corner2;
    }

    public void create() {
        this.sPlane = new PZRep(this.order * 2);
        this.zPlane = new PZRep(this.order * 2);
        this.rawAlpha1 = this.corner1 / this.samplingRate;
        this.rawAlpha2 = this.corner2 / this.samplingRate;
        this.computeS();
        this.prewarp();
        this.normalize();
        this.computeZ();
        this.expandPoly();
    }

    public double[] getXCoeffs() {
        return this.xCoeffs;
    }

    public double[] getYCoeffs() {
        return this.yCoeffs;
    }

    public int getSize() {
        if (this.type == FilterType.BANDPASS) {
            return this.order * 2;
        }
        return this.order;
    }

    public double getGain() {
        switch (this.type) {
            case LOWPASS: {
                return this.dcGain.hypot();
            }
            case HIGHPASS: {
                return this.hfGain.hypot();
            }
            case BANDPASS: {
                return this.fcGain.hypot();
            }
        }
        return 0.0;
    }

    public void outputRR() {
        System.out.println("RR:\ny[n]=");
        int i = 0;
        while (i < this.zPlane.numZeros + 1) {
            double x = this.xCoeffs[i];
            System.out.println(String.valueOf(x) + " * x[n-" + (this.zPlane.numZeros - i) + "]");
            ++i;
        }
        i = 0;
        while (i < this.zPlane.numPoles) {
            System.out.println("     + (" + this.yCoeffs[i] + " * y[n-" + (this.zPlane.numPoles - i) + "])");
            ++i;
        }
        System.out.println("Gain=" + this.getGain());
    }

    private void computeS() {
        int i = 0;
        while (i < 2 * this.order) {
            double theta = this.order % 2 == 1 ? (double)i * Math.PI / (double)this.order : ((double)i + 0.5) * Math.PI / (double)this.order;
            this.choosePole(Complex.expj(theta));
            ++i;
        }
    }

    private void prewarp() {
        this.warpedAlpha1 = Math.tan(Math.PI * this.rawAlpha1) / Math.PI;
        this.warpedAlpha2 = Math.tan(Math.PI * this.rawAlpha2) / Math.PI;
    }

    private void normalize() {
        double w1 = Math.PI * 2 * this.warpedAlpha1;
        double w2 = Math.PI * 2 * this.warpedAlpha2;
        switch (this.type) {
            case LOWPASS: {
                int i = 0;
                while (i < this.sPlane.numPoles) {
                    this.sPlane.poles[i] = this.sPlane.poles[i].mult(w1);
                    ++i;
                }
                this.sPlane.numZeros = 0;
                break;
            }
            case HIGHPASS: {
                int i = 0;
                while (i < this.sPlane.numPoles) {
                    this.sPlane.poles[i] = new Complex(w1, 0.0).divide(this.sPlane.poles[i]);
                    ++i;
                }
                i = 0;
                while (i < this.sPlane.numPoles) {
                    this.sPlane.zeros[this.sPlane.numZeros++] = new Complex();
                    ++i;
                }
                break;
            }
            case BANDPASS: {
                double w0 = Math.sqrt(w1 * w2);
                double bw = w2 - w1;
                int i = 0;
                while (i < this.sPlane.numPoles) {
                    Complex hba = new Complex(0.5, 0.0).mult(this.sPlane.poles[i].mult(bw));
                    Complex temp = new Complex(1.0, 0.0).minus(new Complex(new Complex(w0, 0.0).divide(hba)).sqr()).sqrt();
                    this.sPlane.poles[i] = hba.mult(new Complex(1.0, 0.0).plus(temp));
                    this.sPlane.poles[this.sPlane.numPoles + i] = hba.mult(new Complex(1.0, 0.0).minus(temp));
                    ++i;
                }
                i = 0;
                while (i < this.sPlane.numPoles) {
                    this.sPlane.zeros[i] = new Complex();
                    ++i;
                }
                this.sPlane.numZeros = this.sPlane.numPoles;
                this.sPlane.numPoles *= 2;
            }
        }
    }

    private void computeZ() {
        this.zPlane.numPoles = this.sPlane.numPoles;
        this.zPlane.numZeros = this.sPlane.numZeros;
        int i = 0;
        while (i < this.zPlane.numPoles) {
            this.zPlane.poles[i] = this.sPlane.poles[i].blt();
            ++i;
        }
        i = 0;
        while (i < this.zPlane.numZeros) {
            this.zPlane.zeros[i] = this.sPlane.zeros[i].blt();
            ++i;
        }
        while (this.zPlane.numZeros < this.zPlane.numPoles) {
            this.zPlane.zeros[this.zPlane.numZeros++] = new Complex(-1.0, 0.0);
        }
    }

    private void expandPoly() {
        this.topCoeffs = new Complex[this.order * 2 + 1];
        this.botCoeffs = new Complex[this.order * 2 + 1];
        this.xCoeffs = new double[this.order * 2 + 1];
        this.yCoeffs = new double[this.order * 2 + 1];
        this.expand(this.zPlane.zeros, this.zPlane.numZeros, this.topCoeffs);
        this.expand(this.zPlane.poles, this.zPlane.numPoles, this.botCoeffs);
        this.dcGain = Complex.evaluate(this.topCoeffs, this.zPlane.numZeros, this.botCoeffs, this.zPlane.numPoles, new Complex(1.0, 0.0));
        double theta = Math.PI * (this.rawAlpha1 + this.rawAlpha2);
        this.fcGain = Complex.evaluate(this.topCoeffs, this.zPlane.numZeros, this.botCoeffs, this.zPlane.numPoles, Complex.expj(theta));
        this.hfGain = Complex.evaluate(this.topCoeffs, this.zPlane.numZeros, this.botCoeffs, this.zPlane.numPoles, new Complex(-1.0, 0.0));
        int i = 0;
        while (i <= this.zPlane.numZeros) {
            this.xCoeffs[i] = this.topCoeffs[i].re / this.botCoeffs[this.zPlane.numPoles].re;
            ++i;
        }
        i = 0;
        while (i <= this.zPlane.numPoles) {
            this.yCoeffs[i] = -(this.botCoeffs[i].re / this.botCoeffs[this.zPlane.numPoles].re);
            ++i;
        }
    }

    private void expand(Complex[] pz, int npz, Complex[] coeffs) {
        coeffs[0] = new Complex(1.0, 0.0);
        int i = 0;
        while (i < npz) {
            coeffs[i + 1] = new Complex(0.0, 0.0);
            ++i;
        }
        i = 0;
        while (i < npz) {
            this.multIn(pz[i], npz, coeffs);
            ++i;
        }
    }

    private void multIn(Complex w, int npz, Complex[] coeffs) {
        Complex nw = w.neg();
        int i = npz;
        while (i >= 1) {
            coeffs[i] = nw.mult(coeffs[i]).plus(coeffs[i - 1]);
            --i;
        }
        coeffs[0] = nw.mult(coeffs[0]);
    }

    private void choosePole(Complex z) {
        if (z.re < 0.0) {
            this.sPlane.poles[this.sPlane.numPoles++] = z;
        }
    }

    public static enum FilterType {
        LOWPASS("L"),
        HIGHPASS("H"),
        BANDPASS("B");

        public String code;

        private FilterType(String c) {
            this.code = c;
        }

        public static FilterType fromString(String s) {
            if (s == null) {
                return null;
            }
            if (s.equals("L")) {
                return LOWPASS;
            }
            if (s.equals("H")) {
                return HIGHPASS;
            }
            if (s.equals("B")) {
                return BANDPASS;
            }
            return null;
        }
    }

    class PZRep {
        Complex[] poles;
        Complex[] zeros;
        int numPoles;
        int numZeros;

        public PZRep(int max) {
            this.poles = new Complex[max];
            this.zeros = new Complex[max];
            this.numPoles = 0;
            this.numZeros = 0;
        }

        public void output() {
            System.out.println("poles:");
            int i = 0;
            while (i < this.numPoles) {
                System.out.println(this.poles[i]);
                ++i;
            }
            System.out.println("zeros:");
            i = 0;
            while (i < this.numZeros) {
                System.out.println(this.zeros[i]);
                ++i;
            }
        }
    }
}

