/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

public class Complex {
    public double re;
    public double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double r, double i) {
        this.re = r;
        this.im = i;
    }

    public Complex(Complex c) {
        this.re = c.re;
        this.im = c.im;
    }

    public double mag() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public Complex conj() {
        return new Complex(this.re, -this.im);
    }

    public Complex mult(double d) {
        return new Complex(this.re * d, this.im * d);
    }

    public Complex mult(Complex c) {
        return new Complex(this.re * c.re - this.im * c.im, this.re * c.im + this.im * c.re);
    }

    public Complex divide(double d) {
        return new Complex(this.re / d, this.im / d);
    }

    public Complex divide(Complex c) {
        double mag = c.re * c.re + c.im * c.im;
        return new Complex((this.re * c.re + this.im * c.im) / mag, (this.im * c.re - this.re * c.im) / mag);
    }

    public Complex plus(Complex c) {
        return new Complex(this.re + c.re, this.im + c.im);
    }

    public Complex minus(Complex c) {
        return new Complex(this.re - c.re, this.im - c.im);
    }

    public Complex neg() {
        return new Complex(-this.re, -this.im);
    }

    public boolean equals(Complex c) {
        return c.re == this.re && c.im == this.im;
    }

    public double hypot() {
        return Math.sqrt(this.im * this.im + this.re * this.re);
    }

    public double atan2() {
        return Math.atan2(this.im, this.re);
    }

    public Complex sqrt() {
        double r = this.hypot();
        Complex z = new Complex(Math.sqrt(0.5 * (r + this.re)), Math.sqrt(0.5 * (r - this.re)));
        if (this.im < 0.0) {
            z.im = -z.im;
        }
        return z;
    }

    public Complex exp() {
        return Complex.expj(this.im).mult(Math.exp(this.re));
    }

    public static Complex expj(double theta) {
        return new Complex(Math.cos(theta), Math.sin(theta));
    }

    public static Complex expk(double theta, int k) {
        return new Complex(Math.cos((double)k * theta), Math.sin((double)k * theta));
    }

    public Complex sqr() {
        return this.mult(this);
    }

    public Complex pow(int k) {
        double rk = Math.pow(this.mag(), k);
        double t = this.atan2();
        return new Complex(rk * Math.cos((double)k * t), rk * Math.sin((double)k * t));
    }

    public static Complex eval(Complex[] coeffs, int n, Complex z) {
        Complex sum = new Complex();
        int i = n;
        while (i >= 0) {
            sum = sum.mult(z).plus(coeffs[i]);
            --i;
        }
        return sum;
    }

    public static Complex evaluate(Complex[] topco, int nt, Complex[] botco, int nb, Complex z) {
        Complex c1 = Complex.eval(topco, nt, z);
        Complex c2 = Complex.eval(botco, nb, z);
        return c1.divide(c2);
    }

    public Complex blt() {
        Complex c1 = new Complex(2.0 + this.re, this.im);
        Complex c2 = new Complex(2.0 - this.re, -this.im);
        return c1.divide(c2);
    }

    public String toString() {
        return "re=" + this.re + ", im=" + this.im;
    }
}

