/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

import gov.usgs.math.Complex;

public class DFT {
    private static final double TWOPI = Math.PI * 2;
    private double[] data;
    private int numData;

    public DFT(double[] d) {
        this.data = d;
        this.numData = this.data.length;
    }

    public Complex getDFTPoint(int m) {
        Complex cx = new Complex();
        if (m >= 0 && m < this.numData) {
            double r = 0.0;
            double i = 0.0;
            if (m == 0) {
                int n = 0;
                while (n < this.numData) {
                    r += this.data[n];
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.numData) {
                    double x = this.data[n];
                    double scale = Math.PI * 2 * (double)n * (double)m / (double)this.numData;
                    r += x * Math.cos(scale);
                    i -= x * Math.sin(scale);
                    ++n;
                }
            }
            cx.re = r;
            cx.im = i;
        }
        return cx;
    }

    public Complex[] getFullDFT() {
        Complex[] dft = new Complex[this.numData / 2];
        int i = 0;
        while (i < this.numData / 2) {
            dft[i] = this.getDFTPoint(i);
            ++i;
        }
        return dft;
    }
}

