/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.Command;
import gov.usgs.net.Server;
import gov.usgs.util.Log;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommandHandler
extends Thread {
    protected static final int COMMAND_BUFFER_SIZE = 2048;
    protected Server server;
    protected Map<String, Command> commands;
    protected Command executeCommand;
    protected String executeCommandInfo;
    protected SocketChannel channel;
    protected SelectionKey selectionKey;
    protected Logger logger = Log.getLogger("gov.usgs.net");

    public CommandHandler(Server svr, String name) {
        this.server = svr;
        this.commands = new HashMap<String, Command>();
        this.setName(name);
        this.start();
    }

    protected abstract void setupCommandHandlers();

    protected void addCommand(String id, Command cmd) {
        this.commands.put(id, cmd);
    }

    protected Command getCommand(String cmd) {
        Command command = this.commands.get(cmd);
        return command;
    }

    protected void doCommand(SocketChannel ch, SelectionKey key, String cmd) {
        this.logger.log(Level.INFO, "Command: " + cmd);
        this.channel = ch;
        this.selectionKey = key;
        String cmdName = "";
        int indexSpace = cmd.indexOf(32);
        int indexColon = cmd.indexOf(58);
        if (indexSpace == -1 && indexColon == -1) {
            cmdName = cmd.trim();
        } else {
            int index = -1;
            if (indexSpace == -1 || indexColon == -1) {
                index = indexSpace;
                if (index == -1) {
                    index = indexColon;
                }
            } else {
                index = Math.min(indexSpace, indexColon);
            }
            if (index == -1) {
                index = indexColon;
            }
            cmdName = cmd.substring(0, index);
        }
        Command command = this.getCommand(cmdName);
        if (command != null) {
            this.executeCommand = command;
            this.executeCommandInfo = cmd;
        } else if (cmdName.equalsIgnoreCase("quit")) {
            this.closeConnection();
        }
        this.interrupt();
    }

    public void closeConnection() {
        this.server.closeConnection(this.channel, this.selectionKey);
    }

    @Override
    public void run() {
        while (true) {
            block10: {
                boolean interrupted = false;
                try {
                    if (this.executeCommand != null) {
                        this.logger.log(Level.SEVERE, "This can't happen. " + this.getName() + ".executeCommand = " + this.executeCommand);
                        this.logger.log(Level.SEVERE, "Pool size = " + this.server.getPoolSize());
                    }
                    Thread.sleep(3600000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                if (!interrupted) continue;
                try {
                    try {
                        if (this.executeCommand != null) {
                            this.executeCommand.doCommand(this.executeCommandInfo, this.channel);
                        }
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Unhandled exception in main CommandHandler loop.", e);
                        this.executeCommand = null;
                        this.server.addCommandHandler(this);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.executeCommand = null;
                    this.server.addCommandHandler(this);
                    throw throwable;
                }
                this.executeCommand = null;
                this.server.addCommandHandler(this);
            }
            if (this.executeCommand == null) continue;
            this.logger.log(Level.SEVERE, "finally didn't happen.");
        }
    }
}

