/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private String fullRequest;
    private String method;
    private String resource;
    private String version;
    private String[] lines;
    private String file;
    private String argumentString;
    private Map<String, String> arguments;
    private boolean valid;

    public HttpRequest(String req) {
        this.fullRequest = req;
        this.arguments = new HashMap<String, String>();
        this.parseRequest();
    }

    protected void parseRequest() {
        this.lines = this.fullRequest.split("\n");
        String[] line0 = this.lines[0].split(" ");
        this.valid = false;
        if (line0.length == 3) {
            this.method = line0[0].trim();
            this.resource = line0[1].trim();
            this.version = line0[2].trim();
            this.valid = true;
        }
        if (this.valid) {
            this.parseResource();
        }
    }

    protected void parseResource() {
        int index = this.resource.indexOf(63);
        if (index == -1) {
            this.file = this.resource;
            this.argumentString = "";
        } else {
            this.file = this.resource.substring(0, index);
            this.argumentString = this.resource.substring(index + 1);
        }
        this.parseArguments();
    }

    protected void parseArguments() {
        if (this.argumentString == null || this.argumentString.length() == 0) {
            return;
        }
        String[] args = this.argumentString.split("&");
        int i = 0;
        while (i < args.length) {
            String[] arg = args[i].split("=");
            if (arg.length == 2) {
                this.arguments.put(arg[0], arg[1]);
            }
            ++i;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getMethod() {
        return this.method;
    }

    public String getResource() {
        return this.resource;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String getFile() {
        return this.file;
    }
}

