/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.Server;
import gov.usgs.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetTools {
    private int currentBufferSize = 2048;
    public CharsetEncoder encoder = Charset.forName("US-ASCII").newEncoder();
    public CharsetDecoder decoder = Charset.forName("US-ASCII").newDecoder();
    private CharBuffer charBuffer;
    private ByteBuffer outBuffer;
    private Logger logger = Log.getLogger("gov.usgs.net");
    private Server server;

    public NetTools() {
        this.reallocate();
    }

    public void setServer(Server s) {
        this.server = s;
    }

    private void reallocate() {
        this.currentBufferSize *= 2;
        this.charBuffer = CharBuffer.allocate(this.currentBufferSize);
        this.outBuffer = ByteBuffer.allocateDirect(this.currentBufferSize * 2);
    }

    public int writeCharBuffer(CharBuffer cb, SocketChannel channel) {
        int totalBytes = 0;
        try {
            cb.flip();
            this.outBuffer.clear();
            while (this.outBuffer.capacity() < cb.limit()) {
                this.reallocate();
            }
            this.outBuffer.put(this.encoder.encode(cb));
            this.outBuffer.flip();
            while (this.outBuffer.hasRemaining()) {
                totalBytes += channel.write(this.outBuffer);
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not write character buffer.", e);
        }
        if (this.server != null) {
            this.server.recordSent(channel, totalBytes);
        }
        return totalBytes;
    }

    public int writeByteBuffer(ByteBuffer bb, SocketChannel channel) {
        int totalBytes = 0;
        try {
            while (bb.hasRemaining()) {
                totalBytes += channel.write(bb);
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Could not write byte buffer.", e);
        }
        if (this.server != null) {
            this.server.recordSent(channel, totalBytes);
        }
        return totalBytes;
    }

    public int writeString(String s, SocketChannel channel) {
        if (s == null || channel == null) {
            return -1;
        }
        int totalBytes = 0;
        try {
            while (s.length() >= this.charBuffer.capacity()) {
                this.reallocate();
            }
            this.charBuffer.clear();
            this.outBuffer.clear();
            this.charBuffer.put(s);
            this.charBuffer.flip();
            this.outBuffer.put(this.encoder.encode(this.charBuffer));
            this.outBuffer.flip();
            while (this.outBuffer.hasRemaining()) {
                totalBytes += channel.write(this.outBuffer);
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Could not write string.", e);
        }
        if (this.server != null) {
            this.server.recordSent(channel, totalBytes);
        }
        return totalBytes;
    }
}

