/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.CommandHandler;
import gov.usgs.net.ConnectionStatistics;
import gov.usgs.net.NetTools;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.Log;
import gov.usgs.util.Pool;
import gov.usgs.util.Util;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server {
    protected ByteBuffer inBuffer = ByteBuffer.allocate(65536);
    protected NetTools netTools = new NetTools();
    protected static final int COMMAND_BUFFER_SIZE = 2048;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String name = "Server";
    protected int port = -1;
    protected boolean keepalive = false;
    protected int maxConnections = 20;
    protected long connectionIndex = 0L;
    private Pool<CommandHandler> commandHandlerPool;
    protected Logger logger;
    protected int maxReadHandlers = -1;
    protected Map<SocketChannel, ConnectionStatistics> connectionStats = Collections.synchronizedMap(new HashMap());
    protected boolean dropOldest = true;
    protected long totalSent = 0L;

    protected Server() {
        this.logger = Log.getLogger("gov.usgs.net");
        this.commandHandlerPool = new Pool();
    }

    protected Server(int p) {
        this();
        this.port = p;
    }

    protected void addCommandHandler(CommandHandler rh) {
        this.commandHandlerPool.checkin(rh);
        int max = Math.max(this.maxReadHandlers, this.commandHandlerPool.size());
        if (max > this.maxReadHandlers) {
            this.logger.log(Level.FINE, "command handler pool size: " + max);
        }
        this.maxReadHandlers = max;
    }

    public int getNumConnections() {
        return this.connectionStats.size();
    }

    public int getPoolSize() {
        return this.commandHandlerPool.size();
    }

    public static String getHost(SocketChannel channel) {
        if (channel == null || channel.socket() == null || channel.socket().getInetAddress() == null) {
            return "(closed)";
        }
        return channel.socket().getInetAddress().getHostAddress();
    }

    public void log(Level level, String msg, SocketChannel channel) {
        String channelString = channel == null ? "" : String.valueOf(Server.getHost(channel)) + "/";
        String logMsg = String.valueOf(channelString) + msg;
        this.logger.log(level, logMsg);
    }

    protected void closeConnection(SocketChannel channel, SelectionKey selectionKey) {
        try {
            this.connectionStats.remove(channel);
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
            if (selectionKey != null) {
                selectionKey.cancel();
                selectionKey.selector().wakeup();
                selectionKey.attach(null);
            }
            this.log(Level.FINER, String.format("Connection closed: %d/%d.", this.getNumConnections(), this.maxConnections), channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void dispatchCommand(SocketChannel channel, SelectionKey key, String s) {
        CodeTimer ct = new CodeTimer("getReadHandler");
        CommandHandler ch = this.commandHandlerPool.checkout();
        ct.stop(false);
        if (ct.getRunTimeMillis() > 1000.0) {
            this.log(Level.FINE, String.format("long wait for read handler: %1.2f ms.", ct.getRunTimeMillis()), channel);
        }
        ch.doCommand(channel, key, s);
    }

    public ConnectionStatistics getConnectionStatistics(SocketChannel channel) {
        ConnectionStatistics cs = this.connectionStats.get(channel);
        if (cs == null) {
            cs = new ConnectionStatistics(channel);
            cs.address = Server.getHost(channel);
            cs.index = this.connectionIndex++;
            cs.connectTime = System.currentTimeMillis();
            this.connectionStats.put(channel, cs);
        }
        return cs;
    }

    public void recordSent(SocketChannel channel, int nb) {
        this.totalSent += (long)nb;
        ConnectionStatistics cs = this.connectionStats.get(channel);
        if (cs != null) {
            cs.sent(nb);
        }
    }

    public void processRead(SelectionKey selectionKey) {
        SocketChannel channel = (SocketChannel)selectionKey.channel();
        if (!channel.isConnected() || !channel.isOpen()) {
            return;
        }
        ConnectionStatistics cs = this.getConnectionStatistics(channel);
        Object attachment = selectionKey.attachment();
        ByteBuffer commandBuffer = attachment != null ? (ByteBuffer)attachment : ByteBuffer.allocate(2048);
        boolean close = false;
        try {
            this.inBuffer.clear();
            int i = channel.read(this.inBuffer);
            if (i == -1) {
                close = true;
            } else {
                cs.read(i);
                this.inBuffer.flip();
                while (this.inBuffer.position() < this.inBuffer.limit()) {
                    byte b = this.inBuffer.get();
                    if (b == 10) {
                        commandBuffer.flip();
                        CharBuffer cb = this.netTools.decoder.decode(commandBuffer);
                        this.dispatchCommand(channel, selectionKey, cb.toString());
                        commandBuffer.clear();
                        continue;
                    }
                    commandBuffer.put(b);
                }
                if (commandBuffer.position() != 0) {
                    selectionKey.attach(commandBuffer);
                } else {
                    selectionKey.attach(null);
                }
            }
        }
        catch (IOException e) {
            close = true;
        }
        catch (BufferOverflowException e) {
            this.logger.log(Level.SEVERE, "Buffer overflow on read.  Possible malicious attack?");
            close = true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unhandled exception.", e);
            close = true;
        }
        if (close) {
            this.closeConnection(channel, selectionKey);
        }
    }

    public void printConnections(String s) {
        char col = 'A';
        if (s.length() > 1) {
            col = s.charAt(1);
        }
        boolean desc = s.endsWith("-");
        ArrayList<ConnectionStatistics> css = new ArrayList<ConnectionStatistics>(this.connectionStats.size());
        css.addAll(this.connectionStats.values());
        Collections.sort(css, ConnectionStatistics.getComparator(ConnectionStatistics.SortOrder.parse(col), desc));
        StringBuffer sb = new StringBuffer();
        sb.append("------- Connections --------\n");
        sb.append(ConnectionStatistics.getHeaderString());
        for (ConnectionStatistics cs : css) {
            sb.append(String.valueOf(cs.toString()) + "\n");
        }
        sb.append(ConnectionStatistics.getHeaderString());
        sb.append("Total connections: " + this.connectionStats.size() + "\n");
        sb.append("Total bytes sent:  " + Util.numBytesToString(this.totalSent) + "\n");
        System.out.println(sb);
    }

    public void dropConnections() {
        this.dropConnections(0L);
    }

    public void dropConnections(long idleLimit) {
        this.logger.info("Dropping connections.");
        ArrayList<SocketChannel> channels = new ArrayList<SocketChannel>(this.connectionStats.size());
        for (SocketChannel sc : this.connectionStats.keySet()) {
            ConnectionStatistics cs = this.connectionStats.get(sc);
            if (System.currentTimeMillis() - cs.lastRequestTime <= idleLimit) continue;
            channels.add(sc);
        }
        for (SocketChannel sc : channels) {
            this.closeConnection(sc, null);
        }
    }

    public void dropOldestConnection() {
        long least = Long.MAX_VALUE;
        SocketChannel lc = null;
        for (ConnectionStatistics cs : this.connectionStats.values()) {
            if (cs.lastRequestTime >= least) continue;
            least = cs.lastRequestTime;
            lc = cs.channel;
        }
        if (lc != null) {
            this.closeConnection(lc, null);
        }
    }

    protected void startListening() {
        if (this.commandHandlerPool.size() <= 0 || this.port == -1) {
            return;
        }
        try {
            Selector selector = Selector.open();
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            serverChannel.socket().bind(new InetSocketAddress(this.port));
            serverChannel.register(selector, 16);
            this.logger.info("listening on port " + this.port + ".");
            block4: while (true) {
                selector.select();
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (true) {
                    if (!it.hasNext()) continue block4;
                    try {
                        SocketChannel channel;
                        SelectionKey selKey = it.next();
                        it.remove();
                        if (!selKey.isValid()) continue;
                        if (selKey.isAcceptable()) {
                            ServerSocketChannel ssChannel = (ServerSocketChannel)selKey.channel();
                            SocketChannel channel2 = ssChannel.accept();
                            channel2.socket().setKeepAlive(this.keepalive);
                            channel2.socket().setTcpNoDelay(true);
                            ConnectionStatistics cs = this.getConnectionStatistics(channel2);
                            cs.touch();
                            if (this.maxConnections != 0 && this.getNumConnections() > this.maxConnections) {
                                if (this.dropOldest) {
                                    this.logger.severe("Max connections reached, dropped least recently used connection.");
                                    this.dropOldestConnection();
                                } else {
                                    this.logger.severe("Max connections reached, rejected connection.");
                                    channel2.close();
                                    this.closeConnection(channel2, null);
                                    continue;
                                }
                            }
                            this.log(Level.FINER, String.format("Connection accepted: %d/%d", this.getNumConnections(), this.maxConnections), channel2);
                            channel2.configureBlocking(false);
                            channel2.register(selector, 1);
                        }
                        if (!selKey.isValid() || !selKey.isReadable() || !(channel = (SocketChannel)selKey.channel()).isOpen() || !channel.isConnected()) continue;
                        ConnectionStatistics cs = this.getConnectionStatistics(channel);
                        cs.touch();
                        this.processRead(selKey);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Fatal exception.", e);
            return;
        }
    }
}

