/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.util.Util;

public class Data {
    public static double NO_DATA = Double.MAX_VALUE;
    public static double LN10 = Math.log(10.0);
    public static double LOG10 = Math.log(10.0);
    private double[][] data;
    private boolean sorted;
    private boolean[] visible;

    public Data(double[][] d) {
        this.data = d;
        if (d == null) {
            return;
        }
        this.visible = new boolean[d[0].length - 1];
        int i = 0;
        while (i < this.visible.length) {
            this.visible[i] = true;
            ++i;
        }
    }

    public Data subset(int[] columns) {
        double[][] d = new double[this.data.length][columns.length];
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < columns.length) {
                d[i][j] = this.data[i][columns[j]];
                ++j;
            }
            ++i;
        }
        return new Data(d);
    }

    public int size() {
        return this.data.length;
    }

    public void setVisible(boolean[] b) {
        this.visible = b;
    }

    public boolean isVisible(int column) {
        return this.visible[column];
    }

    public double[][] getData() {
        return this.data;
    }

    public int getNumRows() {
        return this.data.length;
    }

    public int getNumColumns() {
        if (this.data == null || this.data.length == 0) {
            return 0;
        }
        return this.data[0].length;
    }

    public double getMinTime() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        if (this.sorted) {
            return this.data[0][0];
        }
        double min = 1.0E300;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][0] < min) {
                min = this.data[i][0];
            }
            ++i;
        }
        return min;
    }

    public double getMaxTime() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        if (this.sorted) {
            return this.data[0][this.data[0].length - 1];
        }
        double max = -1.0E300;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][0] > max) {
                max = this.data[i][0];
            }
            ++i;
        }
        return max;
    }

    public double getMinData() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        double min = 1.0E300;
        int i = 0;
        while (i < this.data.length) {
            int j = 1;
            while (j < this.data[0].length) {
                if (this.visible[j - 1] && this.data[i][j] != NO_DATA && this.data[i][j] < min) {
                    min = this.data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public double getMaxData() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        double max = -1.0E300;
        int i = 0;
        while (i < this.data.length) {
            int j = 1;
            while (j < this.data[0].length) {
                if (this.visible[j - 1] && this.data[i][j] != NO_DATA && this.data[i][j] > max) {
                    max = this.data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public double getMean(int column) {
        double sum = 0.0;
        int nodatas = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][column] == NO_DATA) {
                ++nodatas;
            } else {
                sum += this.data[i][column];
            }
            ++i;
        }
        return sum / (double)(this.data.length + nodatas);
    }

    public void subtractMean(int column) {
        double mean = this.getMean(column);
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][column] != NO_DATA) {
                double[] dArray = this.data[i];
                int n = column;
                dArray[n] = dArray[n] - mean;
            }
            ++i;
        }
    }

    public double getMin(int column) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][column] != NO_DATA && this.data[i][column] < min) {
                min = this.data[i][column];
            }
            ++i;
        }
        return min;
    }

    public double getMax(int column) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][column] != NO_DATA && this.data[i][column] > max) {
                max = this.data[i][column];
            }
            ++i;
        }
        return max;
    }

    public void add(int column, double val) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][column] != NO_DATA) {
                double[] dArray = this.data[i];
                int n = column;
                dArray[n] = dArray[n] + val;
            }
            ++i;
        }
    }

    public void unbias(int column) {
        double ym = this.getMean(column);
        int i = 0;
        while (i < this.data.length) {
            double[] dArray = this.data[i];
            int n = column;
            dArray[n] = dArray[n] - ym;
            ++i;
        }
    }

    public void detrend(int column) {
        double ym = this.getMean(column);
        double xm = this.getMean(0);
        double ssxy = 0.0;
        double ssxx = 0.0;
        int i = 0;
        while (i < this.data.length) {
            ssxy += (this.data[i][0] - xm) * (this.data[i][column] - ym);
            ssxx += (this.data[i][0] - xm) * (this.data[i][0] - xm);
            ++i;
        }
        double m = ssxy / ssxx;
        double b = ym - m * xm;
        int i2 = 0;
        while (i2 < this.data.length) {
            double[] dArray = this.data[i2];
            int n = column;
            dArray[n] = dArray[n] - (this.data[i2][0] * m + b);
            ++i2;
        }
    }

    public double[] leastSquares(int column) {
        double ym = this.getMean(column);
        double xm = this.getMean(0);
        double ssxy = 0.0;
        double ssxx = 0.0;
        int i = 0;
        while (i < this.data.length) {
            ssxy += (this.data[i][0] - xm) * (this.data[i][column] - ym);
            ssxx += (this.data[i][0] - xm) * (this.data[i][0] - xm);
            ++i;
        }
        double m = ssxy / ssxx;
        double b = ym - m * xm;
        return new double[]{m, b};
    }

    public void log10(int column) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][column] != NO_DATA) {
                this.data[i][column] = Math.log(this.data[i][column]) / LN10;
            }
            ++i;
        }
    }

    public void stack(double interval) {
        int nv = 0;
        int i = 0;
        while (i < this.visible.length) {
            if (this.visible[i]) {
                ++nv;
            }
            ++i;
        }
        if (nv <= 1) {
            return;
        }
        double add = (double)(nv / 2) * interval;
        int i2 = 1;
        while (i2 < this.data[0].length) {
            if (this.visible[i2 - 1]) {
                this.add(i2, add);
                add -= interval;
            }
            ++i2;
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean b) {
        this.sorted = b;
    }

    public static double getExp(double d) {
        return Math.floor(Math.log(Math.abs(d)) / LN10);
    }

    public static double getMantissa(double d) {
        return d / Math.pow(10.0, Data.getExp(d));
    }

    public void output() {
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.data[i].length) {
                System.out.print(String.valueOf(this.data[i][j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public String toCSV() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.data.length) {
            sb.append(String.valueOf(Util.j2KToDateString(this.data[i][0])) + ",");
            int j = 1;
            while (j < this.data[0].length) {
                sb.append(String.valueOf(this.data[i][j]) + ",");
                ++j;
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.setCharAt(sb.length() - 1, '\n');
            }
            ++i;
        }
        return sb.toString();
    }
}

