/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.ColorCycler;
import gov.usgs.plot.Data;
import gov.usgs.plot.DataPointRenderer;
import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.LegendRenderer;
import gov.usgs.plot.PointRenderer;
import gov.usgs.plot.Renderer;
import gov.usgs.plot.ShapeRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class DataRenderer
extends FrameRenderer {
    protected Data data;
    protected Renderer[] lineRenderers;
    protected Renderer[] pointRenderers;

    public DataRenderer(Data d) {
        this.data = d;
    }

    public Data getData() {
        return this.data;
    }

    public void setLegendRenderer(LegendRenderer lr) {
        this.legendRenderer = lr;
    }

    public LegendRenderer getLegendRenderer() {
        return this.legendRenderer;
    }

    @Override
    public void createDefaultLegendRenderer(String[] s) {
        this.legendRenderer = new LegendRenderer();
        this.legendRenderer.x = this.graphX + 6;
        this.legendRenderer.y = this.graphY + 6;
        int i = 0;
        while (i < s.length) {
            if (s[i] != null) {
                ShapeRenderer sr = null;
                if (this.lineRenderers != null) {
                    sr = (ShapeRenderer)this.lineRenderers[i];
                }
                PointRenderer pr = null;
                if (this.pointRenderers != null) {
                    pr = (PointRenderer)this.pointRenderers[i];
                }
                this.legendRenderer.addLine(sr, pr, s[i]);
            }
            ++i;
        }
    }

    public void createDefaultLineRenderers() {
        if (this.data == null) {
            return;
        }
        double[][] d = this.data.getData();
        this.lineRenderers = new Renderer[d[0].length - 1];
        ColorCycler cc = new ColorCycler();
        int i = 1;
        while (i < d[0].length) {
            if (this.data.isVisible(i - 1)) {
                ShapeRenderer sr = new ShapeRenderer(new GeneralPath());
                sr.color = cc.getNextColor();
                this.lineRenderers[i - 1] = sr;
            }
            ++i;
        }
    }

    public void createDefaultPointRenderers() {
        if (this.data == null) {
            return;
        }
        double[][] d = this.data.getData();
        this.pointRenderers = new Renderer[d[0].length - 1];
        ColorCycler cc = new ColorCycler();
        int i = 1;
        while (i < d[0].length) {
            if (this.data.isVisible(i - 1)) {
                DataPointRenderer pr = new DataPointRenderer();
                pr.color = cc.getNextColor();
                pr.transformer = this;
                this.pointRenderers[i - 1] = pr;
            }
            ++i;
        }
    }

    public Renderer[] getLineRenderers() {
        return this.lineRenderers;
    }

    public Renderer[] getPointRenderers() {
        return this.pointRenderers;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Stroke origStroke = g.getStroke();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        double[][] d = this.data.getData();
        int j = 1;
        while (j < d[0].length) {
            if (this.data.isVisible(j - 1)) {
                ShapeRenderer sr = null;
                if (this.lineRenderers != null) {
                    sr = (ShapeRenderer)this.lineRenderers[j - 1];
                }
                PointRenderer pr = null;
                if (this.pointRenderers != null) {
                    pr = (PointRenderer)this.pointRenderers[j - 1];
                }
                GeneralPath gp = null;
                if (sr != null) {
                    gp = (GeneralPath)sr.shape;
                    gp.reset();
                    gp.moveTo((float)this.getXPixel(d[0][0]), (float)this.getYPixel(d[0][j]));
                }
                boolean lastnd = false;
                int i = 0;
                while (i < d.length) {
                    if (pr != null) {
                        pr.x = d[i][0];
                        pr.y = d[i][j];
                        pr.render(g);
                    }
                    if (gp != null && i != 0) {
                        if (d[i][j] != Data.NO_DATA) {
                            if (lastnd) {
                                gp.moveTo((float)this.getXPixel(d[i][0]), (float)this.getYPixel(d[i][j]));
                            } else {
                                gp.lineTo((float)this.getXPixel(d[i][0]), (float)this.getYPixel(d[i][j]));
                            }
                            lastnd = false;
                        } else {
                            lastnd = true;
                        }
                    }
                    ++i;
                }
                if (sr != null) {
                    sr.render(g);
                }
                if (this.legendRenderer != null) {
                    this.legendRenderer.render(g);
                }
            }
            ++j;
        }
        g.setClip(origClip);
        g.setStroke(origStroke);
        g.setColor(origColor);
        g.setTransform(origAT);
    }
}

