/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.IdentityTransformer;
import gov.usgs.plot.Renderer;
import gov.usgs.plot.Transformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class EllipseVectorRenderer
implements Renderer {
    public double x;
    public double y;
    public double z;
    public double u;
    public double v;
    private double e1;
    private double e2;
    private double v1;
    private double v2;
    private double scale = 1.0;
    public boolean displayHoriz = true;
    public boolean displayVert = true;
    public Transformer transformer;
    private static final double[] SCALES = new double[]{100000.0, 50000.0, 20000.0, 10000.0, 5000.0, 2000.0, 1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02};
    private static GeneralPath arrowhead = new GeneralPath();

    static {
        arrowhead.moveTo(0.0f, 0.0f);
        arrowhead.lineTo(1.0f, -2.2f);
        arrowhead.lineTo(0.0f, -1.0f);
        arrowhead.lineTo(-1.0f, -2.2f);
        arrowhead.closePath();
    }

    public static double getBestScale(double maxMag) {
        double dm = 1.0E300;
        int mi = -1;
        int i = 0;
        while (i < SCALES.length) {
            if (Math.abs(maxMag - SCALES[i]) < dm) {
                dm = Math.abs(maxMag - SCALES[i]);
                mi = i;
            }
            ++i;
        }
        return SCALES[mi];
    }

    public void setParameters(double sigXX, double sigXY, double sigYX, double sigYY, double sigZZ) {
        this.e1 = Math.sqrt(0.5 * (sigXX - Math.sqrt(4.0 * sigXY * sigXY + (sigXX - sigYY) * (sigXX - sigYY))) + sigYY);
        this.e2 = Math.sqrt(0.5 * (sigXX + Math.sqrt(4.0 * sigXY * sigXY + (sigXX - sigYY) * (sigXX - sigYY))) + sigYY);
        this.v1 = -(-sigXX + Math.sqrt(4.0 * sigXY * sigXY + (sigXX - sigYY) * (sigXX - sigYY)) + sigYY) / (2.0 * sigXY);
        this.v2 = (sigXX + Math.sqrt(4.0 * sigXY * sigXY + (sigXX - sigYY) * (sigXX - sigYY)) - sigYY) / (2.0 * sigXY);
    }

    public void setUVByAngleMag(double az, double mag) {
        this.u = this.x + Math.cos(Math.toRadians(az)) * mag;
        this.v = this.y + Math.sin(Math.toRadians(az)) * mag;
    }

    public double getAngle() {
        return Math.toDegrees(Math.atan2(-this.u, -this.v));
    }

    public double getMag() {
        return Math.sqrt(this.u * this.u + this.v * this.v);
    }

    public void setScale(double s) {
        this.scale = s;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.transformer == null) {
            this.transformer = new IdentityTransformer();
        }
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Paint origPaint = g.getPaint();
        Stroke origStroke = g.getStroke();
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double line = new Line2D.Double();
        if (this.displayVert) {
            line.setLine(this.transformer.getXPixel(this.x), this.transformer.getYPixel(this.y), this.transformer.getXPixel(this.x), this.transformer.getYPixel(this.y + this.z * this.scale));
            g.setColor(Color.blue);
            g.draw(line);
            g.translate(this.transformer.getXPixel(this.x), this.transformer.getYPixel(this.y + this.z * this.scale));
            if (this.z > 0.0) {
                g.rotate(Math.toRadians(180.0));
            }
            g.setStroke(new BasicStroke(0.1f));
            g.scale(5.0, 5.0);
            g.draw(arrowhead);
        }
        if (this.displayHoriz) {
            g.setTransform(origAT);
            g.setStroke(origStroke);
            line.setLine(this.transformer.getXPixel(this.x), this.transformer.getYPixel(this.y), this.transformer.getXPixel(this.x + this.u * this.scale), this.transformer.getYPixel(this.y + this.v * this.scale));
            g.setColor(Color.red);
            g.draw(line);
            g.translate(this.transformer.getXPixel(this.x + this.u * this.scale), this.transformer.getYPixel(this.y + this.v * this.scale));
            g.rotate(Math.toRadians(this.getAngle()));
            g.setStroke(new BasicStroke(0.1f));
            g.scale(10.0, 10.0);
            g.draw(arrowhead);
            g.setTransform(origAT);
            g.setStroke(origStroke);
            g.setColor(Color.red);
            double n1 = Math.sqrt(this.v1 * this.v1 + 1.0);
            double n2 = Math.sqrt(this.v2 * this.v2 + 1.0);
            double a = this.v1 / n1;
            double b = 1.0 / n1;
            double c = this.v2 / n2;
            double d = 1.0 / n2;
            double cnt = 100.0;
            double q = Math.PI * 2 / cnt;
            double p = 0.0;
            double lastX = 0.0;
            double lastY = 0.0;
            double sx = 0.0;
            double sy = 0.0;
            System.out.println("e1/e2: " + this.e1 + " " + this.e2);
            System.out.println("v1/v2: " + this.v1 + " " + this.v2);
            int i = 0;
            while ((double)i <= cnt + 1.0) {
                sx = a * this.e1 * Math.cos(p) + c * this.e2 * Math.sin(p);
                sy = b * this.e1 * Math.cos(p) + d * this.e2 * Math.sin(p);
                p += q;
                if (i > 1) {
                    System.out.println(String.valueOf(sx) + " " + sy);
                    line.setLine(this.transformer.getXPixel(this.x + this.u * this.scale + lastX * this.scale), this.transformer.getYPixel(this.y + this.v * this.scale + lastY * this.scale), this.transformer.getXPixel(this.x + this.u * this.scale + sx * this.scale), this.transformer.getYPixel(this.y + this.v * this.scale + sy * this.scale));
                    g.draw(line);
                }
                lastX = sx;
                lastY = sy;
                ++i;
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setStroke(origStroke);
        g.setPaint(origPaint);
        g.setColor(origColor);
        g.setTransform(origAT);
    }
}

