/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.DataPointRenderer;
import gov.usgs.plot.IdentityTransformer;
import gov.usgs.plot.PointRenderer;
import gov.usgs.plot.Renderer;
import gov.usgs.plot.ShapeRenderer;
import gov.usgs.plot.Transformer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class LegendRenderer
implements Renderer {
    public Transformer transformer;
    public List<LegendEntry> entries = new ArrayList<LegendEntry>();
    public double x;
    public double y;

    public void addLine(LegendEntry e) {
        this.entries.add(e);
    }

    public void addLine(ShapeRenderer lr, PointRenderer pr, String s) {
        LegendEntry entry = new LegendEntry();
        entry.lineRenderer = lr;
        entry.pointRenderer = pr;
        entry.legend = s;
        this.entries.add(entry);
    }

    @Override
    public void render(Graphics2D g) {
        if (this.transformer == null) {
            this.transformer = new IdentityTransformer();
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        double width = 1.0;
        double height = this.entries.size() * 16;
        int offset = 0;
        for (LegendEntry e : this.entries) {
            width = Math.max(width, (double)fm.stringWidth(e.legend));
            if (e.lineRenderer == null && e.pointRenderer == null) continue;
            offset = 25;
        }
        Paint origPaint = g.getPaint();
        Stroke origStroke = g.getStroke();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setRect(this.x, this.y, width + (double)offset + 13.0, height + 6.0);
        g.setPaint(Color.white);
        g.fill(rect);
        g.setPaint(Color.black);
        g.draw(rect);
        Line2D.Double line = new Line2D.Double();
        int i = 0;
        while (i < this.entries.size()) {
            LegendEntry e = this.entries.get(i);
            if (e.lineRenderer != null) {
                line.setLine(this.x + 3.0, this.y + (double)(16 * (i + 1)) - 5.0, this.x + 28.0, this.y + (double)(16 * (i + 1)) - 5.0);
                if (e.lineRenderer.stroke != null) {
                    g.setStroke(e.lineRenderer.stroke);
                }
                if (e.lineRenderer.color != null) {
                    g.setPaint(e.lineRenderer.color);
                }
                g.draw(line);
            }
            if (e.pointRenderer != null && e.pointRenderer instanceof DataPointRenderer) {
                DataPointRenderer odpr = (DataPointRenderer)e.pointRenderer;
                DataPointRenderer ndpr = new DataPointRenderer();
                ndpr.shape = odpr.shape;
                ndpr.color = odpr.color;
                ndpr.x = this.x + 18.0;
                ndpr.y = this.y + (double)(16 * (i + 1)) - 5.0;
                if (ndpr.color != null) {
                    g.setPaint(ndpr.color);
                }
                ndpr.render(g);
            }
            g.setPaint(origPaint);
            g.setStroke(origStroke);
            g.drawString(e.legend, (float)this.x + 8.0f + (float)offset, (float)this.y + (float)(16 * (i + 1)));
            ++i;
        }
        g.setStroke(origStroke);
        g.setPaint(origPaint);
    }

    public class LegendEntry {
        ShapeRenderer lineRenderer;
        PointRenderer pointRenderer;
        String legend;

        public LegendEntry() {
        }

        public LegendEntry(String s) {
            this.legend = s;
        }
    }
}

