/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.BasicFrameRenderer;
import gov.usgs.plot.ColorCycler;
import gov.usgs.plot.Data;
import gov.usgs.plot.DataPointRenderer;
import gov.usgs.plot.Plot;
import gov.usgs.plot.PointRenderer;
import gov.usgs.plot.ShapeRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Arrays;

public class MatrixRenderer
extends BasicFrameRenderer {
    protected DoubleMatrix2D data;
    protected boolean[] visible;
    protected ShapeRenderer[] lineRenderers;
    protected PointRenderer[] pointRenderers;

    protected MatrixRenderer() {
    }

    public MatrixRenderer(DoubleMatrix2D d) {
        this.setData(d);
    }

    public void setData(DoubleMatrix2D d) {
        if (d == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.data = d;
        this.visible = new boolean[this.data.columns() - 1];
        Arrays.fill(this.visible, true);
        this.lineRenderers = new ShapeRenderer[this.data.columns() - 1];
        this.pointRenderers = new PointRenderer[this.data.columns() - 1];
    }

    public void setAllVisible(boolean b) {
        Arrays.fill(this.visible, b);
    }

    public void setVisible(int col, boolean v) {
        if (col < this.data.columns() - 1) {
            this.visible[col] = v;
        }
    }

    public ShapeRenderer[] getLineRenderers() {
        return this.lineRenderers;
    }

    public void setLineRenderers(ShapeRenderer[] r) {
        this.lineRenderers = r;
    }

    public void setLineRenderer(int col, ShapeRenderer r) {
        if (col < this.data.columns() - 1) {
            this.lineRenderers[col] = r;
        }
    }

    public void setPointRenderers(PointRenderer[] r) {
        this.pointRenderers = r;
    }

    public void setPointRenderer(int col, PointRenderer r) {
        if (col < this.data.columns() - 1) {
            this.pointRenderers[col] = r;
        }
    }

    public void createLineRenderer(int col, Stroke s, Color color) {
        if (this.visible[col]) {
            int ic = 1000;
            if (this.data != null) {
                ic = this.data.rows() + 1;
            }
            ShapeRenderer sr = new ShapeRenderer(new GeneralPath(1, ic));
            sr.antiAlias = true;
            sr.color = color;
            sr.stroke = s;
            this.lineRenderers[col] = sr;
        }
    }

    public void createPointRenderer(int col, DataPointRenderer dr) {
        if (this.visible[col]) {
            dr.transformer = this;
            this.pointRenderers[col] = dr;
        }
    }

    public void createDefaultLineRenderers(int start) {
        this.lineRenderers = new ShapeRenderer[this.data.columns() - 1];
        ColorCycler cc = new ColorCycler();
        int i = 0;
        while (i++ < start) {
            cc.getNextColor();
        }
        i = 0;
        while (i < this.data.columns() - 1) {
            if (this.visible[i]) {
                int ic = 1000;
                if (this.data != null) {
                    ic = this.data.rows() + 1;
                }
                ShapeRenderer sr = new ShapeRenderer(new GeneralPath(1, ic));
                sr.color = cc.getNextColor();
                this.lineRenderers[i] = sr;
            }
            ++i;
        }
    }

    public void createDefaultLineRenderers() {
        this.createDefaultLineRenderers(0);
    }

    public void createDefaultPointRenderers() {
        this.pointRenderers = new PointRenderer[this.data.columns() - 1];
        ColorCycler cc = new ColorCycler();
        int i = 0;
        while (i < this.data.columns() - 1) {
            if (this.visible[i]) {
                DataPointRenderer pr = new DataPointRenderer();
                pr.color = cc.getNextColor();
                pr.transformer = this;
                this.pointRenderers[i] = pr;
            }
            ++i;
        }
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Stroke origStroke = g.getStroke();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        int j = 1;
        while (j < this.data.columns()) {
            if (this.visible[j - 1]) {
                ShapeRenderer sr = null;
                if (this.lineRenderers != null) {
                    sr = this.lineRenderers[j - 1];
                }
                PointRenderer pr = null;
                if (this.pointRenderers != null) {
                    pr = this.pointRenderers[j - 1];
                }
                GeneralPath gp = null;
                if (sr != null) {
                    gp = (GeneralPath)sr.shape;
                    gp.reset();
                    gp.moveTo((float)this.getXPixel(this.data.getQuick(0, 0)), (float)this.getYPixel(this.data.getQuick(0, j)));
                }
                boolean lastnd = false;
                int i = 0;
                while (i < this.data.rows()) {
                    double x = this.data.getQuick(i, 0);
                    double y = this.data.getQuick(i, j);
                    if (pr != null) {
                        pr.x = x;
                        pr.y = y;
                        pr.render(g);
                    }
                    if (gp != null && i != 0) {
                        if (y != Data.NO_DATA) {
                            if (lastnd) {
                                gp.moveTo((float)this.getXPixel(x), (float)this.getYPixel(y));
                            } else {
                                gp.lineTo((float)this.getXPixel(x), (float)this.getYPixel(y));
                            }
                            lastnd = false;
                        } else {
                            lastnd = true;
                        }
                    }
                    ++i;
                }
                if (sr != null) {
                    sr.render(g);
                }
            }
            ++j;
        }
        if (this.legendRenderer != null) {
            this.legendRenderer.render(g);
        }
        g.setClip(origClip);
        if (this.axis != null) {
            this.axis.postRender(g);
        }
        g.setStroke(origStroke);
        g.setColor(origColor);
        g.setTransform(origAT);
    }

    public static void main(String[] args) {
        int size = 100000;
        DoubleMatrix2D d = DoubleFactory2D.dense.make(size, 4);
        int i = 0;
        while (i < size) {
            d.setQuick(i, 0, (double)(i * 60));
            d.setQuick(i, 1, Math.sin(Math.PI * 8 * ((double)i / (double)size)));
            d.setQuick(i, 2, Math.cos(Math.PI * 8 * ((double)i / (double)size)));
            d.setQuick(i, 3, Math.cos(Math.PI * 8 * ((double)i / (double)size)) + 0.25 * Math.sin(87.96459430051421 * ((double)i / (double)size)));
            ++i;
        }
        Plot plot = new Plot();
        plot.setSize(1000, 250);
        MatrixRenderer mr = new MatrixRenderer(d);
        mr.setLocation(50, 20, 900, 210);
        mr.setExtents(0.0, size * 60, -1.1, 1.1);
        mr.createDefaultAxis();
        mr.setVisible(1, false);
        mr.setXAxisToTime(8);
        mr.createDefaultLineRenderers();
        plot.addRenderer(mr);
        int i2 = 0;
        while (i2 < 10) {
            plot.writePNG("c:\\test.png");
            ++i2;
        }
    }
}

