/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.IdentityTransformer;
import gov.usgs.plot.Renderer;
import gov.usgs.plot.Transformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class VectorRenderer
implements Renderer {
    public double x;
    public double y;
    public double u;
    public double v;
    public Transformer transformer;
    private static final double[] scales = new double[]{100000.0, 50000.0, 20000.0, 10000.0, 5000.0, 2000.0, 1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02};
    private static GeneralPath arrowhead = new GeneralPath();

    static {
        arrowhead.moveTo(0.0f, 0.0f);
        arrowhead.lineTo(1.0f, -2.2f);
        arrowhead.lineTo(0.0f, -1.0f);
        arrowhead.lineTo(-1.0f, -2.2f);
        arrowhead.closePath();
    }

    public static double getScale(double maxMag) {
        double dm = 1.0E300;
        int mi = -1;
        int i = 0;
        while (i < scales.length) {
            if (Math.abs(maxMag - scales[i]) < dm) {
                dm = Math.abs(maxMag - scales[i]);
                mi = i;
            }
            ++i;
        }
        return scales[mi];
    }

    public void setUVByAngleMag(double az, double mag) {
        this.u = this.x + Math.cos(Math.toRadians(az)) * mag;
        this.v = this.y + Math.sin(Math.toRadians(az)) * mag;
    }

    public double getAngle() {
        return Math.toDegrees(Math.atan2(this.x - this.u, this.y - this.v));
    }

    public double getMag() {
        return Math.sqrt((this.x - this.u) * (this.x - this.u) + (this.y - this.v) * (this.y - this.v));
    }

    public void scaleMag(double scale) {
        double dx = this.u - this.x;
        double dy = this.v - this.y;
        this.u = this.x + (dx *= scale);
        this.v = this.y + (dy *= scale);
    }

    @Override
    public void render(Graphics2D g) {
        if (this.transformer == null) {
            this.transformer = new IdentityTransformer();
        }
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Paint origPaint = g.getPaint();
        Stroke origStroke = g.getStroke();
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double line = new Line2D.Double();
        line.setLine(this.transformer.getXPixel(this.x), this.transformer.getYPixel(this.y), this.transformer.getXPixel(this.u), this.transformer.getYPixel(this.v));
        g.setColor(Color.red);
        g.draw(line);
        g.translate(this.transformer.getXPixel(this.u), this.transformer.getYPixel(this.v));
        g.rotate(Math.toRadians(this.getAngle()));
        g.setStroke(new BasicStroke(0.1f));
        g.scale(10.0, 10.0);
        g.draw(arrowhead);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setStroke(origStroke);
        g.setPaint(origPaint);
        g.setColor(origColor);
        g.setTransform(origAT);
    }
}

