/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.proj.Ellipsoid;
import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;

public class EllipsoidMercator
extends Projection {
    private Point2D.Double origin;

    public EllipsoidMercator() {
        this.name = "EllipsoidMercator";
        this.origin = new Point2D.Double(0.0, 0.0);
        this.ellipsoid = Ellipsoid.ELLIPSOIDS[11];
    }

    @Override
    public Point2D.Double forward(Point2D.Double lonLat) {
        double r = this.ellipsoid.equatorialRadius;
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double phi = lonLat.getY() * (Math.PI / 180);
        double lambda = lonLat.getX() * (Math.PI / 180);
        double l = lambda - lambdaO;
        while (l > Math.PI) {
            l -= Math.PI * 2;
        }
        while (l < -Math.PI) {
            l += Math.PI * 2;
        }
        double x = r * l;
        double sphi = Math.sin(phi);
        double e = Math.sqrt(this.ellipsoid.eccentricitySquared);
        double t2 = Math.pow((1.0 - e * sphi) / (1.0 + e * sphi), e);
        double y = r * 0.5 * Math.log((1.0 + sphi) / (1.0 - sphi) * t2);
        return new Point2D.Double(x, y);
    }

    @Override
    public double getScale(Point2D.Double lonLat) {
        double e2 = this.ellipsoid.eccentricitySquared;
        double sp = Math.sin(Math.toRadians(lonLat.y));
        double top = Math.sqrt(1.0 - e2 * sp * sp);
        double bottom = Math.cos(Math.toRadians(lonLat.y));
        return top / bottom;
    }

    @Override
    public Point2D.Double inverse(Point2D.Double xy) {
        double r = this.ellipsoid.equatorialRadius;
        double e = Math.sqrt(this.ellipsoid.eccentricitySquared);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double lambda = lambdaO + xy.x / r;
        double t = Math.exp(-xy.y / r);
        double phi = 1.5707963267948966 - 2.0 * Math.atan(t);
        int i = 0;
        while (i < 5) {
            double sphi = Math.sin(phi);
            double t2 = (1.0 - e * sphi) / (1.0 + e * sphi);
            double t3 = t * Math.pow(t2, e / 2.0);
            phi = 1.5707963267948966 - 2.0 * Math.atan(t3);
            ++i;
        }
        return new Point2D.Double(lambda * 57.29577951308232, phi * 57.29577951308232);
    }

    public static void main(String[] args) throws Exception {
        EllipsoidMercator merc = new EllipsoidMercator();
        System.out.println(merc.forward(new Point2D.Double(-121.5, 35.5)));
        System.out.println(merc.inverse(new Point2D.Double(-1.3525318E7, 4207225.0)));
    }
}

