/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.proj.Ellipsoid;
import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;

public class LambertConformalConic
extends Projection {
    private double phi1;
    private double phi2;
    private Point2D.Double origin;
    private double n;
    private double F;
    private double m1;
    private double rho0;

    public LambertConformalConic(double p1, double p2, Point2D.Double o) {
        this.name = "Lambert Conformal Conic";
        this.setParameters(p1, p2, o);
        this.setEllipsoid(Ellipsoid.ELLIPSOIDS[11]);
    }

    public void setParameters(double p1, double p2, Point2D.Double o) {
        this.phi1 = p1;
        this.phi2 = p2;
        this.origin = o;
        this.calculateConstants();
    }

    @Override
    public void setEllipsoid(Ellipsoid e) {
        this.ellipsoid = e;
        this.calculateConstants();
    }

    private double m(double ang) {
        double s = Math.sin(ang);
        return Math.cos(ang) / Math.sqrt(1.0 - this.ellipsoid.eccentricitySquared * s * s);
    }

    private double t(double ang) {
        double e = Math.sqrt(this.ellipsoid.eccentricitySquared);
        double top = Math.tan(0.7853981633974483 - ang / 2.0);
        double s = Math.sin(ang);
        double bottom = Math.pow((1.0 - e * s) / (1.0 + e * s), e / 2.0);
        return top / bottom;
    }

    private void calculateConstants() {
        double phi0 = this.origin.y * (Math.PI / 180);
        double sp1 = this.phi1 * (Math.PI / 180);
        double sp2 = this.phi2 * (Math.PI / 180);
        this.m1 = this.m(sp1);
        double m2 = this.m(sp2);
        double t1 = this.t(sp1);
        double t2 = this.t(sp2);
        double t0 = this.t(phi0);
        this.n = Math.log(this.m1 / m2) / Math.log(t1 / t2);
        this.F = this.m1 / (this.n * Math.pow(t1, this.n));
        double a = this.ellipsoid.equatorialRadius;
        this.rho0 = a * this.F * Math.pow(t0, this.n);
    }

    @Override
    public Point2D.Double forward(Point2D.Double lonLat) {
        double lambda = lonLat.x * (Math.PI / 180);
        double phi = lonLat.y * (Math.PI / 180);
        double lambda0 = this.origin.x * (Math.PI / 180);
        double t = this.t(phi);
        double a = this.ellipsoid.equatorialRadius;
        double rho = a * this.F * Math.pow(t, this.n);
        double theta = this.n * (lambda - lambda0);
        double x = rho * Math.sin(theta);
        double y = this.rho0 - rho * Math.cos(theta);
        return new Point2D.Double(x, y);
    }

    @Override
    public double getScale(Point2D.Double lonLat) {
        double phi = lonLat.y * (Math.PI / 180);
        double t = this.t(phi);
        double m = this.m(phi);
        double tn = Math.pow(t, this.n);
        double k = this.m1 * tn / (m * tn);
        return k;
    }

    @Override
    public Point2D.Double inverse(Point2D.Double xy) {
        double theta = this.n < 0.0 ? Math.atan(-xy.x / (-this.rho0 + xy.y)) : Math.atan(xy.x / (this.rho0 - xy.y));
        double rho = Math.sqrt(xy.x * xy.x + (this.rho0 - xy.y) * (this.rho0 - xy.y));
        if (this.n < 0.0) {
            rho = -rho;
        }
        double a = this.ellipsoid.equatorialRadius;
        double t = Math.pow(rho / (a * this.F), 1.0 / this.n);
        double lambda = theta * 57.29577951308232 / this.n + this.origin.x;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(t);
        double e = Math.sqrt(this.ellipsoid.eccentricitySquared);
        int i = 0;
        while (i < 5) {
            double esp = e * Math.sin(phi);
            double b = Math.pow((1.0 - esp) / (1.0 + esp), e / 2.0);
            phi = 1.5707963267948966 - 2.0 * Math.atan(t * b);
            ++i;
        }
        return new Point2D.Double(lambda, phi * 57.29577951308232);
    }

    public String toString() {
        return String.format("%s\nStandard Parallel 1: %f\nStandard Parallel 2: %f\nOrigin: %s", this.name, this.phi1, this.phi2, this.origin.toString());
    }

    public static void main(String[] args) {
        Point2D.Double pt = new Point2D.Double(-75.0, 35.0);
        LambertConformalConic lcc = new LambertConformalConic(33.0, 45.0, new Point2D.Double(-96.0, 23.0));
        Point2D.Double xy = lcc.forward(pt);
        System.out.println(xy);
        Point2D.Double inv = lcc.inverse(xy);
        System.out.println(inv);
    }
}

