/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.math.Complex;
import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;

public class NewZealandMapGrid
extends Projection {
    protected static double[] A = new double[]{0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};
    protected static Complex[] B = new Complex[]{new Complex(0.7557853228, 0.0), new Complex(0.249204646, 0.003371507), new Complex(-0.001541739, 0.04105856), new Complex(-0.10162907, 0.01727609), new Complex(-0.26623489, -0.36249218), new Complex(-0.6870983, -1.1651967)};
    protected static Complex[] C = new Complex[]{new Complex(1.3231270439, 0.0), new Complex(-0.577245789, -0.007809598), new Complex(0.508307513, -0.112208952), new Complex(-0.15094762, 0.18200602), new Complex(1.01418179, 1.64497696), new Complex(1.9660549, 2.5127645)};
    protected static double[] D = new double[]{1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    protected static double a = 6378388.0;
    protected static double E_0 = 2510000.0;
    protected static double N_0 = 6023150.0;
    protected static double PHI_O = -41.0;
    protected static double LAMBDA_0 = 173.0;

    public NewZealandMapGrid() {
        this.name = "New Zealand Map Grid";
    }

    @Override
    public Point2D.Double forward(Point2D.Double lonLat) {
        double phi = lonLat.y;
        double lambda = lonLat.x;
        double deltaPhi = (phi - PHI_O) * 3600.0 * 1.0E-5;
        double deltaPsi = 0.0;
        int i = 1;
        while (i <= 10) {
            deltaPsi += A[i - 1] * Math.pow(deltaPhi, i);
            ++i;
        }
        double deltaLambda = (lambda - LAMBDA_0) * Math.PI / 180.0;
        Complex theta = new Complex(deltaPsi, deltaLambda);
        Complex z = new Complex();
        int i2 = 1;
        while (i2 <= 6) {
            Complex p = B[i2 - 1].mult(theta.pow(i2));
            z = z.plus(p);
            ++i2;
        }
        double east = z.im * a + E_0;
        double north = z.re * a + N_0;
        return new Point2D.Double(east, north);
    }

    @Override
    public Point2D.Double inverse(Point2D.Double xy) {
        double north = xy.y;
        double east = xy.x;
        Complex z = new Complex((north - N_0) / a, (east - E_0) / a);
        Complex theta0 = new Complex();
        int i = 1;
        while (i <= 6) {
            Complex p = C[i - 1].mult(z.pow(i));
            theta0 = theta0.plus(p);
            ++i;
        }
        Complex top = new Complex(z);
        Complex bottom = new Complex();
        int i2 = 1;
        while (i2 <= 6) {
            Complex p;
            if (i2 != 1) {
                p = B[i2 - 1].mult(theta0.pow(i2)).mult(i2 - 1);
                top = top.plus(p);
            }
            p = B[i2 - 1].mult(theta0.pow(i2 - 1)).mult(i2);
            bottom = bottom.plus(p);
            ++i2;
        }
        Complex theta1 = top.divide(bottom);
        double deltaPhi = 0.0;
        int i3 = 1;
        while (i3 <= 9) {
            deltaPhi += D[i3 - 1] * Math.pow(theta1.re, i3);
            ++i3;
        }
        double phi = PHI_O + deltaPhi * 100000.0 / 3600.0;
        double lambda = LAMBDA_0 + theta1.im * 180.0 / Math.PI;
        return new Point2D.Double(lambda, phi);
    }

    @Override
    public double getScale(Point2D.Double lonLat) {
        return 1.0;
    }

    public static void main(String[] args) {
        NewZealandMapGrid nzmg = new NewZealandMapGrid();
        Point2D.Double ll1 = new Point2D.Double(172.739194, -34.444066);
        Point2D.Double mg1 = nzmg.forward(ll1);
        System.out.println(mg1);
        Point2D.Double ll1p = nzmg.inverse(mg1);
        System.out.println(ll1p + "\n");
        Point2D.Double ll2 = new Point2D.Double(172.723106, -40.512409);
        Point2D.Double mg2 = nzmg.forward(ll2);
        System.out.println(mg2);
        Point2D.Double ll2p = nzmg.inverse(mg2);
        System.out.println(ll2p + "\n");
        Point2D.Double ll3 = new Point2D.Double(169.172062, -46.651295);
        Point2D.Double mg3 = nzmg.forward(ll3);
        System.out.println(mg3);
        Point2D.Double ll3p = nzmg.inverse(mg3);
        System.out.println(ll3p + "\n");
    }
}

