/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import gov.usgs.proj.Ellipsoid;
import gov.usgs.proj.FastProjector;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import gov.usgs.util.CodeTimer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JFrame;

public class Orthographic
extends Projection {
    private Point2D.Double origin;

    @Override
    public void setOrigin(Point2D.Double pt) {
        this.origin = pt;
    }

    @Override
    public Point2D.Double forward(Point2D.Double lonLat) {
        double r = Ellipsoid.ELLIPSOIDS[0].equatorialRadius;
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double phi = lonLat.getY() * (Math.PI / 180);
        double lambda = lonLat.getX() * (Math.PI / 180);
        double x = r * Math.cos(phi) * Math.sin(lambda - lambdaO);
        double y = r * (Math.cos(phiO) * Math.sin(phi) - Math.sin(phiO) * Math.cos(phi) * Math.cos(lambda - lambdaO));
        return new Point2D.Double(x, y);
    }

    @Override
    public Point2D.Double inverse(Point2D.Double xy) {
        double r = Ellipsoid.ELLIPSOIDS[0].equatorialRadius;
        double x = xy.x;
        double y = xy.y;
        double rho = Math.sqrt(x * x + y * y);
        double c = Math.asin(rho / r);
        if (Math.abs(rho) < 1.0E-5) {
            return this.origin;
        }
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double phi = Math.asin(Math.cos(c) * Math.sin(phiO) + y * Math.sin(c) * Math.cos(phiO) / rho);
        double lambda = lambdaO + Math.atan2(x * Math.sin(c), rho * Math.cos(phiO) * Math.cos(c) - y * Math.sin(phiO) * Math.sin(c));
        return new Point2D.Double(lambda * 57.29577951308232, phi * 57.29577951308232);
    }

    @Override
    public double getScale(Point2D.Double lonLat) {
        return 1.0;
    }

    @Override
    public double[] getProjectedExtents(GeoRange gr) {
        return new double[]{-7000000.0, 7000000.0, -7000000.0, 7000000.0};
    }

    @Override
    public FastProjector getFastProjector() {
        return new FastProjector(){
            double r;
            double phiO;
            double lambdaO;
            double spO;
            double cpO;
            double sc;
            double cc;
            double x;
            double y;
            double rho;
            double c;
            {
                this.r = Ellipsoid.ELLIPSOIDS[0].equatorialRadius;
                this.phiO = Orthographic.this.origin.getY() * (Math.PI / 180);
                this.lambdaO = Orthographic.this.origin.getX() * (Math.PI / 180);
                this.spO = Math.sin(this.phiO);
                this.cpO = Math.cos(this.phiO);
            }

            @Override
            public void forward(Point2D.Double pt) {
                pt = Orthographic.this.forward(pt);
            }

            @Override
            public void inverse(Point2D.Double xy) {
                this.x = xy.x;
                this.y = xy.y;
                this.rho = Math.sqrt(this.x * this.x + this.y * this.y);
                if (this.rho < 1.0E-5) {
                    xy.x = ((Orthographic)Orthographic.this).origin.x;
                    xy.y = ((Orthographic)Orthographic.this).origin.y;
                    return;
                }
                if (this.rho > this.r) {
                    xy.x = Double.NaN;
                    return;
                }
                this.c = Math.asin(this.rho / this.r);
                this.cc = Math.cos(this.c);
                this.sc = Math.sin(this.c);
                xy.x = (this.lambdaO + Math.atan2(this.x * this.sc, this.rho * this.cpO * this.cc - this.y * this.spO * this.sc)) * 57.29577951308232;
                xy.y = Math.asin(this.cc * this.spO + this.y * this.sc * this.cpO / this.rho) * 57.29577951308232;
            }
        };
    }

    public static void main(String[] args) throws Exception {
        Orthographic og = new Orthographic();
        GeoRange gr = new GeoRange(-180.0, 180.0, -90.0, 90.0);
        int m = 21;
        final Image[] imgs = new Image[21];
        CodeTimer ctl = new CodeTimer("load");
        JPEGImageDecoder codec = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream("c:\\mapdata\\nasa\\world.jpg"));
        BufferedImage bi = codec.decodeAsBufferedImage();
        ctl.mark("decode");
        Raster r = bi.getData();
        DataBufferInt dbi = (DataBufferInt)r.getDataBuffer();
        System.out.println(String.valueOf(dbi.getNumBanks()) + " " + dbi.getSize());
        int[] pix = dbi.getData();
        int i = 0;
        while (i < pix.length) {
            pix[i] = 0xFF000000 | pix[i];
            ++i;
        }
        ctl.mark("toint");
        ctl.stop();
        System.out.println("pix.length: " + pix.length);
        int k = 0;
        while (k < 21) {
            System.out.println(k);
            og.setOrigin(new Point2D.Double(0.0, 0.0));
            og.setOrigin(new Point2D.Double(10.0, -90.0 + (double)k / 21.0 * 360.0 + 3.0));
            imgs[k] = og.getProjectedImage(50, 1000, 1000, pix, 2700, 1350, gr, -1.0E7, 1.0E7, -1.0E7, 1.0E7);
            ++k;
        }
        JFrame f = new JFrame("GeoImageSet Test, Projected"){
            public static final long serialVersionUID = -1L;
            int cycle;
            {
                super($anonymous0);
                this.cycle = 0;
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.drawImage(imgs[++this.cycle % 21], 0, 0, null);
            }
        };
        f.setSize(1200, 1000);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        while (true) {
            f.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

