/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import gov.usgs.util.ProgressListener;
import gov.usgs.util.ResourceReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ProjectedImage {
    private double deltaX;
    private double deltaY;
    private double originX;
    private double originY;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int deadPixelsN = 0;
    private int deadPixelsS = 0;
    private GeoRange usefulRange;
    private BufferedImage image;
    private Projection projection;

    public ProjectedImage() {
    }

    public ProjectedImage(String ifn) throws Exception {
        this.image = ImageIO.read(new File(ifn));
        this.calculateBounds();
    }

    public ProjectedImage(BufferedImage img) {
        this.image = img;
    }

    public void readWorldFile(String wfn) {
        ResourceReader rr = ResourceReader.getResourceReader(wfn);
        this.deltaX = Double.parseDouble(rr.nextLine());
        rr.nextLine();
        rr.nextLine();
        this.deltaY = Double.parseDouble(rr.nextLine());
        this.originX = Double.parseDouble(rr.nextLine());
        this.originY = Double.parseDouble(rr.nextLine());
        this.calculateBounds();
    }

    public ProjectedImage(BufferedImage img, Projection proj, double dx, double dy, double ox, double oy, int dpN, int dpS) {
        this.image = img;
        this.deltaX = dx;
        this.deltaY = dy;
        this.originX = ox;
        this.originY = oy;
        this.projection = proj;
        this.deadPixelsN = dpN;
        this.deadPixelsS = dpS;
        this.calculateBounds();
    }

    public void setDeadPixels(int n, int s) {
        this.deadPixelsN = n;
        this.deadPixelsS = s;
        this.calculateBounds();
    }

    public void setImage(BufferedImage img) {
        this.image = img;
    }

    public void setProjection(Projection p) {
        this.projection = p;
    }

    protected void calculateBounds() {
        double a = this.originX;
        double b = this.originX + this.deltaX * (double)this.image.getWidth();
        this.minX = Math.min(a, b);
        this.maxX = Math.max(a, b);
        a = this.originY + (double)this.deadPixelsS * this.deltaY;
        b = this.originY + this.deltaY * (double)(this.image.getHeight() - (this.deadPixelsN + this.deadPixelsS));
        this.minY = Math.min(a, b);
        this.maxY = Math.max(a, b);
    }

    public void setUsefulRange(GeoRange gr) {
        this.usefulRange = gr;
    }

    public void setUsefulRangeToExtents() {
        this.usefulRange = new GeoRange(this.minX, this.maxX, this.minY, this.maxY);
    }

    public GeoRange getUsefulRange() {
        return this.usefulRange;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public boolean containsXY(double x, double y) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public boolean containsLL(Point2D.Double ll) {
        if (this.usefulRange == null) {
            return true;
        }
        return this.usefulRange.contains(ll);
    }

    public int getSourcePixel(int alpha, double sx, double sy, Interpolation interp) {
        if (interp == Interpolation.NEAREST_NEIGHBOR) {
            int xo = (int)((sx - this.originX) / this.deltaX);
            int yo = (int)((sy - this.originY) / this.deltaY);
            if (xo >= this.image.getWidth() || yo >= this.image.getHeight() || xo < 0 || yo < 0) {
                return 0xFFF0F0;
            }
            return this.image.getRGB(xo, yo);
        }
        if (interp == Interpolation.BILINEAR) {
            double xo = (sx - this.originX) / this.deltaX;
            double yo = (sy - this.originY) / this.deltaY;
            if (xo >= (double)(this.image.getWidth() - 1) || yo >= (double)(this.image.getHeight() - 1) || xo < 0.0 || yo < 0.0) {
                return 0xFFF0F0;
            }
            int pul = this.image.getRGB((int)xo, (int)yo);
            int pur = this.image.getRGB((int)xo + 1, (int)yo);
            int plr = this.image.getRGB((int)xo + 1, (int)yo + 1);
            int pll = this.image.getRGB((int)xo, (int)yo + 1);
            int px = (int)xo;
            int py = (int)yo;
            double delx = xo - (double)px;
            double dely = yo - (double)py;
            int ul = pul & 0xFF;
            int ur = pur & 0xFF;
            int lr = plr & 0xFF;
            int ll = pll & 0xFF;
            int b = (int)Math.round(dely * delx * (double)lr + (1.0 - delx) * dely * (double)ll + (1.0 - delx) * (1.0 - dely) * (double)ul + delx * (1.0 - dely) * (double)ur);
            ul = pul >> 8 & 0xFF;
            ur = pur >> 8 & 0xFF;
            lr = plr >> 8 & 0xFF;
            ll = pll >> 8 & 0xFF;
            int g = (int)Math.round(dely * delx * (double)lr + (1.0 - delx) * dely * (double)ll + (1.0 - delx) * (1.0 - dely) * (double)ul + delx * (1.0 - dely) * (double)ur);
            ul = pul >> 16 & 0xFF;
            ur = pur >> 16 & 0xFF;
            lr = plr >> 16 & 0xFF;
            ll = pll >> 16 & 0xFF;
            int r = (int)Math.round(dely * delx * (double)lr + (1.0 - delx) * dely * (double)ll + (1.0 - delx) * (1.0 - dely) * (double)ul + delx * (1.0 - dely) * (double)ur);
            ul = pul >> 24 & 0xFF;
            ur = pur >> 24 & 0xFF;
            lr = plr >> 24 & 0xFF;
            ll = pll >> 24 & 0xFF;
            int a = (int)Math.round(dely * delx * (double)lr + (1.0 - delx) * dely * (double)ll + (1.0 - delx) * (1.0 - dely) * (double)ul + delx * (1.0 - dely) * (double)ur);
            return b | g << 8 | r << 16 | a << 24;
        }
        return 0;
    }

    public ProjectedImage reprojectImage(Projection dest, double ox, double oy, double dx, double dy, int w, int h, Interpolation interp) {
        return this.reprojectImage(dest, ox, oy, dx, dy, w, h, interp, null);
    }

    public ProjectedImage reprojectImage(Projection dest, double ox, double oy, double dx, double dy, int w, int h, Interpolation interp, ProgressListener pl) {
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.dispose();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                double cx = ox + (double)x * dx;
                double cy = oy - (double)y * dy;
                Point2D.Double ll = dest.inverse(new Point2D.Double(cx, cy));
                if (this.containsLL(ll)) {
                    Point2D.Double src = this.projection.forward(ll);
                    if (this.containsXY(src.x, src.y)) {
                        img.setRGB(x, y, this.getSourcePixel(255, src.x, src.y, interp));
                    }
                }
                ++y;
            }
            if (pl != null) {
                pl.progressDone((float)x / (float)w);
            }
            ++x;
        }
        ProjectedImage pi = new ProjectedImage();
        pi.image = img;
        pi.originX = ox;
        pi.originY = oy;
        pi.deltaX = dx;
        pi.deltaY = -dy;
        pi.calculateBounds();
        pi.projection = dest;
        pi.setUsefulRange(new GeoRange(pi.projection, this.minX, this.maxX, this.minY, this.maxY));
        return pi;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public double getOriginX() {
        return this.originX;
    }

    public double getOriginY() {
        return this.originY;
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public double[] getBounds() {
        return new double[]{this.minX, this.maxX, this.minY, this.maxY};
    }

    public static enum Interpolation {
        NEAREST_NEIGHBOR,
        BILINEAR;

    }
}

