/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import gov.usgs.util.CodeTimer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JFrame;

public class TransverseMercator
extends Projection {
    private Point2D.Double origin;
    private double falseEasting;
    private double falseNorthing;

    public TransverseMercator() {
        this.name = "Transverse Mercator";
    }

    public int hashCode() {
        return this.origin.hashCode() + new Double(this.falseEasting).hashCode() + new Double(this.falseNorthing).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransverseMercator)) {
            return false;
        }
        TransverseMercator tm = (TransverseMercator)obj;
        return tm.falseEasting == this.falseEasting && tm.falseNorthing == this.falseNorthing && tm.origin.equals(this.origin);
    }

    public static TransverseMercator fromUTM(String utm) {
        TransverseMercator tm = new TransverseMercator();
        try {
            tm.falseEasting = 500000.0;
            int zoneNumber = Integer.parseInt(utm.substring(0, utm.length() - 1));
            char zoneLetter = utm.toUpperCase().charAt(utm.length() - 1);
            if (zoneLetter - 78 < 0) {
                tm.falseNorthing = 1.0E7;
            }
            double olon = (zoneNumber - 1) * 6 - 180 + 3;
            tm.origin = new Point2D.Double(olon, 0.0);
        }
        catch (Exception e) {
            return null;
        }
        return tm;
    }

    public void setup(Point2D.Double o, double e, double n) {
        this.origin = o;
        this.falseEasting = e;
        this.falseNorthing = n;
    }

    @Override
    public void setOrigin(Point2D.Double o) {
        this.origin = o;
    }

    @Override
    public double getScale(Point2D.Double lonLat) {
        return 0.9996;
    }

    private GeoRange getSouthGeoRange(double left, double right, double bottom, double top) {
        double dx = right - left;
        double dy = top - bottom;
        Point2D.Double c = this.inverse(new Point2D.Double(left + dx / 2.0, bottom + dy / 2.0));
        double north = this.inverse((Point2D.Double)new Point2D.Double((double)0.0, (double)top)).y;
        int n = 20;
        Point2D.Double[] ptsX = new Point2D.Double[n];
        Point2D.Double[] ptsY = new Point2D.Double[n];
        int i = 0;
        while (i < n) {
            ptsX[i] = new Point2D.Double(left + dx * ((double)i / (double)n), bottom);
            ptsY[i] = new Point2D.Double(left, bottom + dy * ((double)i / (double)n));
            ++i;
        }
        i = 1;
        while (i < n) {
            if (this.inverse((Point2D.Double)ptsY[i]).y > north) break;
            ++i;
        }
        double west = this.inverse((Point2D.Double)ptsY[i - 1]).x;
        double east = c.x - (west - c.x);
        i = 1;
        while (i < n) {
            if (this.inverse((Point2D.Double)ptsX[i]).x > west) break;
            ++i;
        }
        double south = this.inverse((Point2D.Double)ptsX[i - 1]).y;
        GeoRange gr = new GeoRange(west, east, south, north);
        return gr;
    }

    private GeoRange getNorthGeoRange(double left, double right, double bottom, double top) {
        double dx = right - left;
        double dy = top - bottom;
        Point2D.Double c = this.inverse(new Point2D.Double(left + dx / 2.0, bottom + dy / 2.0));
        double south = this.inverse((Point2D.Double)new Point2D.Double((double)0.0, (double)bottom)).y;
        int n = 20;
        Point2D.Double[] ptsX = new Point2D.Double[n];
        Point2D.Double[] ptsY = new Point2D.Double[n];
        int i = 0;
        while (i < n) {
            ptsX[i] = new Point2D.Double(left + dx * ((double)i / (double)n), top);
            ptsY[i] = new Point2D.Double(left, bottom + dy * ((double)i / (double)n));
            ++i;
        }
        i = 1;
        while (i < n) {
            if (this.inverse((Point2D.Double)ptsY[i]).y > south) break;
            ++i;
        }
        double west = this.inverse((Point2D.Double)ptsY[i - 1]).x;
        double east = c.x - (west - c.x);
        i = 1;
        while (i < n) {
            if (this.inverse((Point2D.Double)ptsX[i]).x > west) break;
            ++i;
        }
        double north = this.inverse((Point2D.Double)ptsX[i - 1]).y;
        GeoRange gr = new GeoRange(west, east, south, north);
        return gr;
    }

    @Override
    public GeoRange getGeoRange(double left, double right, double bottom, double top) {
        if (this.origin.y >= 0.0) {
            return this.getNorthGeoRange(left, right, bottom, top);
        }
        return this.getSouthGeoRange(left, right, bottom, top);
    }

    @Override
    public Point2D.Double[] forward(Point2D.Double[] lonLat) {
        double a = this.ellipsoid.equatorialRadius;
        double esq = this.ellipsoid.eccentricitySquared;
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double fe = this.falseEasting;
        double fn = this.falseNorthing;
        double scale = 0.9996;
        Point2D.Double[] result = new Point2D.Double[lonLat.length];
        double epsq = esq / (1.0 - esq);
        double MO = a * ((1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0) * phiO - (3.0 * esq / 8.0 + 3.0 * esq * esq / 32.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(2.0 * phiO) + (15.0 * esq * esq / 256.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(4.0 * phiO) - 35.0 * esq * esq * esq / 3072.0 * Math.sin(6.0 * phiO));
        int i = 0;
        while (i < lonLat.length) {
            double phi = lonLat[i].getY() * (Math.PI / 180);
            double lambda = lonLat[i].getX() * (Math.PI / 180);
            double N = a / Math.pow(1.0 - esq * Math.sin(phi) * Math.sin(phi), 0.5);
            double T = Math.tan(phi) * Math.tan(phi);
            double C = epsq * Math.cos(phi) * Math.cos(phi);
            double A = (lambda - lambdaO) * Math.cos(phi);
            double M = a * ((1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0) * phi - (3.0 * esq / 8.0 + 3.0 * esq * esq / 32.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(2.0 * phi) + (15.0 * esq * esq / 256.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(4.0 * phi) - 35.0 * esq * esq * esq / 3072.0 * Math.sin(6.0 * phi));
            double x = scale * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * epsq) * A * A * A * A * A / 120.0) + fe;
            double y = scale * (M - MO + N * Math.tan(phi) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * epsq) * A * A * A * A * A * A / 720.0)) + fn;
            result[i] = new Point2D.Double(x, y);
            ++i;
        }
        return result;
    }

    @Override
    public Point2D.Double[] inverse(Point2D.Double[] points) {
        double a = this.ellipsoid.equatorialRadius;
        double esq = this.ellipsoid.eccentricitySquared;
        double epsq = esq / (1.0 - esq);
        double scale = 0.9996;
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double fe = this.falseEasting;
        double fn = this.falseNorthing;
        double e1 = (1.0 - Math.sqrt(1.0 - esq)) / (1.0 + Math.sqrt(1.0 - esq));
        Point2D.Double[] result = new Point2D.Double[points.length];
        double MO = a * ((1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0) * phiO - (3.0 * esq / 8.0 + 3.0 * esq * esq / 32.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(2.0 * phiO) + (15.0 * esq * esq / 256.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(4.0 * phiO) - 35.0 * esq * esq * esq / 3072.0 * Math.sin(6.0 * phiO));
        int i = 0;
        while (i < points.length) {
            double x = points[i].getX() - fe;
            double y = points[i].getY() - fn;
            double M = MO + y / scale;
            double mu = M / (a * (1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0));
            double phi1 = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
            double N1 = a / Math.sqrt(1.0 - esq * Math.sin(phi1) * Math.sin(phi1));
            double T1 = Math.tan(phi1) * Math.tan(phi1);
            double C1 = epsq * Math.cos(phi1) * Math.cos(phi1);
            double R1 = a * (1.0 - esq) / Math.pow(1.0 - esq * Math.sin(phi1) * Math.sin(phi1), 1.5);
            double D = x / (N1 * scale);
            double phi = (phi1 - N1 * Math.tan(phi1) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * epsq) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * epsq - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0)) * 57.29577951308232;
            double lambda = (lambdaO + (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * epsq + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1)) * 57.29577951308232;
            result[i] = new Point2D.Double(lambda, phi);
            ++i;
        }
        return result;
    }

    @Override
    public Point2D.Double forward(Point2D.Double lonLat) {
        double a = this.ellipsoid.equatorialRadius;
        double esq = this.ellipsoid.eccentricitySquared;
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double fe = this.falseEasting;
        double fn = this.falseNorthing;
        double scale = 0.9996;
        double epsq = esq / (1.0 - esq);
        double MO = a * ((1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0) * phiO - (3.0 * esq / 8.0 + 3.0 * esq * esq / 32.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(2.0 * phiO) + (15.0 * esq * esq / 256.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(4.0 * phiO) - 35.0 * esq * esq * esq / 3072.0 * Math.sin(6.0 * phiO));
        double phi = lonLat.getY() * (Math.PI / 180);
        double lambda = lonLat.getX() * (Math.PI / 180);
        double N = a / Math.pow(1.0 - esq * Math.sin(phi) * Math.sin(phi), 0.5);
        double T = Math.tan(phi) * Math.tan(phi);
        double C = epsq * Math.cos(phi) * Math.cos(phi);
        double dl = lambda - lambdaO;
        while (dl < -1.5707963267948966) {
            dl += Math.PI;
        }
        while (dl > 1.5707963267948966) {
            dl -= Math.PI;
        }
        double A = dl * Math.cos(phi);
        double M = a * ((1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0) * phi - (3.0 * esq / 8.0 + 3.0 * esq * esq / 32.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(2.0 * phi) + (15.0 * esq * esq / 256.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(4.0 * phi) - 35.0 * esq * esq * esq / 3072.0 * Math.sin(6.0 * phi));
        double x = scale * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * epsq) * A * A * A * A * A / 120.0) + fe;
        double y = scale * (M - MO + N * Math.tan(phi) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * epsq) * A * A * A * A * A * A / 720.0)) + fn;
        return new Point2D.Double(x, y);
    }

    @Override
    public Point2D.Double inverse(Point2D.Double xy) {
        double a = this.ellipsoid.equatorialRadius;
        double esq = this.ellipsoid.eccentricitySquared;
        double epsq = esq / (1.0 - esq);
        double scale = 0.9996;
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double fe = this.falseEasting;
        double fn = this.falseNorthing;
        double e1 = (1.0 - Math.sqrt(1.0 - esq)) / (1.0 + Math.sqrt(1.0 - esq));
        double MO = a * ((1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0) * phiO - (3.0 * esq / 8.0 + 3.0 * esq * esq / 32.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(2.0 * phiO) + (15.0 * esq * esq / 256.0 + 45.0 * esq * esq * esq / 1024.0) * Math.sin(4.0 * phiO) - 35.0 * esq * esq * esq / 3072.0 * Math.sin(6.0 * phiO));
        double x = xy.getX() - fe;
        double y = xy.getY() - fn;
        double M = MO + y / scale;
        double mu = M / (a * (1.0 - esq / 4.0 - 3.0 * esq * esq / 64.0 - 5.0 * esq * esq * esq / 256.0));
        double phi1 = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double N1 = a / Math.sqrt(1.0 - esq * Math.sin(phi1) * Math.sin(phi1));
        double T1 = Math.tan(phi1) * Math.tan(phi1);
        double C1 = epsq * Math.cos(phi1) * Math.cos(phi1);
        double R1 = a * (1.0 - esq) / Math.pow(1.0 - esq * Math.sin(phi1) * Math.sin(phi1), 1.5);
        double D = x / (N1 * scale);
        double phi = (phi1 - N1 * Math.tan(phi1) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * epsq) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * epsq - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0)) * 57.29577951308232;
        double lambda = (lambdaO + (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * epsq + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1)) * 57.29577951308232;
        if (lambda > 180.0) {
            lambda -= 360.0;
        }
        return new Point2D.Double(lambda, phi);
    }

    @Override
    public String getInverseJavaScript() {
        StringBuffer sb = new StringBuffer(2048);
        sb.append("function inverse(x, y)\n");
        sb.append("{\n");
        sb.append("var N1,T1,C1,R1,D,M,MO,phi1,mu,phi,lambda;\n");
        sb.append("var a=" + this.ellipsoid.equatorialRadius + ";\n");
        sb.append("var esq=" + this.ellipsoid.eccentricitySquared + ";\n");
        sb.append("var epsq=esq/(1-esq);\n");
        sb.append("var scale=0.9996;\n");
        sb.append("var phiO=" + this.origin.getY() * (Math.PI / 180) + ";\n");
        sb.append("var lambdaO=" + this.origin.getX() * (Math.PI / 180) + ";\n");
        sb.append("var e1=(1-Math.sqrt(1-esq))/(1+Math.sqrt(1-esq));\n");
        sb.append("MO=a*(");
        sb.append("(1-esq/4-3*esq*esq/64-5*esq*esq*esq/256)*phiO-");
        sb.append("(3*esq/8+3*esq*esq/32+45*esq*esq*esq/1024)*Math.sin(2*phiO)+");
        sb.append("(15*esq*esq/256+45*esq*esq*esq/1024)*Math.sin(4*phiO)-");
        sb.append("(35*esq*esq*esq/3072)*Math.sin(6*phiO));\n");
        sb.append("x=x-" + this.falseEasting + ";\n");
        sb.append("y=y-" + this.falseNorthing + ";\n");
        sb.append("M=MO+y/scale;\n");
        sb.append("mu=M/(a*(1-esq/4-3*esq*esq/64-5*esq*esq*esq/256));\n");
        sb.append("phi1=mu+(3*e1/2-27*e1*e1*e1/32)*Math.sin(2*mu)+(21*e1*e1/16-55*e1*e1*e1*e1/32)*Math.sin(4*mu)+(151*e1*e1*e1/96)*Math.sin(6*mu);\n");
        sb.append("N1=a/Math.sqrt(1-esq*Math.sin(phi1)*Math.sin(phi1));\n");
        sb.append("T1=Math.tan(phi1)*Math.tan(phi1);\n");
        sb.append("C1=epsq*Math.cos(phi1)*Math.cos(phi1);\n");
        sb.append("R1=a*(1-esq)/Math.pow(1-esq*Math.sin(phi1)*Math.sin(phi1),1.5);\n");
        sb.append("D=x/(N1*scale);\n");
        sb.append("phi=(phi1-(N1*Math.tan(phi1)/R1)*(D*D/2-(5+3*T1+10*C1-4*C1*C1-9*epsq)*D*D*D*D/24+(61+90*T1+298*C1+45*T1*T1-252*epsq-3*C1*C1)*D*D*D*D*D*D/720))*57.29577951308232;\n");
        sb.append("lambda=(lambdaO+((D-(1+2*T1+C1)*D*D*D/6+(5-2*C1+28*T1-3*C1*C1+8*epsq+24*T1*T1)*D*D*D*D*D/120)/Math.cos(phi1)))*57.29577951308232;\n");
        sb.append("return new Array(lambda, phi);\n");
        sb.append("}\n");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        TransverseMercator merc = new TransverseMercator();
        GeoRange gr = new GeoRange(-180.0, 180.0, -90.0, 90.0);
        boolean m = true;
        final Image[] imgs = new Image[1];
        CodeTimer ctl = new CodeTimer("load");
        JPEGImageDecoder codec = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream("c:\\mapdata\\nasa\\world.jpg"));
        BufferedImage bi = codec.decodeAsBufferedImage();
        ctl.mark("decode");
        Raster r = bi.getData();
        DataBufferInt dbi = (DataBufferInt)r.getDataBuffer();
        System.out.println(String.valueOf(dbi.getNumBanks()) + " " + dbi.getSize());
        int[] pix = dbi.getData();
        int i = 0;
        while (i < pix.length) {
            pix[i] = 0xFF000000 | pix[i];
            ++i;
        }
        ctl.mark("toint");
        ctl.stop();
        System.out.println("pix.length: " + pix.length);
        merc.setOrigin(new Point2D.Double(175.0, -40.0));
        imgs[0] = merc.getProjectedImage(50, 1000, 1000, pix, 2700, 1350, gr, -2000000.0, 2000000.0, -2000000.0, 2000000.0);
        JFrame f = new JFrame("GeoImageSet Test, Projected"){
            public static final long serialVersionUID = -1L;
            int cycle;
            {
                super($anonymous0);
                this.cycle = 0;
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                if (this.cycle == 0) {
                    g2.fillRect(0, 0, 1200, 1000);
                }
                g2.drawImage(imgs[++this.cycle % 1], 0, 0, null);
            }
        };
        f.setSize(1200, 1000);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        while (true) {
            f.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

