/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmDialog;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.TimeZone;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OptionsDialog
extends SwarmDialog {
    private static final long serialVersionUID = 1L;
    private JPanel dialogPanel;
    private JCheckBox durationEnabled;
    private JTextField durationA;
    private JTextField durationB;
    private JCheckBox useLargeCursor;
    private JCheckBox tzInstrument;
    private JRadioButton tzLocal;
    private JRadioButton tzSpecific;
    private JComboBox timeZones;
    private JRadioButton useMapPacks;
    private JRadioButton useWMS;
    private JTextField wmsServer;
    private JTextField wmsLayer;
    private JTextField wmsStyles;
    private JLabel wmsServerLabel;
    private JLabel wmsLayerLabel;
    private JLabel wmsStylesLabel;

    public OptionsDialog() {
        super(Swarm.getApplication(), "Options", true);
        this.createUI();
        this.setCurrentValues();
        this.setSizeAndLocation();
    }

    private void createFields() {
        this.durationEnabled = new JCheckBox("Enabled");
        this.durationA = new JTextField();
        this.durationB = new JTextField();
        this.useLargeCursor = new JCheckBox("Large Helicorder Cursor");
        this.tzInstrument = new JCheckBox("Use instrument time zone if available");
        this.tzLocal = new JRadioButton("Use local machine time zone:");
        this.tzSpecific = new JRadioButton("Use specific time zone:");
        ButtonGroup tzGroup = new ButtonGroup();
        tzGroup.add(this.tzLocal);
        tzGroup.add(this.tzSpecific);
        Object[] tzs = TimeZone.getAvailableIDs();
        Arrays.sort(tzs);
        this.timeZones = new JComboBox<Object>(tzs);
        this.useMapPacks = new JRadioButton("Use local MapPacks");
        this.useWMS = new JRadioButton("Use WMS");
        ButtonGroup mapGroup = new ButtonGroup();
        mapGroup.add(this.useMapPacks);
        mapGroup.add(this.useWMS);
        this.wmsLayer = new JTextField();
        this.wmsServer = new JTextField();
        this.wmsStyles = new JTextField();
    }

    @Override
    protected void createUI() {
        super.createUI();
        this.createFields();
        FormLayout layout = new FormLayout("right:max(30dlu;pref), 3dlu, 40dlu, 3dlu, right:max(40dlu;pref), 3dlu, 40dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Time Zone");
        builder.append((Component)this.tzInstrument, 7);
        builder.nextLine();
        TimeZone local = TimeZone.getDefault();
        builder.append((Component)this.tzLocal, 7);
        builder.append("   ");
        builder.append((Component)new JLabel(local.getID()), 5);
        builder.nextLine();
        builder.append((Component)this.tzSpecific, 7);
        builder.nextLine();
        builder.append("   ");
        builder.append((Component)this.timeZones, 5);
        builder.nextLine();
        builder.appendSeparator("Duration Magnitude");
        builder.append((Component)this.durationEnabled, 7);
        builder.nextLine();
        builder.append("Md=", (Component)this.durationA);
        builder.append("* Log(t) +", (Component)this.durationB);
        builder.appendSeparator("Maps");
        builder.append((Component)this.useMapPacks, 7);
        builder.nextLine();
        builder.append((Component)this.useWMS, 7);
        builder.nextLine();
        this.wmsServerLabel = new JLabel("Server:");
        this.wmsServerLabel.setLabelFor(this.wmsServer);
        builder.append((Component)this.wmsServerLabel);
        builder.append((Component)this.wmsServer, 5);
        builder.nextLine();
        this.wmsLayerLabel = new JLabel("Layer:");
        this.wmsLayerLabel.setLabelFor(this.wmsLayer);
        builder.append((Component)this.wmsLayerLabel);
        builder.append((Component)this.wmsLayer, 5);
        builder.nextLine();
        this.wmsStylesLabel = new JLabel("Styles:");
        this.wmsStylesLabel.setLabelFor(this.wmsStyles);
        builder.append((Component)this.wmsStylesLabel);
        builder.append((Component)this.wmsStyles, 5);
        builder.nextLine();
        this.useMapPacks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OptionsDialog.this.doEnables();
            }
        });
        builder.appendSeparator("Other");
        builder.append((Component)this.useLargeCursor, 7);
        builder.nextLine();
        this.dialogPanel = builder.getPanel();
        this.mainPanel.add((Component)this.dialogPanel, "Center");
    }

    public void doEnables() {
        boolean state = this.useMapPacks.isSelected();
        this.wmsServer.setEnabled(!state);
        this.wmsLayer.setEnabled(!state);
        this.wmsStyles.setEnabled(!state);
        this.wmsServerLabel.setEnabled(!state);
        this.wmsLayerLabel.setEnabled(!state);
        this.wmsStylesLabel.setEnabled(!state);
    }

    public void setCurrentValues() {
        this.useLargeCursor.setSelected(Swarm.config.useLargeCursor);
        this.durationA.setText(Double.toString(Swarm.config.durationA));
        this.durationB.setText(Double.toString(Swarm.config.durationB));
        this.durationEnabled.setSelected(Swarm.config.durationEnabled);
        this.tzInstrument.setSelected(Swarm.config.useInstrumentTimeZone);
        if (Swarm.config.useLocalTimeZone) {
            this.tzLocal.setSelected(true);
        } else {
            this.tzSpecific.setSelected(true);
        }
        this.timeZones.setSelectedItem(Swarm.config.specificTimeZone.getID());
        this.useMapPacks.setSelected(!Swarm.config.useWMS);
        this.useWMS.setSelected(Swarm.config.useWMS);
        this.wmsServer.setText(Swarm.config.wmsServer);
        this.wmsLayer.setText(Swarm.config.wmsLayer);
        this.wmsStyles.setText(Swarm.config.wmsStyles);
        this.doEnables();
    }

    @Override
    public boolean allowOK() {
        String message = null;
        try {
            message = "The duration magnitude constants must be numbers.";
            Double.parseDouble(this.durationA.getText().trim());
            Double.parseDouble(this.durationB.getText().trim());
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, message, "Options Error", 0);
            return false;
        }
    }

    @Override
    public void wasOK() {
        Swarm.config.useLargeCursor = this.useLargeCursor.isSelected();
        Swarm.config.durationEnabled = this.durationEnabled.isSelected();
        Swarm.config.durationA = Double.parseDouble(this.durationA.getText().trim());
        Swarm.config.durationB = Double.parseDouble(this.durationB.getText().trim());
        Swarm.config.useInstrumentTimeZone = this.tzInstrument.isSelected();
        Swarm.config.useLocalTimeZone = this.tzLocal.isSelected();
        Swarm.config.specificTimeZone = TimeZone.getTimeZone((String)this.timeZones.getSelectedItem());
        Swarm.config.useWMS = this.useWMS.isSelected();
        Swarm.config.wmsServer = this.wmsServer.getText();
        Swarm.config.wmsLayer = this.wmsLayer.getText();
        Swarm.config.wmsStyles = this.wmsStyles.getText();
        Swarm.getApplication().optionsChanged();
    }
}

