/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import gov.usgs.plot.AxisRenderer;
import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.GradientSpectrum;
import gov.usgs.plot.Plot;
import gov.usgs.plot.Spectrum;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.CurrentTime;
import gov.usgs.vdx.data.wave.Wave;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javax.swing.JComponent;

public class WigglerPanel
extends JComponent
implements Runnable {
    public static final long serialVersionUID = -1L;
    public static final int X_OFFSET = 2;
    public static final int Y_OFFSET = 2;
    public static final int RIGHT_WIDTH = 2;
    public static final int BOTTOM_HEIGHT = 2;
    private static final Spectrum spectrum = new GradientSpectrum(255, 0.15, 0.15, 0.15, 1.0, 1.0, 1.0);
    private Wave wave;
    private Thread animator;
    private boolean kill = false;
    private int maxY = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private AnimatedWaveRenderer waveRenderer;
    private Plot plot;
    private SeismicDataSource dataSource;
    private String channel;
    private BasicStroke boldStroke = new BasicStroke(2.0f);
    private Line2D.Double line = new Line2D.Double();
    private Rectangle rectangle = new Rectangle();
    private static int wigglers = 0;

    public WigglerPanel(SeismicDataSource sds, String c) {
        ++wigglers;
        this.plot = new Plot();
        this.dataSource = sds;
        this.channel = c;
        this.waveRenderer = new AnimatedWaveRenderer();
        this.plot.addRenderer(this.waveRenderer);
        AxisRenderer axis = new AxisRenderer(this.waveRenderer);
        axis.setBackgroundColor(Color.white);
        this.waveRenderer.setAxis(axis);
        this.plot.setBackgroundColor(new Color(247, 247, 247));
        this.animator = new Thread(this);
        this.animator.setPriority(1);
        this.animator.start();
    }

    public synchronized void setWave(Wave w) {
        this.wave = w;
    }

    public void kill() {
        this.kill = true;
        --wigglers;
    }

    @Override
    public void run() {
        while (!this.kill) {
            try {
                Thread.sleep(100 * wigglers);
                double now = CurrentTime.getInstance().nowJ2K();
                this.setWave(this.dataSource.getWave(this.channel, now - 20.0, now - 10.0));
                this.waveRenderer.setWave(this.wave);
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dataSource.close();
        Swarm.logger.fine("Wiggler killed.");
    }

    @Override
    public void paint(Graphics g) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0 || this.wave == null) {
            return;
        }
        this.plot.setSize(this.getWidth(), this.getHeight());
        int[] dr = this.wave.getDataRange();
        int miny = Math.min(dr[0], this.minY);
        int maxy = Math.max(dr[1], this.maxY);
        if (dr[0] > this.minY) {
            this.minY += 2;
        }
        if (dr[1] < this.maxY) {
            this.maxY -= 2;
        }
        this.waveRenderer.setStop(this.wave.getEndTime() - 0.2);
        this.waveRenderer.setExtents(this.wave.getStartTime(), this.wave.getEndTime(), miny, maxy);
        this.waveRenderer.setLocation(2, 2, this.getWidth() - 2 - 2, this.getHeight() - 2 - 2);
        this.plot.render((Graphics2D)g);
    }

    class AnimatedWaveRenderer
    extends FrameRenderer {
        private double stop;
        private Wave renderWave;

        AnimatedWaveRenderer() {
        }

        public void setWave(Wave sw) {
            this.renderWave = sw;
        }

        public void setStop(double d) {
            this.stop = d;
        }

        @Override
        public void render(Graphics2D g) {
            Shape origClip = g.getClip();
            if (this.axis != null) {
                this.axis.render(g);
            }
            if (this.renderWave == null || this.renderWave.buffer == null || this.renderWave.buffer.length == 0) {
                return;
            }
            WigglerPanel.this.rectangle.setRect(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1);
            g.clip(WigglerPanel.this.rectangle);
            double st = this.renderWave.getStartTime();
            double step = 1.0 / this.renderWave.getSamplingRate();
            int[] buffer = this.renderWave.buffer;
            int bias = 0;
            int y = buffer[0];
            y = bias;
            g.setColor(Color.blue);
            double lastX = this.getXPixel(st);
            double lastY = this.getYPixel(y - bias);
            boolean flip = false;
            Stroke oldStroke = g.getStroke();
            int i = 1;
            while (i < buffer.length - 1) {
                float r = 1.0f - (float)i / (float)buffer.length;
                if (!flip && (double)r < 0.04) {
                    g.setColor(Color.red);
                    g.setStroke(WigglerPanel.this.boldStroke);
                    flip = true;
                } else if ((double)r >= 0.04) {
                    g.setColor(spectrum.getColorByRatio(r));
                }
                if ((st += step) > this.stop) break;
                y = buffer[i];
                if (y != Wave.NO_DATA) {
                    WigglerPanel.this.line.setLine(lastX, lastY, this.getXPixel(st), this.getYPixel(y));
                }
                lastX = this.getXPixel(st);
                lastY = this.getYPixel(y);
                g.draw(WigglerPanel.this.line);
                ++i;
            }
            g.setStroke(oldStroke);
            g.setClip(origClip);
        }
    }
}

