/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.chooser;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.chooser.DataSourcePanel;
import gov.usgs.util.ResourceReader;
import java.awt.Component;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class DHIPanel
extends DataSourcePanel {
    private static final String IRIS_NETWORK_FILE = "IRIS_networks.txt";
    private JComboBox netDC;
    private JComboBox netDNS;
    private JComboBox seisDC;
    private JComboBox seisDNS;
    private JComboBox network;
    private JTextField gulperSize;
    private JTextField gulperDelay;
    private JButton nwButton;
    private JButton dcButton;

    public DHIPanel() {
        super("dhi", "DMC");
    }

    private String checkComboBox(JComboBox box, String name) {
        String val = (String)box.getSelectedItem();
        if (val == null || val.length() == 0) {
            return "There is an error with the " + name + ".";
        }
        return null;
    }

    @Override
    public boolean allowOK(boolean edit) {
        String message = null;
        message = this.checkComboBox(this.netDC, "Network DC");
        if (message == null) {
            message = this.checkComboBox(this.netDNS, "Network DNS");
        }
        if (message == null) {
            message = this.checkComboBox(this.seisDC, "Seismogram DC");
        }
        if (message == null) {
            message = this.checkComboBox(this.seisDNS, "Seismogram DNS");
        }
        if (message == null) {
            message = this.checkComboBox(this.network, "Network");
        }
        double gs = -1.0;
        try {
            gs = Double.parseDouble(this.gulperSize.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gs <= 0.0) {
            message = "The gulper size must be greater than 0 minutes.";
        }
        double gd = -1.0;
        try {
            gd = Double.parseDouble(this.gulperDelay.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gd < 0.0) {
            message = "The gulper delay must be greater than or equal to 0 seconds.";
        }
        if (message != null) {
            JOptionPane.showMessageDialog(Swarm.getApplication(), message, "Error", 0);
            return false;
        }
        return true;
    }

    private void createFields() {
        this.netDC = new JComboBox();
        this.netDC.setEditable(true);
        this.netDNS = new JComboBox();
        this.netDNS.setEditable(true);
        this.seisDC = new JComboBox();
        this.seisDC.setEditable(true);
        this.seisDNS = new JComboBox();
        this.seisDNS.setEditable(true);
        this.network = new JComboBox();
        this.network.setEditable(true);
        URL u = this.getClass().getClassLoader().getResource(IRIS_NETWORK_FILE);
        ResourceReader rr = ResourceReader.getResourceReader(u);
        if (rr != null) {
            String s;
            while ((s = rr.nextLine()) != null) {
                if ((s = s.trim()).length() <= 1 || s.startsWith("#")) continue;
                this.network.addItem(s);
            }
        } else {
            Swarm.logger.warning("IRIS_networks.txt is missing.");
        }
        this.gulperSize = new JTextField();
        this.gulperDelay = new JTextField();
        this.dcButton = new JButton("Query for DCs");
        this.dcButton.setEnabled(false);
        this.nwButton = new JButton("Query for Networks");
        this.nwButton.setEnabled(false);
        String ndns = "edu/iris/dmc";
        String ndc = "IRIS_NetworkDC";
        String sdns = "edu/iris/dmc";
        String sdc = "IRIS_BudDataCenter";
        String nw = null;
        String gs = "60";
        String gd = "1.0";
        if (this.source != null && this.source.indexOf(";dhi:") != -1) {
            String[] ss = this.source.substring(this.source.indexOf(";dhi:") + 5).split(":");
            ndns = ss[0];
            ndc = ss[1];
            sdns = ss[2];
            sdc = ss[3];
            nw = ss[4];
            gs = String.format("%.0f", (double)Integer.parseInt(ss[5]) / 60.0);
            gd = String.format("%.1f", (double)Integer.parseInt(ss[6]) / 1000.0);
        }
        this.netDC.addItem(ndc);
        this.netDNS.addItem(ndns);
        this.seisDC.addItem(sdc);
        this.seisDNS.addItem(sdns);
        if (nw != null) {
            boolean found = false;
            int i = 0;
            while (i < this.network.getItemCount()) {
                String item = (String)this.network.getItemAt(i);
                if (item.startsWith(nw)) {
                    this.network.setSelectedIndex(i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.network.insertItemAt(nw, 0);
                this.network.setSelectedIndex(0);
            }
        }
        this.gulperSize.setText(gs);
        this.gulperDelay.setText(gd);
    }

    @Override
    protected void createPanel() {
        this.createFields();
        FormLayout layout = new FormLayout("right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 45dlu, 3dlu, right:max(20dlu;pref), 3dlu, 85dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel("Use this data source to connect to a Data Management Center (DMC)."), 9);
        builder.nextLine();
        builder.appendSeparator();
        builder.append("Network DC:");
        builder.append((Component)this.netDC, 3);
        builder.append("DNS:");
        builder.append((Component)this.netDNS);
        builder.nextLine();
        builder.append("Seismogram DC:");
        builder.append((Component)this.seisDC, 3);
        builder.append("DNS:");
        builder.append((Component)this.seisDNS);
        builder.nextLine();
        builder.append("Network:");
        builder.append((Component)this.network, 7);
        builder.nextLine();
        builder.append("Gulp size:");
        builder.append((Component)this.gulperSize);
        builder.append(" minutes");
        builder.append(" ");
        builder.append((Component)this.dcButton);
        builder.nextLine();
        builder.append("Gulp delay:");
        builder.append((Component)this.gulperDelay);
        builder.append(" seconds");
        builder.append(" ");
        builder.append((Component)this.nwButton);
        this.panel = builder.getPanel();
    }

    @Override
    public String wasOK() {
        int gs = (int)(Double.parseDouble(this.gulperSize.getText()) * 60.0);
        int gd = (int)(Double.parseDouble(this.gulperDelay.getText()) * 1000.0);
        String nw = (String)this.network.getSelectedItem();
        if (nw.indexOf(",") != -1) {
            nw = nw.substring(0, nw.indexOf(","));
        }
        String result = String.format("dhi:%s:%s:%s:%s:%s:%d:%d", this.netDNS.getSelectedItem(), this.netDC.getSelectedItem(), this.seisDNS.getSelectedItem(), this.seisDC.getSelectedItem(), nw, gs, gd);
        return result;
    }
}

