/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.chooser;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.chooser.DataSourcePanel;
import java.awt.Component;
import java.util.Arrays;
import java.util.TimeZone;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class WaveServerPanel
extends DataSourcePanel {
    private JTextField wsHost;
    private JTextField wsPort;
    private JTextField wsTimeout;
    private JTextField gulperSize;
    private JTextField gulperDelay;
    private JComboBox wsOffset;

    public WaveServerPanel() {
        super("ws", "Earthworm Wave Server");
    }

    private void createFields() {
        this.wsHost = new JTextField();
        this.wsPort = new JTextField();
        this.wsTimeout = new JTextField();
        this.gulperSize = new JTextField();
        this.gulperDelay = new JTextField();
        Object[] tzs = TimeZone.getAvailableIDs();
        Arrays.sort(tzs);
        this.wsOffset = new JComboBox<Object>(tzs);
        String h = "";
        String p = "16022";
        String t = "2.0";
        String gs = "30";
        String gd = "1.0";
        this.wsOffset.setSelectedItem("UTC");
        if (this.source != null && this.source.indexOf(";ws:") != -1) {
            String[] ss = this.source.substring(this.source.indexOf(";ws:") + 4).split(":");
            h = ss[0];
            p = ss[1];
            t = String.format("%.1f", (double)Integer.parseInt(ss[2]) / 1000.0);
            gs = String.format("%.0f", (double)Integer.parseInt(ss[3]) / 60.0);
            gd = String.format("%.1f", (double)Integer.parseInt(ss[4]) / 1000.0);
            if (ss.length >= 6) {
                this.wsOffset.setSelectedItem(ss[5]);
            }
        }
        this.wsHost.setText(h);
        this.wsPort.setText(p);
        this.wsTimeout.setText(t);
        this.gulperSize.setText(gs);
        this.gulperDelay.setText(gd);
    }

    @Override
    protected void createPanel() {
        this.createFields();
        FormLayout layout = new FormLayout("right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 126dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel("Use this data source to connect to an Earthworm Wave Server (EWS)."), 5);
        builder.nextLine();
        builder.appendSeparator();
        builder.append("IP address or host name:");
        builder.append((Component)this.wsHost, 3);
        builder.nextLine();
        builder.append("Port:");
        builder.append((Component)this.wsPort);
        builder.append(" Earthworm default: 16022");
        builder.nextLine();
        builder.append("Timeout:");
        builder.append((Component)this.wsTimeout);
        builder.append(" seconds");
        builder.nextLine();
        builder.append("Gulp size:");
        builder.append((Component)this.gulperSize);
        builder.append(" minutes");
        builder.nextLine();
        builder.append("Gulp delay:");
        builder.append((Component)this.gulperDelay);
        builder.append(" seconds");
        builder.append("Time zone:");
        builder.append((Component)this.wsOffset, 3);
        builder.nextLine();
        this.panel = builder.getPanel();
    }

    @Override
    public boolean allowOK(boolean edit) {
        String message = null;
        String host = this.wsHost.getText();
        if (host == null || host.length() == 0 || host.indexOf(59) != -1 || host.indexOf(58) != -1) {
            message = "There is an error with the Wave Server IP address or host name.";
        }
        int ip = -1;
        try {
            ip = Integer.parseInt(this.wsPort.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ip < 0 || ip > 65535) {
            message = "There is an error with the Wave Server port.";
        }
        double to = -1.0;
        try {
            to = Double.parseDouble(this.wsTimeout.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (to <= 0.0) {
            message = "There is an error with the Wave Server time out (must be > 0).";
        }
        double gs = -1.0;
        try {
            gs = Double.parseDouble(this.gulperSize.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gs <= 0.0) {
            message = "The gulper size must be greater than 0 minutes.";
        }
        double gd = -1.0;
        try {
            gd = Double.parseDouble(this.gulperDelay.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gd < 0.0) {
            message = "The gulper delay must be greater than or equal to 0 seconds.";
        }
        if (message != null) {
            JOptionPane.showMessageDialog(Swarm.getApplication(), message, "Error", 0);
            return false;
        }
        return true;
    }

    @Override
    public String wasOK() {
        int timeout = (int)(Double.parseDouble(this.wsTimeout.getText()) * 1000.0);
        int gs = (int)(Double.parseDouble(this.gulperSize.getText()) * 60.0);
        int gd = (int)(Double.parseDouble(this.gulperDelay.getText()) * 1000.0);
        String result = String.format("ws:%s:%s:%d:%d:%d:%s", this.wsHost.getText(), this.wsPort.getText(), timeout, gs, gd, this.wsOffset.getSelectedItem());
        return result;
    }
}

