/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.Wave;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CachedDataSource
extends SeismicDataSource {
    protected static final int MAX_WAVE_SIZE = 1000000;
    protected long maxSize;
    protected Map<String, List<CachedHelicorder>> helicorderCache = new HashMap<String, List<CachedHelicorder>>();
    protected Map<String, List<CachedWave>> waveCache = new HashMap<String, List<CachedWave>>();
    protected CachePurgeAction[] purgeActions;

    public CachedDataSource() {
        this.maxSize = Runtime.getRuntime().maxMemory() / 6L;
        this.createPurgeActions();
    }

    @Override
    public boolean isActiveSource() {
        return false;
    }

    public synchronized Wave getBestWave(String station, double t1, double t2) {
        List<CachedWave> waves = this.waveCache.get(station);
        if (waves == null) {
            return null;
        }
        ArrayList<Wave> parts = new ArrayList<Wave>();
        double minT = 1.0E300;
        double maxT = -1.0E300;
        for (CachedWave cw : waves) {
            if (!cw.wave.overlaps(t1, t2)) continue;
            parts.add(cw.wave);
            minT = Math.min(minT, cw.t1);
            maxT = Math.max(maxT, cw.t2);
        }
        if (parts.size() == 1) {
            return (Wave)parts.get(0);
        }
        Wave wave = Wave.join(parts, minT, maxT);
        if (wave != null) {
            wave = wave.subset(t1, t2);
        }
        return wave;
    }

    @Override
    public synchronized Wave getWave(String station, double t1, double t2) {
        List<CachedWave> waves = this.waveCache.get(station);
        if (waves == null) {
            return null;
        }
        for (CachedWave cw : waves) {
            if (!(t1 >= cw.t1) || !(t2 <= cw.t2)) continue;
            try {
                int[] newbuf = new int[(int)((t2 - t1) * cw.wave.getSamplingRate())];
                int i = (int)((t1 - cw.wave.getStartTime()) * cw.wave.getSamplingRate());
                System.arraycopy(cw.wave.buffer, i, newbuf, 0, newbuf.length);
                Wave sw = new Wave(newbuf, t1, cw.wave.getSamplingRate());
                cw.lastAccess = System.currentTimeMillis();
                return sw;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public List<String> getChannels() {
        ArrayList<String> st = new ArrayList<String>();
        for (String key : this.helicorderCache.keySet()) {
            st.add(key);
        }
        if (st.size() == 0) {
            return null;
        }
        return st;
    }

    @Override
    public synchronized HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station);
        if (helis == null) {
            return null;
        }
        HelicorderData hd = new HelicorderData();
        for (CachedHelicorder ch : helis) {
            HelicorderData hd2;
            if (t1 >= ch.t1 && t2 <= ch.t2) {
                hd2 = ch.helicorder.subset(t1, t2);
                ch.lastAccess = System.currentTimeMillis();
                return hd2;
            }
            if (t1 < ch.t1 && t2 >= ch.t2 || t1 <= ch.t1 && t2 > ch.t2) {
                hd.concatenate(ch.helicorder);
                ch.lastAccess = System.currentTimeMillis();
            }
            if (t1 < ch.t1 && t2 > ch.t1 && t2 <= ch.t2) {
                hd2 = ch.helicorder.subset(ch.t1, t2);
                hd.concatenate(hd2);
                ch.lastAccess = System.currentTimeMillis();
            }
            if (!(t1 >= ch.t1) || !(t1 < ch.t2) || !(t2 > ch.t2)) continue;
            hd2 = ch.helicorder.subset(t1, ch.t2);
            hd.concatenate(hd2);
            ch.lastAccess = System.currentTimeMillis();
        }
        hd.sort();
        if (hd.getData() == null) {
            hd = null;
        }
        return hd;
    }

    public synchronized HelicorderData getHelicorder(String station, double t1, double t2, SeismicDataSource source) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station);
        if (helis == null) {
            return null;
        }
        for (CachedHelicorder ch : helis) {
            if (t1 >= ch.t1 && t2 <= ch.t2) {
                HelicorderData hd = ch.helicorder.subset(t1, t2);
                ch.lastAccess = System.currentTimeMillis();
                return hd;
            }
            if (t1 < ch.t1 && t2 > ch.t2) {
                HelicorderData nhd = source.getHelicorder(station, t1, ch.t1, null);
                HelicorderData hd = nhd != null ? ch.helicorder.combine(nhd) : ch.helicorder;
                nhd = source.getHelicorder(station, ch.t2, t2, null);
                if (nhd != null) {
                    hd = hd.combine(nhd);
                }
                ch.lastAccess = System.currentTimeMillis();
                return hd;
            }
            if (t1 < ch.t1 && t2 > ch.t1 && t2 <= ch.t2) {
                HelicorderData nhd = source.getHelicorder(station, t1, ch.t1, null);
                if (nhd != null) {
                    HelicorderData hd = ch.helicorder.combine(nhd);
                    ch.lastAccess = System.currentTimeMillis();
                    return hd;
                }
                ch.lastAccess = System.currentTimeMillis();
                return ch.helicorder;
            }
            if (!(t1 > ch.t1) || !(t1 < ch.t2) || !(t2 > ch.t2)) continue;
            HelicorderData nhd = source.getHelicorder(station, ch.t2, t2, null);
            if (nhd != null) {
                HelicorderData hd = ch.helicorder.combine(nhd);
                ch.lastAccess = System.currentTimeMillis();
                return hd;
            }
            ch.lastAccess = System.currentTimeMillis();
            return ch.helicorder;
        }
        return null;
    }

    public synchronized void putWave(String station, Wave wave) {
        List<CachedWave> waves = this.waveCache.get(station);
        if (waves == null) {
            waves = new ArrayList<CachedWave>();
            this.waveCache.put(station, waves);
            this.putWaveInCache(station, wave, waves);
        } else {
            for (CachedWave cw : waves) {
                boolean join = false;
                if (cw.wave.adjacent(wave) && cw.wave.getMemorySize() + wave.getMemorySize() < 1000000) {
                    join = true;
                }
                if (cw.wave.overlaps(wave)) {
                    join = true;
                }
                if (!join) continue;
                Wave newWave = cw.wave.combine(wave);
                if (newWave != null) {
                    waves.remove(cw);
                    this.putWave(station, newWave);
                }
                return;
            }
            this.putWaveInCache(station, wave, waves);
        }
    }

    private synchronized void putWaveInCache(String channel, Wave wave, List<CachedWave> waves) {
        if (wave.getMemorySize() > 1000000) {
            Wave[] splitWaves = wave.split();
            this.putWaveInCache(channel, splitWaves[0], waves);
            this.putWaveInCache(channel, splitWaves[1], waves);
            return;
        }
        CachedWave cw = new CachedWave();
        cw.station = channel;
        cw.t1 = wave.getStartTime();
        cw.t2 = wave.getEndTime();
        cw.wave = wave;
        cw.lastAccess = System.currentTimeMillis();
        waves.add(cw);
        this.enforceSize();
    }

    public synchronized void putHelicorder(String station, HelicorderData helicorder) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station);
        if (helis == null) {
            helis = new ArrayList<CachedHelicorder>();
            CachedHelicorder ch = new CachedHelicorder();
            ch.station = station;
            ch.t1 = helicorder.getStartTime();
            ch.t2 = helicorder.getEndTime();
            ch.helicorder = helicorder;
            ch.lastAccess = System.currentTimeMillis();
            helis.add(ch);
            this.helicorderCache.put(station, helis);
            this.enforceSize();
        } else {
            int overlaps = 0;
            boolean add = true;
            int i = 0;
            while (i < helis.size()) {
                CachedHelicorder ch = helis.get(i);
                if (ch.helicorder.overlaps(helicorder) && helicorder != ch.helicorder) {
                    helis.remove(ch);
                    HelicorderData newHeli = ch.helicorder.combine(helicorder);
                    this.putHelicorder(station, newHeli);
                    ++overlaps;
                    helicorder = newHeli;
                    i = 0;
                    add = false;
                }
                ++i;
            }
            if (add) {
                CachedHelicorder ch = new CachedHelicorder();
                ch.station = station;
                ch.t1 = helicorder.getStartTime();
                ch.t2 = helicorder.getEndTime();
                ch.helicorder = helicorder;
                ch.lastAccess = System.currentTimeMillis();
                helis.add(ch);
                this.enforceSize();
            }
        }
    }

    public synchronized boolean inHelicorderCache(String station, double t1, double t2) {
        List<CachedHelicorder> helis = this.helicorderCache.get(station);
        if (helis == null) {
            return false;
        }
        for (CachedHelicorder ch : helis) {
            if (!(t1 >= ch.t1) || !(t2 <= ch.t2)) continue;
            return true;
        }
        return false;
    }

    public synchronized void cacheWaveAsHelicorder(String station, Wave wave) {
        double et;
        double st = Math.ceil(wave.getStartTime());
        if (this.inHelicorderCache(station, st, et = Math.floor(wave.getEndTime()))) {
            return;
        }
        int seconds = (int)(Math.floor(wave.getEndTime()) - Math.ceil(wave.getStartTime()));
        double bi = Math.floor((Math.ceil(wave.getStartTime()) - wave.getStartTime()) * wave.getSamplingRate());
        int bufIndex = (int)bi;
        int sr = (int)wave.getSamplingRate();
        DoubleMatrix2D data = DoubleFactory2D.dense.make(seconds, 3);
        int i = 0;
        while (i < seconds) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int j = 0;
            while (j < sr) {
                int sample = wave.buffer[bufIndex];
                if (sample != Wave.NO_DATA) {
                    min = Math.min(min, sample);
                    max = Math.max(max, sample);
                }
                ++bufIndex;
                ++j;
            }
            data.setQuick(i, 0, st);
            data.setQuick(i, 1, (double)min);
            data.setQuick(i, 2, (double)max);
            st += 1.0;
            ++i;
        }
        if (data.rows() > 0) {
            HelicorderData hd = new HelicorderData();
            hd.setData(data);
            this.putHelicorder(station, hd);
        }
    }

    private synchronized <T extends CacheEntry> long getSize(Map<String, List<T>> cache) {
        long size = 0L;
        for (String key : cache.keySet()) {
            List<T> cwl = cache.get(key);
            for (CacheEntry ce : cwl) {
                size += (long)ce.getMemorySize();
            }
        }
        return size;
    }

    public synchronized long getSize() {
        long size = this.getSize(this.waveCache);
        return size += this.getSize(this.helicorderCache);
    }

    public boolean isEmpty() {
        return this.helicorderCache.size() + this.waveCache.size() == 0;
    }

    public void flush() {
        this.flushWaves();
        this.flushHelicorders();
        System.gc();
    }

    public void flushHelicorders() {
        this.helicorderCache.clear();
        Swarm.logger.info("Helicorder Cache Flushed");
    }

    public void flushWaves() {
        this.waveCache.clear();
        Swarm.logger.info("Wave Cache Flushed");
    }

    private synchronized <T extends CacheEntry> List<CacheEntry> getEntriesByLastAccess(Map<String, List<T>> cache) {
        ArrayList<CacheEntry> cl = new ArrayList<CacheEntry>();
        for (String key : cache.keySet()) {
            List<T> cwl = cache.get(key);
            for (CacheEntry ce : cwl) {
                cl.add(ce);
            }
        }
        Collections.sort(cl);
        return cl;
    }

    private synchronized <T extends CacheEntry> void removeEntryFromCache(CacheEntry ce, Map<String, List<T>> cache) {
        List<T> cl = cache.get(ce.station);
        cl.remove(ce);
        Swarm.logger.info("Removed: " + ce.getInfoString());
    }

    public synchronized void enforceSize() {
        if (this.purgeActions == null) {
            return;
        }
        long target = this.getSize() - this.maxSize;
        int i = 0;
        while (target > 0L && i < this.purgeActions.length) {
            long chunk = this.purgeActions[i].purge();
            Swarm.logger.finer("purged " + chunk + " bytes from cache");
            target -= chunk;
            ++i;
        }
    }

    private <T extends CacheEntry> long outputCache(String type, Map<String, List<T>> cache) {
        long size = 0L;
        System.out.println(String.valueOf(type) + " cache");
        for (String key : cache.keySet()) {
            System.out.println("\t" + key);
            List<T> cwl = cache.get(key);
            for (CacheEntry ce : cwl) {
                size += (long)ce.getMemorySize();
                System.out.println("\t\t" + ce.getInfoString());
            }
        }
        System.out.println(String.valueOf(type) + " size: " + size + " bytes");
        return size;
    }

    public void output() {
        long size = this.outputCache("Wave", this.waveCache);
        size += this.outputCache("Helicorder", this.helicorderCache);
        System.out.println("Wave Last Access Order:");
        List<CacheEntry> wl = this.getEntriesByLastAccess(this.waveCache);
        for (CacheEntry ce : wl) {
            System.out.println(ce.getInfoString());
        }
        System.out.println("Helicorder Last Access Order:");
        List<CacheEntry> hl = this.getEntriesByLastAccess(this.helicorderCache);
        for (CacheEntry ce : hl) {
            System.out.println(ce.getInfoString());
        }
        System.out.println("Total size: " + size + " bytes");
    }

    public void createPurgeActions() {
        this.purgeActions = new CachePurgeAction[]{new TimeLimitWavePurgeAction(this.waveCache, 300000L), new TimeLimitHelicorderPurgeAction(this.helicorderCache, 300000L), new HalveLargeWavesPurgeAction(this.waveCache, 10800), new HalveLargeWavesPurgeAction(this.waveCache, 3600), new CompleteWavePurgeAction(this.waveCache), new CompleteHelicorderPurgeAction(this.helicorderCache)};
    }

    @Override
    public String toConfigString() {
        return "cache:";
    }

    private abstract class CacheEntry
    implements Comparable<CacheEntry> {
        public String station;
        public double t1;
        public double t2;
        public long lastAccess;

        private CacheEntry() {
        }

        @Override
        public int compareTo(CacheEntry oce) {
            return (int)(this.lastAccess - oce.lastAccess);
        }

        public abstract String getInfoString();

        public abstract int getMemorySize();
    }

    private abstract class CachePurgeAction {
        public abstract long purge();
    }

    private class CachedHelicorder
    extends CacheEntry {
        public HelicorderData helicorder;

        private CachedHelicorder() {
        }

        public String toString() {
            return String.valueOf(this.station) + " " + this.t1 + " " + this.t2;
        }

        @Override
        public String getInfoString() {
            long ms = System.currentTimeMillis() - this.lastAccess;
            return "[" + ms + "ms] " + (this.t2 - this.t1) + "s, " + this.helicorder.getMemorySize() + " bytes, " + this.t1 + " => " + this.t2;
        }

        @Override
        public int getMemorySize() {
            return this.helicorder.getMemorySize();
        }
    }

    private class CachedWave
    extends CacheEntry
    implements Comparable<CacheEntry> {
        public Wave wave;

        private CachedWave() {
        }

        @Override
        public String getInfoString() {
            long ms = System.currentTimeMillis() - this.lastAccess;
            return "[" + ms + "ms] " + (this.t2 - this.t1) + "s, " + this.wave.getMemorySize() + " bytes, " + this.t1 + " => " + this.t2;
        }

        @Override
        public int getMemorySize() {
            return this.wave.getMemorySize();
        }
    }

    private class CompleteHelicorderPurgeAction
    extends CachePurgeAction {
        private Map<String, List<CachedHelicorder>> cache;

        public CompleteHelicorderPurgeAction(Map<String, List<CachedHelicorder>> c) {
            this.cache = c;
        }

        @Override
        public long purge() {
            long size = CachedDataSource.this.getSize(this.cache);
            this.cache.clear();
            return size;
        }
    }

    private class CompleteWavePurgeAction
    extends CachePurgeAction {
        private Map<String, List<CachedWave>> cache;

        public CompleteWavePurgeAction(Map<String, List<CachedWave>> c) {
            this.cache = c;
        }

        @Override
        public long purge() {
            long size = CachedDataSource.this.getSize(this.cache);
            this.cache.clear();
            return size;
        }
    }

    private class HalveLargeWavesPurgeAction
    extends CachePurgeAction {
        private int maxTime;
        private Map<String, List<CachedWave>> cache;

        public HalveLargeWavesPurgeAction(Map<String, List<CachedWave>> c, int m) {
            this.cache = c;
            this.maxTime = m;
        }

        @Override
        public long purge() {
            List items = CachedDataSource.this.getEntriesByLastAccess(this.cache);
            long chunk = 0L;
            for (CacheEntry ce : items) {
                CachedWave cw = (CachedWave)ce;
                if (!(cw.wave.getEndTime() - cw.wave.getStartTime() > (double)this.maxTime)) continue;
                long before = cw.getMemorySize();
                double nst = cw.wave.getEndTime() - (cw.wave.getEndTime() - cw.wave.getStartTime()) / 2.0;
                cw.wave = cw.wave.subset(nst, cw.wave.getEndTime());
                cw.t1 = cw.wave.getStartTime();
                cw.t2 = cw.wave.getEndTime();
                chunk += (long)cw.getMemorySize() - before;
            }
            return chunk;
        }
    }

    private class TimeLimitHelicorderPurgeAction
    extends CachePurgeAction {
        private long interval;
        private Map<String, List<CachedHelicorder>> cache;

        public TimeLimitHelicorderPurgeAction(Map<String, List<CachedHelicorder>> c, long i) {
            this.cache = c;
            this.interval = i;
        }

        @Override
        public long purge() {
            List items = CachedDataSource.this.getEntriesByLastAccess(this.cache);
            long chunk = 0L;
            long now = System.currentTimeMillis();
            for (CacheEntry ce : items) {
                if (now - ce.lastAccess <= this.interval) continue;
                CachedDataSource.this.removeEntryFromCache(ce, this.cache);
                chunk += (long)ce.getMemorySize();
            }
            return chunk;
        }
    }

    private class TimeLimitWavePurgeAction
    extends CachePurgeAction {
        private long interval;
        private Map<String, List<CachedWave>> cache;

        public TimeLimitWavePurgeAction(Map<String, List<CachedWave>> c, long i) {
            this.cache = c;
            this.interval = i;
        }

        @Override
        public long purge() {
            List items = CachedDataSource.this.getEntriesByLastAccess(this.cache);
            long chunk = 0L;
            long now = System.currentTimeMillis();
            for (CacheEntry ce : items) {
                if (now - ce.lastAccess <= this.interval) continue;
                CachedDataSource.this.removeEntryFromCache(ce, this.cache);
                chunk += (long)ce.getMemorySize();
            }
            return chunk;
        }
    }
}

