/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDCOperations;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.GulperList;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.CurrentTime;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.Wave;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.omg.CORBA_2_3.ORB;

public class DHIDataSource
extends SeismicDataSource {
    protected static final String NAMING_SERVICE_URL = "corbaloc:iiop:dmc.iris.washington.edu:6371/NameService";
    protected String network;
    protected String networkDC;
    protected String networkDNS;
    protected String seismoDC;
    protected String seismoDNS;
    protected int gulpSize = 1800;
    protected int gulpDelay = 1000;
    protected Map<String, ChannelId> idMap;
    protected FissuresNamingService namingService;
    protected NetworkDCOperations netDC;
    protected DataCenter seisDC;
    protected ORB orb;
    protected static Logger logger;

    public DHIDataSource() {
    }

    public DHIDataSource(String nw) {
        String[] ss = nw.split(":");
        this.networkDNS = ss[0];
        this.networkDC = ss[1];
        this.seismoDNS = ss[2];
        this.seismoDC = ss[3];
        this.network = ss[4];
        this.gulpSize = Integer.parseInt(ss[5]);
        this.gulpDelay = Integer.parseInt(ss[6]);
        BasicConfigurator.configure();
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
    }

    @Override
    public SeismicDataSource getCopy() {
        Swarm.logger.info("DHI Copy");
        DHIDataSource ds = new DHIDataSource();
        ds.network = this.network;
        ds.networkDNS = this.networkDNS;
        ds.networkDC = this.networkDC;
        ds.name = this.name;
        ds.seismoDC = this.seismoDC;
        ds.seismoDNS = this.seismoDNS;
        ds.gulpSize = this.gulpSize;
        ds.gulpDelay = this.gulpDelay;
        ds.storeInUserConfig = this.storeInUserConfig;
        ds.useCache = true;
        ds.orb = this.orb;
        ds.namingService = this.namingService;
        ds.netDC = this.netDC;
        ds.seisDC = this.seisDC;
        ds.idMap = this.idMap;
        return ds;
    }

    @Override
    public void establish() {
        if (this.orb == null) {
            Properties prop = new Properties();
            prop.setProperty("com.sun.CORBA.transport.ORBTCPReadTimeouts", "100:60000:180000:20");
            this.orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], (Properties)prop);
        }
        try {
            new AllVTFactory().register(this.orb);
            this.namingService = new FissuresNamingService(this.orb);
            this.namingService.setNameServiceCorbaLoc(NAMING_SERVICE_URL);
            this.netDC = this.namingService.getNetworkDC(this.networkDNS, this.networkDC);
            this.seisDC = this.namingService.getSeismogramDC(this.seismoDNS, this.seismoDC);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getChannels() {
        this.fireChannelsProgress("channels", 0.0);
        this.idMap = new HashMap<String, ChannelId>();
        ArrayList<String> result = new ArrayList<String>();
        double now = CurrentTime.getInstance().nowJ2K();
        try {
            NetworkFinder netFinder = this.netDC.a_finder();
            NetworkAccess net = netFinder.retrieve_by_code(this.network)[0];
            Station[] stations = net.retrieve_stations();
            int ns = stations.length;
            int cnt = 0;
            Station[] stationArray = stations;
            int n = stations.length;
            int n2 = 0;
            while (n2 < n) {
                Station s = stationArray[n2];
                double p = (double)cnt / (double)ns;
                this.fireChannelsProgress("channels", p);
                ++cnt;
                String t = s.effective_time.end_time.date_time.replaceAll("[-:]", "");
                double j2k = gov.usgs.util.Time.parse("yyyyMMdd'T'HHmmss.SSSS'Z'", t);
                if (j2k >= now - 3600.0) {
                    Channel[] channels;
                    Channel[] channelArray = channels = net.retrieve_for_station(s.get_id());
                    int n3 = channels.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Channel c = channelArray[n4];
                        String ch = String.valueOf(s.get_code()) + " " + c.get_code() + " " + this.network;
                        if (c.sampling_info != null) {
                            double sr = (double)c.sampling_info.numPoints / c.sampling_info.interval.value;
                            t = s.effective_time.end_time.date_time.replaceAll("[-:]", "");
                            j2k = gov.usgs.util.Time.parse("yyyyMMdd'T'HHmmss.SSSS'Z'", t);
                            if (j2k >= now - 3600.0 && sr > 1.0) {
                                String loc = c.get_id().site_code;
                                loc = loc == null || loc.length() <= 0 || loc.equals("  ") ? "" : " " + loc;
                                ch = String.valueOf(s.get_code()) + " " + c.get_code() + " " + this.network + loc;
                                Metadata md = Swarm.config.getMetadata(ch, true);
                                md.updateLongitude(s.my_location.longitude);
                                md.updateLatitude(s.my_location.latitude);
                                md.addGroup(s.name);
                                md.updateAlias(s.name);
                                md.source = this;
                                if (!result.contains(ch)) {
                                    result.add(ch);
                                }
                                this.idMap.put(ch, c.get_id());
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            Collections.sort(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        this.fireChannelsProgress("channels", 1.0);
        return result;
    }

    @Override
    public HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        double now = CurrentTime.getInstance().nowJ2K();
        CachedDataSource cache = Swarm.getCache();
        HelicorderData hd = cache.getHelicorder(station, t1, t2, (GulperListener)null);
        if (hd == null || hd.rows() == 0 || hd.getStartTime() - t1 > 10.0) {
            GulperList.getInstance().requestGulper("dhi:" + station, gl, this, station, t1, t2, this.gulpSize, this.gulpDelay);
        }
        if (hd != null && hd.getEndTime() < now) {
            this.getWave(station, hd.getEndTime(), now);
        }
        return hd;
    }

    @Override
    public Wave getWave(String station, double t1, double t2) {
        CachedDataSource cache = Swarm.getCache();
        Wave wave = null;
        if (this.useCache) {
            wave = cache.getWave(station, t1, t2);
        }
        if (wave == null) {
            try {
                RequestFilter[] seismogramRequest = new RequestFilter[1];
                String st1 = gov.usgs.util.Time.format("yyyyMMdd'T'HHmmss.SSSS'Z'", t1);
                String st2 = gov.usgs.util.Time.format("yyyyMMdd'T'HHmmss.SSSS'Z'", t2);
                Time start = new Time(st1, -1);
                Time end = new Time(st2, -1);
                ChannelId cid = this.idMap.get(station);
                seismogramRequest[0] = new RequestFilter(cid, start, end);
                LocalSeismogram[] seis = this.seisDC.retrieve_seismograms(seismogramRequest);
                ArrayList<Wave> waves = new ArrayList<Wave>();
                if (seis.length > 0) {
                    int i = 0;
                    while (i < seis.length) {
                        Swarm.logger.finer("seis[" + i + "] has " + seis[i].num_points + " points and starts at " + seis[i].begin_time.date_time + " " + (double)seis[i].sampling_info.numPoints / seis[i].sampling_info.interval.value * 1000.0);
                        wave = new Wave();
                        wave.buffer = seis[i].get_as_longs();
                        String t = seis[i].begin_time.date_time.replace('T', ' ');
                        t = t.substring(0, t.length() - 1);
                        double j2k = gov.usgs.util.Time.parse("yyyy-MM-dd HH:mm:ss.SSS", t);
                        wave.setStartTime(j2k);
                        wave.setSamplingRate((double)seis[i].sampling_info.numPoints / seis[i].sampling_info.interval.value * 1000.0);
                        wave.register();
                        waves.add(wave);
                        ++i;
                    }
                }
                if ((wave = Wave.join(waves)) != null && this.useCache) {
                    cache.cacheWaveAsHelicorder(station, wave);
                    cache.putWave(station, wave);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return wave;
    }

    @Override
    public synchronized void notifyDataNotNeeded(String station, double t1, double t2, GulperListener gl) {
        GulperList.getInstance().killGulper("dhi:" + station, gl);
    }

    @Override
    public synchronized boolean isActiveSource() {
        return true;
    }

    @Override
    public String toConfigString() {
        return String.format("%s;dhi:%s:%s:%s:%s:%s:%d:%d", this.name, this.networkDNS, this.networkDC, this.seismoDNS, this.seismoDC, this.network, this.gulpSize, this.gulpDelay);
    }
}

