/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.builder.SeedObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.director.SeedImportDirector;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmDialog;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.SAC;
import gov.usgs.vdx.data.wave.Wave;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FileDataSource
extends CachedDataSource {
    private Map<String, double[]> channelTimes = new HashMap<String, double[]>();
    private Set<String> openFiles = new HashSet<String>();

    public FileDataSource() {
        this.maxSize = Integer.MAX_VALUE;
        this.storeInUserConfig = false;
        this.name = "Files";
    }

    @Override
    public void flush() {
        List<String> channels = this.getChannels();
        if (channels != null) {
            for (String ch : channels) {
                Swarm.config.removeMetadata(ch);
            }
        }
        super.flush();
        this.openFiles.clear();
        this.channelTimes.clear();
        this.fireChannelsUpdated();
    }

    private void updateChannelTimes(String channel, double t1, double t2) {
        double[] ct = this.channelTimes.get(channel);
        if (ct == null) {
            ct = new double[]{t1, t2};
            this.channelTimes.put(channel, ct);
        }
        ct[0] = Math.min(ct[0], t1);
        ct[1] = Math.max(ct[1], t2);
    }

    public void openFiles(File[] fs) {
        FileTypeDialog dialog = null;
        int i = 0;
        while (i < fs.length) {
            FileType ft = FileType.fromFile(fs[i]);
            if (ft == FileType.UNKNOWN) {
                if (dialog == null) {
                    dialog = new FileTypeDialog();
                }
                if (!dialog.opened || dialog.opened && !dialog.isAssumeSame()) {
                    dialog.setFilename(fs[i].getName());
                    dialog.setVisible(true);
                }
                ft = dialog.cancelled ? FileType.UNKNOWN : dialog.getFileType();
                Swarm.logger.info("user input file type: " + fs[i].getPath() + " -> " + (Object)((Object)ft));
            }
            switch (ft) {
                case SAC: {
                    this.openSACFile(fs[i].getPath());
                    break;
                }
                case SEED: {
                    this.openSeedFile(fs[i].getPath());
                    break;
                }
                case UNKNOWN: {
                    Swarm.logger.warning("unknown file type: " + fs[i].getPath());
                }
            }
            Swarm.config.lastPath = fs[i].getParent();
            ++i;
        }
    }

    public void openSACFile(final String fn) {
        if (this.openFiles.contains(fn)) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Throwable result = null;
                FileDataSource.this.fireChannelsProgress(fn, 0.0);
                try {
                    Swarm.logger.fine("opening SAC file: " + fn);
                    SAC sac = new SAC();
                    sac.read(fn);
                    FileDataSource.this.fireChannelsProgress(fn, 0.5);
                    String channel = sac.getStationInfo();
                    Metadata md = Swarm.config.getMetadata(channel, true);
                    md.addGroup("SAC^" + fn);
                    Wave wave = sac.toWave();
                    FileDataSource.this.updateChannelTimes(channel, wave.getStartTime(), wave.getEndTime());
                    FileDataSource.this.cacheWaveAsHelicorder(channel, wave);
                    FileDataSource.this.putWave(channel, wave);
                    FileDataSource.this.openFiles.add(fn);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    result = t;
                }
                FileDataSource.this.fireChannelsProgress(fn, 1.0);
                FileDataSource.this.fireChannelsUpdated();
                return result;
            }

            @Override
            public void finished() {
                if (this.getValue() != null) {
                    JOptionPane.showMessageDialog(Swarm.getApplication(), "Could not open SAC file: " + fn, "Error", 0);
                }
            }
        };
        worker.start();
    }

    public void openSeedFile(final String fn) {
        if (this.openFiles.contains(fn)) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Throwable result = null;
                try {
                    Object object;
                    FileDataSource.this.fireChannelsProgress(fn, 0.0);
                    CodeTimer ct = new CodeTimer("seed");
                    Swarm.logger.fine("opening SEED file: " + fn);
                    HashMap tempStationMap = new HashMap();
                    DataInputStream ls = new DataInputStream(new BufferedInputStream(new FileInputStream(fn)));
                    ct.mark("dis");
                    SeedImportDirector importDirector = new SeedImportDirector();
                    SeedObjectBuilder objectBuilder = new SeedObjectBuilder();
                    importDirector.assignBuilder((ObjectBuilder)objectBuilder);
                    importDirector.construct((InputStream)ls);
                    SeedObjectContainer container = (SeedObjectContainer)importDirector.getBuilder().getContainer();
                    ct.mark("prep");
                    int total = container.iterate();
                    ct.mark("iterate: " + total);
                    int cnt = 0;
                    while ((object = container.getNext()) != null) {
                        FileDataSource.this.fireChannelsProgress(fn, 0.5 + 0.5 * ((double)cnt / (double)total));
                        ++cnt;
                        Blockette b = (Blockette)object;
                        if (b.getType() != 999) continue;
                        String loc = ("_" + b.getFieldVal(5)).trim();
                        if (loc.length() == 1) {
                            loc = "";
                        }
                        String code = b.getFieldVal(4) + "_" + b.getFieldVal(6) + "_" + b.getFieldVal(7) + loc;
                        Metadata md = Swarm.config.getMetadata(code, true);
                        md.addGroup("SEED^" + fn);
                        ArrayList<Wave> parts = (ArrayList<Wave>)tempStationMap.get(code);
                        if (parts == null) {
                            parts = new ArrayList<Wave>();
                            tempStationMap.put(code, parts);
                        }
                        if (b.getWaveform() == null) continue;
                        Waveform wf = b.getWaveform();
                        Wave sw = new Wave();
                        sw.setSamplingRate(FileDataSource.this.getSampleRate(((Integer)b.getFieldVal(10)).intValue(), ((Integer)b.getFieldVal(11)).intValue()));
                        Btime bTime = (Btime)b.getFieldVal(8);
                        sw.setStartTime(Util.dateToJ2K(FileDataSource.this.btimeToDate(bTime)));
                        sw.buffer = wf.getDecodedIntegers();
                        sw.register();
                        parts.add(sw);
                    }
                    ct.mark("read: " + cnt);
                    for (String code : tempStationMap.keySet()) {
                        List parts = (List)tempStationMap.get(code);
                        ArrayList<Wave> subParts = new ArrayList<Wave>();
                        int ns = 0;
                        int sp = 0;
                        int i = 0;
                        while (i < parts.size()) {
                            subParts.add((Wave)parts.get(i));
                            if ((ns += ((Wave)parts.get(i)).samples()) > 360000 || i == parts.size() - 1) {
                                ++sp;
                                Wave wave = Wave.join(subParts);
                                FileDataSource.this.updateChannelTimes(code, wave.getStartTime(), wave.getEndTime());
                                FileDataSource.this.cacheWaveAsHelicorder(code, wave);
                                FileDataSource.this.putWave(code, wave);
                                ns = 0;
                                subParts.clear();
                            }
                            ++i;
                        }
                    }
                    ct.mark("insert");
                    ct.stop();
                    FileDataSource.this.openFiles.add(fn);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    result = t;
                }
                FileDataSource.this.fireChannelsProgress(fn, 1.0);
                FileDataSource.this.fireChannelsUpdated();
                return result;
            }

            @Override
            public void finished() {
                if (this.getValue() != null) {
                    JOptionPane.showMessageDialog(Swarm.getApplication(), "Could not open SEED file: " + fn, "Error", 0);
                }
            }
        };
        worker.start();
    }

    private Date btimeToDate(Btime bt) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, bt.getYear());
        cal.set(6, bt.getDayOfYear());
        cal.set(11, bt.getHour());
        cal.set(12, bt.getMinute());
        cal.set(13, bt.getSecond());
        cal.set(14, bt.getTenthMill() / 10);
        return cal.getTime();
    }

    private float getSampleRate(double factor, double multiplier) {
        float sampleRate = 10000.0f;
        if (factor * multiplier != 0.0) {
            sampleRate = (float)(Math.pow(Math.abs(factor), factor / Math.abs(factor)) * Math.pow(Math.abs(multiplier), multiplier / Math.abs(multiplier)));
        }
        return sampleRate;
    }

    @Override
    public HelicorderData getHelicorder(String channel, double t1, double t2, GulperListener gl) {
        double[] ct = this.channelTimes.get(channel);
        if (ct == null) {
            return null;
        }
        double dt = t2 - t1;
        double now = CurrentTime.getInstance().nowJ2K();
        if (Math.abs(now - t2) < 3600.0) {
            t2 = ct[1];
            t1 = t2 - dt;
        }
        return super.getHelicorder(channel, t1, t2, gl);
    }

    @Override
    public Wave getWave(String station, double t1, double t2) {
        return super.getBestWave(station, t1, t2);
    }

    @Override
    public String toConfigString() {
        return String.valueOf(this.name) + ";file:";
    }

    private static enum FileType {
        TEXT,
        SAC,
        SEED,
        UNKNOWN;


        public static FileType fromFile(File f) {
            String fn = f.getPath().toLowerCase();
            if (fn.endsWith(".sac")) {
                return SAC;
            }
            if (fn.endsWith(".txt")) {
                return TEXT;
            }
            if (fn.endsWith(".seed")) {
                return SEED;
            }
            return UNKNOWN;
        }
    }

    private class FileTypeDialog
    extends SwarmDialog {
        private static final long serialVersionUID = 1L;
        private JLabel filename;
        private JList fileTypes;
        private JCheckBox assumeSame;
        private boolean cancelled;
        private boolean opened;

        protected FileTypeDialog() {
            super(Swarm.getApplication(), "Unknown File Type", true);
            this.cancelled = true;
            this.opened = false;
            this.setSizeAndLocation();
        }

        public void setFilename(String fn) {
            this.filename.setText(fn);
        }

        @Override
        protected void createUI() {
            super.createUI();
            this.filename = new JLabel();
            this.filename.setFont(Font.decode("dialog-BOLD-12"));
            this.filename.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            String[] types = new String[]{"SEED/miniSEED volume", "SAC"};
            this.fileTypes = new JList<String>(types);
            this.fileTypes.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && FileTypeDialog.this.fileTypes.getSelectedIndex() != -1) {
                        FileTypeDialog.this.okButton.doClick();
                    }
                }
            });
            this.fileTypes.setSelectedIndex(0);
            this.assumeSame = new JCheckBox("Assume all unknown files are of this type", false);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 9, 5, 9));
            panel.setPreferredSize(new Dimension(300, 200));
            JPanel labelPanel = new JPanel(new GridLayout(3, 1));
            labelPanel.add(new JLabel("Unknown file type for file: "));
            labelPanel.add(this.filename);
            labelPanel.add(new JLabel("Choose 'Cancel' to skip this file or select file type:"));
            panel.add((Component)labelPanel, "North");
            panel.add((Component)new JScrollPane(this.fileTypes), "Center");
            panel.add((Component)this.assumeSame, "South");
            this.mainPanel.add((Component)panel, "Center");
        }

        public boolean isAssumeSame() {
            return this.assumeSame.isSelected();
        }

        public FileType getFileType() {
            switch (this.fileTypes.getSelectedIndex()) {
                case 0: {
                    return FileType.SEED;
                }
                case 1: {
                    return FileType.SAC;
                }
            }
            return null;
        }

        @Override
        public void wasOK() {
            this.cancelled = false;
        }

        @Override
        public void wasCancelled() {
            this.cancelled = true;
            this.opened = false;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this.opened = true;
            }
            super.setVisible(b);
        }
    }
}

