/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.WaveServer;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.GulperList;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.Wave;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class WaveServerSource
extends SeismicDataSource {
    private String params;
    private WaveServer waveServer;
    private int timeout = 2000;
    private String server;
    private int port;
    private int gulpSize = 1800;
    private int gulpDelay = 1000;
    private TimeZone timeZone;
    private static Map<String, Boolean> scnlSources = new HashMap<String, Boolean>();

    public WaveServerSource(String s) {
        this.params = s;
        String[] ss = this.params.split(":");
        this.server = ss[0];
        this.port = Integer.parseInt(ss[1]);
        this.timeout = Integer.parseInt(ss[2]);
        this.gulpSize = Integer.parseInt(ss[3]);
        this.gulpDelay = Integer.parseInt(ss[4]);
        this.timeZone = ss.length >= 6 ? TimeZone.getTimeZone(ss[5]) : TimeZone.getTimeZone("UTC");
        this.waveServer = new WaveServer(this.server, this.port);
        this.setTimeout(this.timeout);
    }

    public WaveServerSource(WaveServerSource wss) {
        this(wss.params);
        this.name = wss.name;
    }

    @Override
    public SeismicDataSource getCopy() {
        return new WaveServerSource(this);
    }

    @Override
    public String toConfigString() {
        return String.format("%s;ws:%s:%d:%d:%d:%d:%s", this.name, this.server, this.port, this.timeout, this.gulpSize, this.gulpDelay, this.timeZone.getID());
    }

    public boolean isSCNL(String p) {
        Boolean b = scnlSources.get(p);
        if (b == null) {
            this.getMenu();
            b = scnlSources.get(p);
            if (b == null) {
                return false;
            }
        }
        return b;
    }

    public static void setIsSCNL(String p, boolean b) {
        scnlSources.put(p, b);
    }

    public synchronized void setTimeout(int to) {
        this.waveServer.setTimeout(to);
    }

    @Override
    public synchronized void close() {
        if (this.waveServer != null) {
            this.waveServer.close();
        }
    }

    public synchronized Menu getMenu() {
        Menu menu = this.waveServer.getMenuSCNL();
        WaveServerSource.setIsSCNL(this.params, menu.isSCNL());
        return menu;
    }

    public String getFormattedSCNL(MenuItem mi) {
        String loc;
        String scnl = String.valueOf(mi.getStation()) + " " + mi.getChannel() + " " + mi.getNetwork();
        if (this.isSCNL(this.params) && (loc = mi.getLocation()) != null && !loc.equals("--")) {
            scnl = String.valueOf(scnl) + " " + loc;
        }
        return scnl;
    }

    public List<String> getMenuList(List<MenuItem> items) {
        ArrayList<String> list = new ArrayList<String>(items.size());
        for (MenuItem mi : items) {
            list.add(this.getFormattedSCNL(mi));
        }
        return list;
    }

    @Override
    public synchronized Wave getWave(String station, double t1, double t2) {
        CachedDataSource cache = Swarm.getCache();
        Wave sw = null;
        if (this.useCache) {
            sw = cache.getWave(station, t1, t2);
        }
        if (sw == null) {
            double at2;
            String[] ss = station.split(" ");
            String loc = null;
            if (this.isSCNL(this.params)) {
                loc = "--";
                if (ss.length == 4) {
                    loc = ss[3];
                }
            }
            double offset = this.timeZone.getOffset(Util.j2KToDate(t1).getTime());
            double at1 = Util.j2KToEW(t1) + offset / 1000.0;
            sw = this.waveServer.getRawData(ss[0], ss[1], ss[2], loc, at1, at2 = Util.j2KToEW(t2) + offset / 1000.0);
            if (sw == null) {
                return null;
            }
            sw.convertToJ2K();
            sw.setStartTime(sw.getStartTime() - offset / 1000.0);
            sw.register();
            if (this.useCache) {
                cache.cacheWaveAsHelicorder(station, sw);
                cache.putWave(station, sw);
            }
        }
        return sw;
    }

    @Override
    public synchronized List<String> getChannels() {
        Menu menu = this.getMenu();
        List<String> channels = this.getMenuList(menu.getSortedItems());
        Swarm.config.assignMetadataSource(channels, this);
        return channels;
    }

    @Override
    public synchronized HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        CachedDataSource cache;
        HelicorderData hd;
        double now = CurrentTime.getInstance().nowJ2K();
        if (t2 - now >= -20.0) {
            this.getWave(station, now - 120.0, now);
        }
        if ((hd = (cache = Swarm.getCache()).getHelicorder(station, t1, t2, (GulperListener)null)) == null || hd.rows() == 0 || hd.getStartTime() - t1 > 10.0) {
            GulperList.getInstance().requestGulper("ws:" + station, gl, this.getCopy(), station, t1, t2, this.gulpSize, this.gulpDelay);
        }
        return hd;
    }

    @Override
    public synchronized void notifyDataNotNeeded(String station, double t1, double t2, GulperListener gl) {
        GulperList.getInstance().killGulper("ws:" + station, gl);
    }

    @Override
    public synchronized boolean isActiveSource() {
        return true;
    }
}

