/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.heli;

import gov.usgs.plot.Plot;
import gov.usgs.swarm.Images;
import gov.usgs.swarm.Kioskable;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmFrame;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.Throbber;
import gov.usgs.swarm.TimeListener;
import gov.usgs.swarm.WigglerPanel;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.data.SeismicDataSourceListener;
import gov.usgs.swarm.heli.HelicorderViewPanel;
import gov.usgs.swarm.heli.HelicorderViewerSettings;
import gov.usgs.swarm.heli.HelicorderViewerSettingsDialog;
import gov.usgs.swarm.wave.WaveViewSettings;
import gov.usgs.swarm.wave.WaveViewSettingsToolbar;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.GridBagHelper;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.heli.plot.HelicorderRenderer;
import gov.usgs.vdx.data.wave.Wave;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class HelicorderViewerFrame
extends SwarmFrame
implements Kioskable {
    public static final long serialVersionUID = -1L;
    public static final int[] chunkValues = new int[]{600, 900, 1200, 1800, 3600, 7200, 10800, 21600};
    public static final int[] spanValues = new int[]{120, 240, 360, 720, 1440, 2880, 4320, 5760, 7200, 8640, 10080, 11520, 12960, 14400, 15840, 17280, 18720, 20160, 21600, 23040, 24480, 25920, 27360, 28800, 30240, 31680, 33120, 34560, 36000, 37440, 38880, 40320, 41760, 43200, 44640, 46080, 47520, 48960, 50400, 51840, 53280, 54720, 56160, 57600, 59040, 76320, 77760, 79200, 80640, 82080, 83520, 84960, 86400};
    public static final int[] zoomValues = new int[]{1, 2, 5, 10, 20, 30, 60, 120, 300, 600};
    private RefreshThread refreshThread;
    private SeismicDataSource dataSource;
    private JPanel mainPanel;
    private JToolBar toolBar;
    private JToggleButton pinButton;
    private JButton settingsButton;
    private JButton backButton;
    private JButton forwardButton;
    private JButton compX;
    private JButton expX;
    private JButton compY;
    private JButton expY;
    private JButton clipboard;
    private JButton removeWave;
    private JButton capture;
    private JFileChooser chooser;
    private JButton scaleButton;
    private boolean scaleClipState;
    protected JToggleButton autoScaleSliderButton;
    protected int autoScaleSliderButtonState;
    protected JSlider autoScaleSlider;
    private HelicorderViewPanel helicorderViewPanel;
    private WaveViewSettings waveViewSettings;
    private HelicorderViewerSettings settings;
    private boolean gulperWorking;
    private boolean working;
    private JLabel statusLabel;
    private JPanel heliPanel;
    private WigglerPanel wigglerPanel;
    protected long lastRefreshTime;
    private Border border;
    private Border thinBorder;
    protected Throbber throbber;
    protected JProgressBar progressBar;
    private boolean noData = false;
    private TimeListener timeListener;
    public GulperListener gulperListener;
    private SeismicDataSourceListener dataListener;

    public HelicorderViewerFrame(ConfigFile cf) {
        super("<layout>", true, true, true, true);
        Swarm.getApplication().touchUITime();
        String channel = cf.getString("channel");
        SeismicDataSource sds = Swarm.config.getSource(cf.getString("source"));
        this.dataSource = sds.getCopy();
        this.setTitle(String.valueOf(channel) + ", [" + this.dataSource + "]");
        this.settings = new HelicorderViewerSettings(channel);
        this.settings.set(cf);
        this.waveViewSettings = new WaveViewSettings();
        this.waveViewSettings.set(cf.getSubConfig("wave"));
        this.createUI();
        boolean pinned = Boolean.parseBoolean(cf.getString("pinned"));
        this.setPinned(pinned);
        this.processStandardLayout(cf);
        this.setVisible(true);
        this.getHelicorder();
        this.refreshThread = new RefreshThread();
    }

    public HelicorderViewerFrame(SeismicDataSource sds, String ch, double bt) {
        super(String.valueOf(ch) + ", [" + sds + "]", true, true, true, true);
        Swarm.getApplication().touchUITime();
        this.settings = new HelicorderViewerSettings(ch);
        this.settings.setBottomTime(bt);
        this.waveViewSettings = new WaveViewSettings();
        this.dataSource = sds.getCopy();
        this.createUI();
        this.setVisible(true);
        this.getHelicorder();
        this.refreshThread = new RefreshThread();
    }

    @Override
    public void saveLayout(ConfigFile cf, String prefix) {
        super.saveLayout(cf, prefix);
        cf.put("helicorder", prefix);
        cf.put(String.valueOf(prefix) + ".source", this.dataSource.getName());
        cf.put(String.valueOf(prefix) + ".pinned", Boolean.toString(this.pinButton.isSelected()));
        this.settings.save(cf, prefix);
        this.waveViewSettings.save(cf, String.valueOf(prefix) + ".wave");
    }

    public void createUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.createHeliPanel();
        this.createToolBar();
        this.createStatusLabel();
        this.createListeners();
        this.setFrameIcon(Images.getIcon("heli"));
        this.setDefaultCloseOperation(2);
        this.setSize(800, 750);
        this.setContentPane(this.mainPanel);
    }

    public void addLinkListeners() {
        this.helicorderViewPanel.addListener(Swarm.getApplication().getWaveClipboard().getLinkListener());
        this.helicorderViewPanel.addListener(Swarm.getApplication().getMapFrame().getLinkListener());
    }

    private void createStatusLabel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 5, 0, 0));
        statusPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 3));
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createHorizontalGlue());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(100, 15));
        this.progressBar.setSize(new Dimension(100, 15));
        this.progressBar.setMaximumSize(new Dimension(100, 15));
        statusPanel.add(this.progressBar);
        this.mainPanel.add((Component)statusPanel, "South");
    }

    private void createHeliPanel() {
        this.settings.view = this.helicorderViewPanel = new HelicorderViewPanel(this);
        this.heliPanel = new JPanel(new BorderLayout());
        this.thinBorder = LineBorder.createGrayLineBorder();
        this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 3), this.thinBorder);
        this.heliPanel.setBorder(this.border);
        this.heliPanel.add((Component)this.helicorderViewPanel, "Center");
        this.mainPanel.add((Component)this.heliPanel, "Center");
    }

    private void createToolBar() {
        this.toolBar = SwarmUtil.createToolBar();
        this.pinButton = SwarmUtil.createToolBarToggleButton(Images.getIcon("pin"), "Helicorder always on top", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.setPinned(HelicorderViewerFrame.this.pinButton.isSelected());
            }
        });
        this.toolBar.add(this.pinButton);
        this.settingsButton = SwarmUtil.createToolBarButton(Images.getIcon("settings"), "Helicorder view settings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerSettingsDialog hvsd = HelicorderViewerSettingsDialog.getInstance(HelicorderViewerFrame.this.settings, HelicorderViewerFrame.this.waveViewSettings);
                hvsd.setVisible(true);
                HelicorderViewerFrame.this.noData = false;
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        this.toolBar.add(this.settingsButton);
        this.toolBar.addSeparator();
        this.backButton = SwarmUtil.createToolBarButton(Images.getIcon("left"), "Scroll back time (A or Left arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HelicorderViewerFrame.this.helicorderViewPanel.hasInset()) {
                    HelicorderViewerFrame.this.helicorderViewPanel.moveInset(-1);
                } else {
                    HelicorderViewerFrame.this.scroll(-1);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "LEFT", "backward1", this.backButton);
        Util.mapKeyStrokeToButton(this, "A", "backward2", this.backButton);
        this.toolBar.add(this.backButton);
        this.forwardButton = SwarmUtil.createToolBarButton(Images.getIcon("right"), "Scroll forward time (Z or Right arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HelicorderViewerFrame.this.helicorderViewPanel.hasInset()) {
                    HelicorderViewerFrame.this.helicorderViewPanel.moveInset(1);
                } else {
                    HelicorderViewerFrame.this.scroll(1);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "RIGHT", "forward1", this.forwardButton);
        Util.mapKeyStrokeToButton(this, "Z", "forward2", this.forwardButton);
        this.toolBar.add(this.forwardButton);
        this.compX = SwarmUtil.createToolBarButton(Images.getIcon("xminus"), "Compress X-axis (Alt-left arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.decXAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt LEFT", "compx", this.compX);
        this.toolBar.add(this.compX);
        this.expX = SwarmUtil.createToolBarButton(Images.getIcon("xplus"), "Expand X-axis (Alt-right arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.incXAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt RIGHT", "expx", this.expX);
        this.toolBar.add(this.expX);
        this.compY = SwarmUtil.createToolBarButton(Images.getIcon("yminus"), "Compress Y-axis (Alt-down arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.decYAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt DOWN", "compy", this.compY);
        this.toolBar.add(this.compY);
        this.expY = SwarmUtil.createToolBarButton(Images.getIcon("yplus"), "Expand Y-axis (Alt-up arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.incYAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt UP", "expy", this.expY);
        this.toolBar.add(this.expY);
        this.toolBar.addSeparator();
        JButton addZoom = SwarmUtil.createToolBarButton(Images.getIcon("zoomplus"), "Decrease zoom time window (+)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.decZoom();
                HelicorderViewerFrame.this.settings.notifyView();
            }
        });
        Util.mapKeyStrokeToButton(this, "EQUALS", "addzoom1", addZoom);
        Util.mapKeyStrokeToButton(this, "shift EQUALS", "addzoom2", addZoom);
        this.toolBar.add(addZoom);
        JButton subZoom = SwarmUtil.createToolBarButton(Images.getIcon("zoomminus"), "Increase zoom time window (-)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.incZoom();
                HelicorderViewerFrame.this.settings.notifyView();
            }
        });
        Util.mapKeyStrokeToButton(this, "MINUS", "subzoom", subZoom);
        this.toolBar.add(subZoom);
        new WaveViewSettingsToolbar(this.waveViewSettings, this.toolBar, this);
        this.clipboard = SwarmUtil.createToolBarButton(Images.getIcon("clipboard"), "Copy inset to clipboard (C or Ctrl-C)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.helicorderViewPanel.insetToClipboard();
            }
        });
        this.clipboard.setEnabled(false);
        Util.mapKeyStrokeToButton(this, "control C", "clipboard1", this.clipboard);
        Util.mapKeyStrokeToButton(this, "C", "clipboard2", this.clipboard);
        this.toolBar.add(this.clipboard);
        this.removeWave = SwarmUtil.createToolBarButton(Images.getIcon("delete"), "Remove inset wave (Delete or Escape)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.helicorderViewPanel.removeWaveInset();
            }
        });
        this.removeWave.setEnabled(false);
        Util.mapKeyStrokeToButton(this, "ESCAPE", "removewave", this.removeWave);
        Util.mapKeyStrokeToButton(this, "DELETE", "removewave", this.removeWave);
        this.toolBar.add(this.removeWave);
        this.toolBar.addSeparator();
        this.capture = SwarmUtil.createToolBarButton(Images.getIcon("camera"), "Save helicorder image (P)", new CaptureActionListener());
        Util.mapKeyStrokeToButton(this, "P", "capture", this.capture);
        this.toolBar.add(this.capture);
        this.toolBar.addSeparator();
        this.scaleButton = SwarmUtil.createToolBarButton(Images.getIcon("wavezoom"), "Toggle between adjusting helicoder scale and clip", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.scaleClipState = !HelicorderViewerFrame.this.scaleClipState;
                if (HelicorderViewerFrame.this.scaleClipState) {
                    HelicorderViewerFrame.this.autoScaleSlider.setValue(40 - new Double(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barMult * 4.0).intValue());
                    HelicorderViewerFrame.this.scaleButton.setIcon(Images.getIcon("waveclip"));
                    HelicorderViewerFrame.this.autoScaleSlider.setToolTipText("Adjust helicorder clip");
                } else {
                    HelicorderViewerFrame.this.autoScaleSlider.setValue(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipBars / 3);
                    HelicorderViewerFrame.this.scaleButton.setIcon(Images.getIcon("wavezoom"));
                    HelicorderViewerFrame.this.autoScaleSlider.setToolTipText("Adjust helicorder scale");
                }
                HelicorderViewerFrame.this.settings.notifyView();
            }
        });
        this.scaleButton.setSelected(true);
        this.toolBar.add(this.scaleButton);
        this.autoScaleSlider = new JSlider(1, 39, (int)(10.0 - this.settings.barMult) * 4);
        this.autoScaleSlider.setToolTipText("Adjust helicorder scale");
        this.autoScaleSlider.setFocusable(false);
        this.autoScaleSlider.setPreferredSize(new Dimension(80, 20));
        this.autoScaleSlider.setMaximumSize(new Dimension(80, 20));
        this.autoScaleSlider.setMinimumSize(new Dimension(80, 20));
        this.autoScaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.autoScale = true;
                if (!HelicorderViewerFrame.this.autoScaleSlider.getValueIsAdjusting()) {
                    if (HelicorderViewerFrame.this.scaleClipState) {
                        ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipBars = HelicorderViewerFrame.this.autoScaleSlider.getValue() * 3;
                    } else {
                        ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barMult = 10.0 - new Integer(HelicorderViewerFrame.this.autoScaleSlider.getValue()).doubleValue() / 4.0;
                    }
                    HelicorderViewerFrame.this.repaintHelicorder();
                }
            }
        });
        this.toolBar.add(this.autoScaleSlider);
        this.toolBar.add(Box.createHorizontalGlue());
        this.throbber = new Throbber();
        this.toolBar.add(this.throbber);
        this.mainPanel.add((Component)this.toolBar, "North");
    }

    private void createListeners() {
        this.timeListener = new TimeListener(){

            @Override
            public void timeChanged(double j2k) {
                HelicorderViewerFrame.this.helicorderViewPanel.setCursorMark(j2k);
            }
        };
        Swarm.getApplication().addTimeListener(this.timeListener);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                if (((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel != null) {
                    Swarm.getApplication().getDataChooser().setNearest(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
                }
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                HelicorderViewerFrame.this.dispose();
                HelicorderViewerFrame.this.throbber.close();
                HelicorderViewerFrame.this.refreshThread.kill();
                Swarm.getApplication().removeInternalFrame(HelicorderViewerFrame.this);
                Swarm.getApplication().removeTimeListener(HelicorderViewerFrame.this.timeListener);
                HelicorderViewerFrame.this.dataSource.notifyDataNotNeeded(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel, HelicorderViewerFrame.this.helicorderViewPanel.getStartTime(), HelicorderViewerFrame.this.helicorderViewPanel.getEndTime(), HelicorderViewerFrame.this.gulperListener);
                HelicorderViewerFrame.this.dataSource.close();
                if (HelicorderViewerFrame.this.wigglerPanel != null) {
                    HelicorderViewerFrame.this.wigglerPanel.kill();
                }
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
                HelicorderViewerFrame.this.helicorderViewPanel.setResized(true);
                HelicorderViewerFrame.this.repaintHelicorder();
                HelicorderViewerFrame.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (HelicorderViewerFrame.this.getWidth() < 530) {
                    HelicorderViewerFrame.this.helicorderViewPanel.setMinimal(true);
                } else {
                    HelicorderViewerFrame.this.helicorderViewPanel.setMinimal(false);
                }
                HelicorderViewerFrame.this.helicorderViewPanel.setResized(true);
                HelicorderViewerFrame.this.repaintHelicorder();
                HelicorderViewerFrame.this.repaint();
            }
        });
        this.gulperListener = new GulperListener(){

            @Override
            public void gulperStarted() {
                HelicorderViewerFrame.this.gulperWorking = true;
                HelicorderViewerFrame.this.throbber.increment();
            }

            @Override
            public void gulperStopped(boolean killed) {
                if (killed) {
                    HelicorderViewerFrame.this.noData = true;
                } else {
                    HelicorderViewerFrame.this.gulperWorking = false;
                    HelicorderViewerFrame.this.throbber.decrement();
                    HelicorderData hd = HelicorderViewerFrame.this.helicorderViewPanel.getData();
                    if (hd == null || hd.rows() == 0) {
                        HelicorderViewerFrame.this.noData = true;
                    }
                    HelicorderViewerFrame.this.repaintHelicorder();
                }
            }

            @Override
            public void gulperGulped(double t1, double t2, boolean success) {
                if (success) {
                    HelicorderViewerFrame.this.getHelicorder();
                }
            }
        };
        this.dataListener = new SeismicDataSourceListener(){

            @Override
            public void channelsProgress(String id, double progress) {
            }

            @Override
            public void channelsUpdated() {
            }

            @Override
            public void helicorderProgress(String channel, final double progress) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).HelicorderViewerFrame.this.progressBar.isVisible()) {
                            (this).HelicorderViewerFrame.this.progressBar.setVisible(true);
                        }
                        if (progress == -1.0) {
                            (this).HelicorderViewerFrame.this.progressBar.setIndeterminate(true);
                            (this).HelicorderViewerFrame.this.progressBar.setString("Waiting for server");
                        } else if (progress >= 0.0 && progress < 1.0) {
                            (this).HelicorderViewerFrame.this.progressBar.setIndeterminate(false);
                            (this).HelicorderViewerFrame.this.progressBar.setValue((int)(progress * 100.0));
                            (this).HelicorderViewerFrame.this.progressBar.setString("Downloading");
                        }
                        if (progress == 1.0) {
                            (this).HelicorderViewerFrame.this.progressBar.setVisible(false);
                        }
                    }
                });
            }
        };
        this.dataSource.addListener(this.dataListener);
    }

    public HelicorderViewPanel getHelicorderViewPanel() {
        return this.helicorderViewPanel;
    }

    public void settingsChanged() {
        if (!this.settings.showWiggler && this.wigglerPanel != null) {
            this.removeWiggler();
        }
        if (this.settings.showWiggler && this.wigglerPanel == null) {
            this.createWiggler();
        }
    }

    public void setPinned(boolean b) {
        this.pinButton.setSelected(b);
        int layer = b ? JLayeredPane.MODAL_LAYER : JLayeredPane.DEFAULT_LAYER;
        Swarm.getApplication().setFrameLayer(this, layer);
    }

    public void createWiggler() {
        this.wigglerPanel = new WigglerPanel(this.dataSource, this.settings.channel);
        this.heliPanel.add((Component)this.wigglerPanel, "South");
        this.wigglerPanel.setPreferredSize(new Dimension(this.getSize().width, 75));
    }

    public void removeWiggler() {
        if (this.wigglerPanel != null) {
            this.wigglerPanel.kill();
            this.heliPanel.remove(this.wigglerPanel);
            this.wigglerPanel = null;
        }
    }

    public void incXAxis() {
        int index = SwarmUtil.linearSearch(chunkValues, this.settings.timeChunk);
        if (index == -1 || index == chunkValues.length - 1) {
            return;
        }
        this.settings.timeChunk = chunkValues[index + 1];
    }

    public void decXAxis() {
        int index = SwarmUtil.linearSearch(chunkValues, this.settings.timeChunk);
        if (index == -1 || index == 0) {
            return;
        }
        this.settings.timeChunk = chunkValues[index - 1];
    }

    public void incYAxis() {
        int index = SwarmUtil.linearSearch(spanValues, this.settings.span);
        if (index == -1 || index == spanValues.length - 1) {
            return;
        }
        this.settings.span = spanValues[index + 1];
    }

    public void decYAxis() {
        int index = SwarmUtil.linearSearch(spanValues, this.settings.span);
        if (index == -1 || index == 0) {
            return;
        }
        this.settings.span = spanValues[index - 1];
    }

    public void incZoom() {
        int index = SwarmUtil.linearSearch(zoomValues, this.settings.waveZoomOffset);
        if (index == -1 || index == zoomValues.length - 1) {
            return;
        }
        this.settings.waveZoomOffset = zoomValues[index + 1];
    }

    public void decZoom() {
        int index = SwarmUtil.linearSearch(zoomValues, this.settings.waveZoomOffset);
        if (index == -1 || index == 0) {
            return;
        }
        this.settings.waveZoomOffset = zoomValues[index - 1];
    }

    public void setInsetButtonsEnabled(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelicorderViewerFrame.this.clipboard.setEnabled(b);
                HelicorderViewerFrame.this.removeWave.setEnabled(b);
            }
        });
    }

    public void setNavigationButtonsEnabled(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelicorderViewerFrame.this.compX.setEnabled(b);
                HelicorderViewerFrame.this.expX.setEnabled(b);
                HelicorderViewerFrame.this.forwardButton.setEnabled(b);
                HelicorderViewerFrame.this.backButton.setEnabled(b);
                HelicorderViewerFrame.this.compY.setEnabled(b);
                HelicorderViewerFrame.this.expY.setEnabled(b);
                HelicorderViewerFrame.this.capture.setEnabled(b);
            }
        });
    }

    @Override
    public void setKioskMode(boolean b) {
        super.setDefaultKioskMode(b);
        this.helicorderViewPanel.setFullScreen(this.fullScreen);
        if (this.fullScreen) {
            this.mainPanel.remove(this.toolBar);
            this.heliPanel.setBorder(null);
        } else {
            this.mainPanel.add((Component)this.toolBar, "North");
            this.heliPanel.setBorder(this.border);
        }
        if (this.helicorderViewPanel != null) {
            this.helicorderViewPanel.requestFocus();
        }
    }

    public void setStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelicorderViewerFrame.this.statusLabel.setText(status);
            }
        });
    }

    public Throbber getThrobber() {
        return this.throbber;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public WaveViewSettings getWaveViewSettings() {
        return this.waveViewSettings;
    }

    public HelicorderViewerSettings getHelicorderViewerSettings() {
        return this.settings;
    }

    public void repaintHelicorder() {
        this.helicorderViewPanel.invalidateImage();
    }

    public void scroll(int units) {
        double bt = this.settings.getBottomTime();
        if (Double.isNaN(bt)) {
            bt = CurrentTime.getInstance().nowJ2K();
        }
        this.settings.setBottomTime(bt + (double)(units * this.settings.scrollSize * this.settings.timeChunk));
        this.getHelicorder();
    }

    public boolean isWorking() {
        return this.working || this.gulperWorking;
    }

    public void getHelicorder() {
        if (this.noData) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            private double end;
            private double before;
            private HelicorderData hd;
            private boolean success = false;

            @Override
            public Object construct() {
                block8: {
                    try {
                        try {
                            HelicorderViewerFrame.this.setNavigationButtonsEnabled(false);
                            HelicorderViewerFrame.this.throbber.increment();
                            HelicorderViewerFrame.this.working = true;
                            this.end = HelicorderViewerFrame.this.settings.getBottomTime();
                            if (Double.isNaN(this.end)) {
                                this.end = CurrentTime.getInstance().nowJ2K();
                            }
                            this.before = this.end - (double)(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.span * 60);
                            int tc = 30;
                            if (HelicorderViewerFrame.this.helicorderViewPanel != null) {
                                tc = ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.timeChunk;
                            }
                            if (!HelicorderViewerFrame.this.isClosed) {
                                this.hd = HelicorderViewerFrame.this.dataSource.getHelicorder(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel, this.before - (double)tc, this.end + (double)tc, HelicorderViewerFrame.this.gulperListener);
                                this.success = true;
                                break block8;
                            }
                            this.success = false;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            System.err.println("getHelicorder() Error: " + e.getMessage());
                            HelicorderViewerFrame.this.working = false;
                        }
                    }
                    finally {
                        HelicorderViewerFrame.this.working = false;
                    }
                }
                return null;
            }

            @Override
            public void finished() {
                HelicorderViewerFrame.this.lastRefreshTime = System.currentTimeMillis();
                HelicorderViewerFrame.this.throbber.decrement();
                HelicorderViewerFrame.this.setNavigationButtonsEnabled(true);
                if (this.success) {
                    if (this.hd != null && this.hd.getEndTime() < this.before && !HelicorderViewerFrame.this.dataSource.isActiveSource()) {
                        double dt = this.end - this.before;
                        this.before = this.hd.getEndTime() - dt / 2.0;
                        this.end = this.hd.getEndTime() + dt / 2.0;
                        HelicorderViewerFrame.this.settings.setBottomTime(this.end);
                    }
                    HelicorderViewerFrame.this.helicorderViewPanel.setHelicorder(this.hd, this.before, this.end);
                    HelicorderViewerFrame.this.repaintHelicorder();
                }
            }
        };
        worker.start();
    }

    public Wave getWave(double t1, double t2) {
        return this.dataSource.getWave(this.settings.channel, t1, t2);
    }

    public SeismicDataSource getDataSource() {
        return this.dataSource;
    }

    private class CaptureActionListener
    implements ActionListener {
        private CaptureActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelicorderViewerFrame.this.chooser = Swarm.getApplication().getFileChooser();
            HelicorderViewerFrame.this.chooser.setDialogTitle("Save Helicorder Screen Capture");
            HelicorderViewerFrame.this.chooser.setSelectedFile(new File("heli.png"));
            File lastPath = new File(Swarm.config.lastPath);
            HelicorderViewerFrame.this.chooser.setCurrentDirectory(lastPath);
            JPanel imagePanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            imagePanel.setBorder(new TitledBorder(new EtchedBorder(), "Image Properties"));
            JLabel heightLabel = new JLabel("Height:");
            JTextField heightTextField = new JTextField(4);
            heightLabel.setLabelFor(heightTextField);
            heightTextField.setText("700");
            JLabel widthLabel = new JLabel("Width:");
            JTextField widthTextField = new JTextField(4);
            widthLabel.setLabelFor(widthTextField);
            widthTextField.setText("900");
            JCheckBox includeChannel = new JCheckBox("Include channel");
            includeChannel.setSelected(true);
            JLabel fileFormatLabel = new JLabel("File format:");
            JComboBox<String> fileFormatCB = new JComboBox<String>();
            fileFormatCB.addItem("PNG");
            fileFormatCB.addItem("PS");
            fileFormatCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    if (source.getSelectedItem().equals("PS")) {
                        String fn = HelicorderViewerFrame.this.chooser.getSelectedFile().getName().replaceAll("\\..*$", ".ps");
                        HelicorderViewerFrame.this.chooser.setSelectedFile(new File(HelicorderViewerFrame.this.chooser.getCurrentDirectory().getAbsoluteFile(), fn));
                    } else {
                        String fn = HelicorderViewerFrame.this.chooser.getSelectedFile().getName().replaceAll("\\..*$", ".png");
                        HelicorderViewerFrame.this.chooser.setSelectedFile(new File(HelicorderViewerFrame.this.chooser.getCurrentDirectory().getAbsoluteFile(), fn));
                    }
                }
            });
            imagePanel.add((Component)heightLabel, GridBagHelper.set(c, "x=0;y=0;w=1;h=1;wx=1;wy=0;ix=12;iy=2;a=nw;f=n;i=0,4,0,4"));
            imagePanel.add((Component)heightTextField, GridBagHelper.set(c, "x=1;y=0;w=1;h=1;wx=1;ix=12;iy=2;f=n;i=0,4,0,4"));
            imagePanel.add((Component)widthLabel, GridBagHelper.set(c, "x=0;y=1;w=1;h=1;wx=1;wy=0;ix=12;iy=2;f=n;i=0,4,0,4"));
            imagePanel.add((Component)widthTextField, GridBagHelper.set(c, "x=1;y=1;w=1;h=1;wx=1;ix=12;iy=2;f=n;i=0,4,0,4"));
            imagePanel.add((Component)fileFormatLabel, GridBagHelper.set(c, "x=0;y=2;w=1;h=1;wx=1;wy=0;ix=12;iy=2;a=nw;f=w;i=0,4,0,4"));
            imagePanel.add(fileFormatCB, GridBagHelper.set(c, "x=1;y=2;w=1;h=1;wx=1;wy=1;ix=12;iy=2;a=nw;f=w;i=0,4,0,4"));
            imagePanel.add((Component)includeChannel, GridBagHelper.set(c, "x=0;y=3;w=2;h=1;wx=1;wy=1;ix=12;iy=2;a=nw;f=w;i=0,4,0,4"));
            HelicorderViewerFrame.this.chooser.setAccessory(imagePanel);
            String fn = String.valueOf(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel.replace(' ', '_')) + ".png";
            HelicorderViewerFrame.this.chooser.setSelectedFile(new File(HelicorderViewerFrame.this.chooser.getCurrentDirectory().getAbsoluteFile(), fn));
            int result = HelicorderViewerFrame.this.chooser.showSaveDialog(Swarm.getApplication());
            if (result == 0) {
                int choice;
                File f = HelicorderViewerFrame.this.chooser.getSelectedFile();
                if (f.exists() && (choice = JOptionPane.showConfirmDialog(Swarm.getApplication(), "File exists, overwrite?", "Confirm", 0)) != 0) {
                    return;
                }
                int width = -1;
                int height = -1;
                try {
                    width = Integer.parseInt(widthTextField.getText());
                    height = Integer.parseInt(heightTextField.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (width <= 0 || height <= 0) {
                    JOptionPane.showMessageDialog(HelicorderViewerFrame.this, "Illegal width or height.", "Error", 0);
                    return;
                }
                Plot plot = new Plot(width, height);
                Double end = HelicorderViewerFrame.this.settings.getBottomTime();
                if (Double.isNaN(end)) {
                    end = CurrentTime.getInstance().nowJ2K();
                }
                Double before = end - (double)(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.span * 60);
                int tc = 30;
                HelicorderData heliData = HelicorderViewerFrame.this.dataSource.getHelicorder(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel, before - (double)tc, end + (double)tc, null);
                HelicorderRenderer heliRenderer = new HelicorderRenderer(heliData, ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.timeChunk);
                heliRenderer.setChannel(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
                heliRenderer.setLocation(70, 10, width - 70 - 70, height - 10 - 35);
                heliRenderer.setHelicorderExtents(before, end, -1 * Math.abs(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barRange), Math.abs(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barRange));
                heliRenderer.setTimeZone(Swarm.config.getTimeZone(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel));
                heliRenderer.setForceCenter(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.forceCenter);
                heliRenderer.setClipBars(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipBars);
                heliRenderer.setShowClip(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.showClip);
                heliRenderer.setClipValue(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipValue);
                heliRenderer.setChannel(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
                heliRenderer.setLargeChannelDisplay(includeChannel.isSelected());
                heliRenderer.createDefaultAxis();
                plot.addRenderer(heliRenderer);
                if (fileFormatCB.getSelectedItem().equals("PS")) {
                    plot.writePS(f.getAbsolutePath());
                } else {
                    plot.writePNG(f.getAbsolutePath());
                }
                Swarm.config.lastPath = f.getParent();
            }
            HelicorderViewerFrame.this.chooser.setAccessory(null);
        }
    }

    private class RefreshThread
    extends Thread {
        private boolean kill;

        public RefreshThread() {
            super("HeliRefresh-" + ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
            this.kill = false;
            this.setPriority(1);
            this.start();
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.kill) {
                long now2;
                boolean reset;
                long lastUI = System.currentTimeMillis() - Swarm.getApplication().getLastUITime();
                boolean bl = reset = Swarm.config.isKiosk() && lastUI > 600000L;
                if (reset || !Double.isNaN(HelicorderViewerFrame.this.settings.getBottomTime()) && HelicorderViewerFrame.this.settings.getLastBottomTimeSet() > 600000L) {
                    HelicorderViewerFrame.this.helicorderViewPanel.removeWaveInset();
                    HelicorderViewerFrame.this.helicorderViewPanel.clearMarks();
                    HelicorderViewerFrame.this.settings.setBottomTime(Double.NaN);
                    if (Swarm.config.isKiosk() && !Swarm.getApplication().isFullScreenMode()) {
                        Swarm.getApplication().toggleFullScreenMode();
                    }
                }
                try {
                    now2 = System.currentTimeMillis();
                    long sleepTime = Math.min(now2 - HelicorderViewerFrame.this.lastRefreshTime, (long)(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.refreshInterval * 1000));
                    if (((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.refreshInterval > 0) {
                        Thread.sleep(sleepTime);
                    } else {
                        Thread.sleep(30000L);
                    }
                }
                catch (Exception now2) {
                    // empty catch block
                }
                now2 = System.currentTimeMillis();
                if (this.kill || ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.refreshInterval <= 0 || now2 - HelicorderViewerFrame.this.lastRefreshTime <= (long)(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.refreshInterval * 1000)) continue;
                try {
                    double bt = HelicorderViewerFrame.this.settings.getBottomTime();
                    if (!HelicorderViewerFrame.this.dataSource.isActiveSource() || !Double.isNaN(bt) || HelicorderViewerFrame.this.working) continue;
                    HelicorderViewerFrame.this.getHelicorder();
                }
                catch (Exception e) {
                    System.err.println("Exception during refresh:");
                    e.printStackTrace();
                }
            }
        }
    }
}

