/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.heli;

import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.heli.HelicorderViewPanel;
import gov.usgs.util.ConfigFile;

public class HelicorderViewerSettings {
    public String channel;
    public int timeChunk;
    public int span;
    public int waveZoomOffset;
    private double bottomTime;
    public int refreshInterval;
    public int scrollSize;
    public boolean forceCenter;
    public int clipBars;
    private long lastBottomTimeSet;
    public boolean showWiggler;
    public boolean autoScale;
    public boolean showClip;
    public boolean alertClip;
    public int alertClipTimeout;
    public int clipValue;
    public int barRange;
    public double barMult;
    public HelicorderViewPanel view;

    public HelicorderViewerSettings(String ch) {
        this.channel = ch;
        this.timeChunk = Swarm.config.timeChunk * 60;
        this.span = Swarm.config.span * 60;
        this.waveZoomOffset = 30;
        this.bottomTime = Double.NaN;
        this.refreshInterval = 15;
        this.scrollSize = 24;
        this.forceCenter = false;
        this.clipBars = 21;
        this.showWiggler = false;
        this.clipValue = 2999;
        this.showClip = Swarm.config.showClip;
        this.alertClip = Swarm.config.alertClip;
        this.alertClipTimeout = Swarm.config.alertClipTimeout * 60;
        this.barRange = 1500;
        this.barMult = 3.0;
        this.autoScale = true;
    }

    public long getLastBottomTimeSet() {
        return System.currentTimeMillis() - this.lastBottomTimeSet;
    }

    public void setBottomTime(double bt) {
        this.lastBottomTimeSet = System.currentTimeMillis();
        this.bottomTime = bt;
    }

    public double getBottomTime() {
        return this.bottomTime;
    }

    public void set(ConfigFile cf) {
        this.timeChunk = Integer.parseInt(cf.getString("timeChunk"));
        this.span = Integer.parseInt(cf.getString("span"));
        this.waveZoomOffset = Integer.parseInt(cf.getString("waveZoomOffset"));
        this.refreshInterval = Integer.parseInt(cf.getString("refreshInterval"));
        this.scrollSize = Integer.parseInt(cf.getString("scrollSize"));
        this.clipValue = Integer.parseInt(cf.getString("clipValue"));
        this.clipBars = Integer.parseInt(cf.getString("clipBars"));
        this.barRange = Integer.parseInt(cf.getString("barRange"));
        this.alertClipTimeout = Integer.parseInt(cf.getString("alertClipTimeout"));
        this.setBottomTime(Double.parseDouble(cf.getString("bottomTime")));
        this.barMult = Double.parseDouble(cf.getString("barMult"));
        this.forceCenter = Boolean.parseBoolean(cf.getString("forceCenter"));
        this.autoScale = Boolean.parseBoolean(cf.getString("autoScale"));
        this.showClip = Boolean.parseBoolean(cf.getString("showClip"));
        this.alertClip = Boolean.parseBoolean(cf.getString("alertClip"));
    }

    public void save(ConfigFile cf, String prefix) {
        cf.put(String.valueOf(prefix) + ".channel", this.channel);
        cf.put(String.valueOf(prefix) + ".timeChunk", Integer.toString(this.timeChunk));
        cf.put(String.valueOf(prefix) + ".span", Integer.toString(this.span));
        cf.put(String.valueOf(prefix) + ".waveZoomOffset", Integer.toString(this.waveZoomOffset));
        cf.put(String.valueOf(prefix) + ".refreshInterval", Integer.toString(this.refreshInterval));
        cf.put(String.valueOf(prefix) + ".scrollSize", Integer.toString(this.scrollSize));
        cf.put(String.valueOf(prefix) + ".clipValue", Integer.toString(this.clipValue));
        cf.put(String.valueOf(prefix) + ".clipBars", Integer.toString(this.clipBars));
        cf.put(String.valueOf(prefix) + ".barRange", Integer.toString(this.barRange));
        cf.put(String.valueOf(prefix) + ".alertClipTimeout", Integer.toString(this.alertClipTimeout));
        cf.put(String.valueOf(prefix) + ".bottomTime", Double.toString(this.bottomTime));
        cf.put(String.valueOf(prefix) + ".barMult", Double.toString(this.barMult));
        cf.put(String.valueOf(prefix) + ".forceCenter", Boolean.toString(this.forceCenter));
        cf.put(String.valueOf(prefix) + ".autoScale", Boolean.toString(this.autoScale));
        cf.put(String.valueOf(prefix) + ".showClip", Boolean.toString(this.showClip));
        cf.put(String.valueOf(prefix) + ".alertClip", Boolean.toString(this.alertClip));
    }

    public void parseSettingsString(String o) {
        String[] opts = o.split(",");
        int i = 0;
        while (i < opts.length) {
            try {
                String key = opts[i].substring(0, opts[i].indexOf(61));
                String value = opts[i].substring(opts[i].indexOf(61) + 1);
                if (key.equals("x")) {
                    this.timeChunk = Integer.parseInt(value) * 60;
                } else if (key.equals("y")) {
                    this.span = Integer.parseInt(value) * 60;
                }
            }
            catch (Exception e) {
                System.err.println("Could not parse setting: " + opts[i]);
            }
            ++i;
        }
    }

    public void notifyView() {
        if (this.view != null) {
            this.view.settingsChanged();
        }
    }
}

