/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.map;

import gov.usgs.proj.GeoRange;
import gov.usgs.swarm.Images;
import gov.usgs.swarm.Kioskable;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmFrame;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.Throbber;
import gov.usgs.swarm.heli.HelicorderViewPanelListener;
import gov.usgs.swarm.map.MapPanel;
import gov.usgs.swarm.map.MapSettingsDialog;
import gov.usgs.swarm.wave.MultiMonitor;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.swarm.wave.WaveViewSettingsToolbar;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.util.png.PngEncoderB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class MapFrame
extends SwarmFrame
implements Runnable,
Kioskable {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private JPanel mainPanel;
    private JButton optionsButton;
    private JButton labelButton;
    private JLabel statusLabel;
    private JToggleButton linkButton;
    private JToggleButton realtimeButton;
    private JButton compXButton;
    private JButton expXButton;
    private JButton forwardTimeButton;
    private JButton backTimeButton;
    private JButton gotoButton;
    private JButton timeHistoryButton;
    private JButton captureButton;
    private JButton clipboardButton;
    private JToggleButton dragButton;
    private JToggleButton dragZoomButton;
    private JToggleButton rulerButton;
    private WaveViewSettingsToolbar waveToolbar;
    private WaveViewPanel selected;
    private Thread updateThread;
    private MapPanel mapPanel;
    private Throbber throbber;
    private int spanIndex = 3;
    private boolean realtime = true;
    private long refreshInterval = 1000L;
    private HelicorderViewPanelListener linkListener;
    private boolean heliLinked = true;
    private Border border;

    public MapFrame() {
        super("Map", true, true, true, false);
        this.setFocusable(true);
        Swarm.getApplication().touchUITime();
        this.createUI();
        this.updateThread = new Thread((Runnable)this, "Map Update");
        this.updateThread.start();
    }

    @Override
    public void saveLayout(ConfigFile cf, String prefix) {
        super.saveLayout(cf, prefix);
        this.mapPanel.saveLayout(cf, String.valueOf(prefix) + ".panel");
    }

    public void processLayout(ConfigFile cf) {
        this.processStandardLayout(cf);
        this.mapPanel.processLayout(cf.getSubConfig("panel"));
        MapPanel.LabelSetting ls = this.mapPanel.getLabelSetting();
        this.labelButton.setIcon(ls.getIcon());
    }

    private void createUI() {
        this.setFrameIcon(Images.getIcon("earth"));
        this.setSize(Swarm.config.mapWidth, Swarm.config.mapHeight);
        this.setLocation(Swarm.config.mapX, Swarm.config.mapY);
        this.setDefaultCloseOperation(0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.createToolbar();
        this.mainPanel.add((Component)this.toolbar, "North");
        this.mapPanel = new MapPanel(this);
        this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 3), LineBorder.createGrayLineBorder());
        this.mapPanel.setBorder(this.border);
        this.mainPanel.add((Component)this.mapPanel, "Center");
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
        this.mainPanel.add((Component)this.statusLabel, "South");
        this.setContentPane(this.mainPanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (!MapFrame.this.mapPanel.imageValid()) {
                    MapFrame.this.mapPanel.resetImage();
                }
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                MapFrame.this.setVisible(false);
            }
        });
        this.linkListener = new HelicorderViewPanelListener(){

            @Override
            public void insetCreated(double st, double et) {
                if (MapFrame.this.heliLinked) {
                    if (!MapFrame.this.realtime) {
                        MapFrame.this.mapPanel.timePush();
                    }
                    MapFrame.this.setRealtime(false);
                    MapFrame.this.mapPanel.setTimes(st, et, true);
                }
            }
        };
        this.setVisible(true);
    }

    @Override
    public void setMaximum(boolean max) throws PropertyVetoException {
        if (max) {
            Swarm.config.mapX = this.getX();
            Swarm.config.mapY = this.getY();
        }
        super.setMaximum(max);
    }

    private void createToolbar() {
        this.toolbar = SwarmUtil.createToolBar();
        this.optionsButton = SwarmUtil.createToolBarButton(Images.getIcon("settings"), "Monitor options", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapSettingsDialog msd = MapSettingsDialog.getInstance(MapFrame.this);
                msd.setVisible(true);
            }
        });
        this.toolbar.add(this.optionsButton);
        this.labelButton = SwarmUtil.createToolBarButton(Images.getIcon("label_some"), "Change label settings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.LabelSetting ls = MapFrame.this.mapPanel.getLabelSetting().next();
                MapFrame.this.labelButton.setIcon(ls.getIcon());
                MapFrame.this.mapPanel.setLabelSetting(ls);
            }
        });
        this.toolbar.add(this.labelButton);
        this.toolbar.addSeparator();
        this.realtimeButton = SwarmUtil.createToolBarToggleButton(Images.getIcon("clock"), "Realtime mode (N)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.setRealtime(MapFrame.this.realtimeButton.isSelected());
            }
        });
        Util.mapKeyStrokeToButton(this, "N", "realtime", this.realtimeButton);
        this.realtimeButton.setSelected(this.realtime);
        this.toolbar.add(this.realtimeButton);
        this.linkButton = SwarmUtil.createToolBarToggleButton(Images.getIcon("helilink"), "Synchronize times with helicorder wave (H)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.heliLinked = MapFrame.this.linkButton.isSelected();
            }
        });
        Util.mapKeyStrokeToButton(this, "H", "helilink", this.linkButton);
        this.linkButton.setSelected(this.heliLinked);
        this.toolbar.add(this.linkButton);
        this.toolbar.addSeparator();
        JButton earthButton = SwarmUtil.createToolBarButton(Images.getIcon("earth"), "Zoom out to full scale (Home)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point2D.Double c = new Point2D.Double(((MapFrame)MapFrame.this).mapPanel.getCenter().x, 0.0);
                MapFrame.this.mapPanel.setCenterAndScale(c, 100000.0);
            }
        });
        Util.mapKeyStrokeToButton(this, "HOME", "home", earthButton);
        this.toolbar.add(earthButton);
        this.dragButton = SwarmUtil.createToolBarToggleButton(Images.getIcon("drag"), "Drag map (D)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPanel.setDragMode(MapPanel.DragMode.DRAG_MAP);
            }
        });
        Util.mapKeyStrokeToButton(this, "D", "drag", this.dragButton);
        this.dragButton.setSelected(true);
        this.toolbar.add(this.dragButton);
        this.dragZoomButton = SwarmUtil.createToolBarToggleButton(Images.getIcon("dragbox"), "Zoom into box (B)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPanel.setDragMode(MapPanel.DragMode.BOX);
            }
        });
        Util.mapKeyStrokeToButton(this, "B", "box", this.dragZoomButton);
        this.dragZoomButton.setSelected(false);
        this.toolbar.add(this.dragZoomButton);
        this.rulerButton = SwarmUtil.createToolBarToggleButton(Images.getIcon("ruler"), "Measure distances (M)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPanel.setDragMode(MapPanel.DragMode.RULER);
            }
        });
        Util.mapKeyStrokeToButton(this, "M", "measure", this.rulerButton);
        this.toolbar.add(this.rulerButton);
        this.toolbar.addSeparator();
        ButtonGroup group = new ButtonGroup();
        group.add(this.dragButton);
        group.add(this.dragZoomButton);
        group.add(this.rulerButton);
        JButton zoomIn = SwarmUtil.createToolBarButton(Images.getIcon("zoomplus"), "Zoom in (+)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPanel.zoom(0.5);
            }
        });
        Util.mapKeyStrokeToButton(this, "EQUALS", "zoomin1", zoomIn);
        Util.mapKeyStrokeToButton(this, "shift EQUALS", "zoomin2", zoomIn);
        this.toolbar.add(zoomIn);
        JButton zoomOut = SwarmUtil.createToolBarButton(Images.getIcon("zoomminus"), "Zoom out (-)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPanel.zoom(2.0);
            }
        });
        Util.mapKeyStrokeToButton(this, "MINUS", "zoomout1", zoomOut);
        this.toolbar.add(zoomOut);
        JButton backButton = SwarmUtil.createToolBarButton(Images.getIcon("geoback"), "Last map view (Ctrl-backspace)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPanel.mapPop();
            }
        });
        Util.mapKeyStrokeToButton(this, "ctrl BACK_SPACE", "mapback1", backButton);
        this.toolbar.add(backButton);
        this.toolbar.addSeparator();
        this.backTimeButton = SwarmUtil.createToolBarButton(Images.getIcon("left"), "Scroll back time 20% (Left arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.setRealtime(false);
                MapFrame.this.mapPanel.shiftTime(-0.2);
            }
        });
        Util.mapKeyStrokeToButton(this, "LEFT", "backward1", this.backTimeButton);
        this.toolbar.add(this.backTimeButton);
        this.forwardTimeButton = SwarmUtil.createToolBarButton(Images.getIcon("right"), "Scroll forward time 20% (Right arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.setRealtime(false);
                MapFrame.this.mapPanel.shiftTime(0.2);
            }
        });
        this.toolbar.add(this.forwardTimeButton);
        Util.mapKeyStrokeToButton(this, "RIGHT", "forward1", this.forwardTimeButton);
        this.gotoButton = SwarmUtil.createToolBarButton(Images.getIcon("gototime"), "Go to time (Ctrl-G)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String t = JOptionPane.showInputDialog(Swarm.getApplication(), "Input time in 'YYYYMMDDhhmm[ss]' format:", "Go to Time", -1);
                if (t != null) {
                    if (t.length() == 12) {
                        t = String.valueOf(t) + "30";
                    }
                    double j2k = Time.parse("yyyyMMddHHmmss", t);
                    MapFrame.this.setRealtime(false);
                    MapFrame.this.mapPanel.gotoTime(j2k);
                }
            }
        });
        this.toolbar.add(this.gotoButton);
        Util.mapKeyStrokeToButton(this, "ctrl G", "goto", this.gotoButton);
        this.compXButton = SwarmUtil.createToolBarButton(Images.getIcon("xminus"), "Shrink time axis (Alt-left arrow", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapFrame.this.realtime) {
                    if (MapFrame.this.spanIndex != 0) {
                        MapFrame mapFrame = MapFrame.this;
                        mapFrame.spanIndex = mapFrame.spanIndex - 1;
                    }
                } else {
                    MapFrame.this.mapPanel.scaleTime(0.2);
                }
            }
        });
        this.toolbar.add(this.compXButton);
        Util.mapKeyStrokeToButton(this, "alt LEFT", "compx", this.compXButton);
        this.expXButton = SwarmUtil.createToolBarButton(Images.getIcon("xplus"), "Expand time axis (Alt-right arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapFrame.this.realtime) {
                    if (MapFrame.this.spanIndex < MultiMonitor.SPANS.length - 1) {
                        MapFrame mapFrame = MapFrame.this;
                        mapFrame.spanIndex = mapFrame.spanIndex + 1;
                    }
                } else {
                    MapFrame.this.mapPanel.scaleTime(-0.2);
                }
            }
        });
        this.toolbar.add(this.expXButton);
        Util.mapKeyStrokeToButton(this, "alt RIGHT", "expx", this.expXButton);
        this.timeHistoryButton = SwarmUtil.createToolBarButton(Images.getIcon("timeback"), "Last time settings (Backspace)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapFrame.this.mapPanel.timePop()) {
                    MapFrame.this.setRealtime(false);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "BACK_SPACE", "back", this.timeHistoryButton);
        this.toolbar.add(this.timeHistoryButton);
        this.toolbar.addSeparator();
        this.waveToolbar = new WaveViewSettingsToolbar(null, this.toolbar, this);
        this.clipboardButton = SwarmUtil.createToolBarButton(Images.getIcon("clipboard"), "Copy inset to clipboard (C or Ctrl-C)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFrame.this.mapPanel.wavesToClipboard();
            }
        });
        Util.mapKeyStrokeToButton(this, "control C", "clipboard1", this.clipboardButton);
        Util.mapKeyStrokeToButton(this, "C", "clipboard2", this.clipboardButton);
        this.toolbar.add(this.clipboardButton);
        this.toolbar.addSeparator();
        this.captureButton = SwarmUtil.createToolBarButton(Images.getIcon("camera"), "Save map image (P)", new CaptureActionListener());
        Util.mapKeyStrokeToButton(this, "P", "capture", this.captureButton);
        this.toolbar.add(this.captureButton);
        this.toolbar.addSeparator();
        this.toolbar.add(Box.createHorizontalGlue());
        this.throbber = new Throbber();
        this.toolbar.add(this.throbber);
    }

    public void setRealtime(boolean b) {
        this.realtime = b;
        this.realtimeButton.setSelected(this.realtime);
    }

    public Throbber getThrobber() {
        return this.throbber;
    }

    public void setRefreshInterval(long r) {
        this.refreshInterval = r;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public MapPanel getMapPanel() {
        return this.mapPanel;
    }

    public void setSelectedWave(WaveViewPanel wvp) {
        this.selected = wvp;
        this.waveToolbar.setSettings(this.selected.getSettings());
    }

    public void setView(GeoRange gr) {
        double lr1 = gr.getLonRange();
        double lr2 = GeoRange.getLonRange(gr.getEast(), gr.getWest());
        if (lr2 < lr1) {
            gr.flipEastWest();
        }
        this.mapPanel.setCenterAndScale(gr);
    }

    public void setStatusText(final String t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String missing = "";
                if (MapFrame.this.mapPanel.getMissing() == 1) {
                    missing = "(" + MapFrame.this.mapPanel.getMissing() + " channel hidden) ";
                } else if (MapFrame.this.mapPanel.getMissing() > 1) {
                    missing = "(" + MapFrame.this.mapPanel.getMissing() + " channels hidden) ";
                }
                MapFrame.this.statusLabel.setText(String.valueOf(missing) + t);
                MapFrame.this.statusLabel.repaint();
            }
        });
    }

    public void reloadImages() {
        this.mapPanel.loadMaps(true);
    }

    public void reset(boolean doMap) {
        this.mapPanel.resetImage(doMap);
    }

    public void mapSettingsChanged() {
        this.mapPanel.loadMaps(true);
    }

    public HelicorderViewPanelListener getLinkListener() {
        return this.linkListener;
    }

    @Override
    public void setKioskMode(boolean b) {
        this.setDefaultKioskMode(b);
        if (this.fullScreen) {
            this.mainPanel.remove(this.toolbar);
            this.mapPanel.setBorder(null);
        } else {
            this.mainPanel.add((Component)this.toolbar, "North");
            this.mapPanel.setBorder(this.border);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.isVisible() && this.realtime) {
                        double end = CurrentTime.getInstance().nowJ2K();
                        double start = end - (double)MultiMonitor.SPANS[this.spanIndex];
                        this.mapPanel.setTimes(start, end, false);
                    }
                    Thread.sleep(this.refreshInterval);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    class CaptureActionListener
    implements ActionListener {
        CaptureActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = Swarm.getApplication().getFileChooser();
            File lastPath = new File(Swarm.config.lastPath);
            chooser.setCurrentDirectory(lastPath);
            chooser.setSelectedFile(new File("map.png"));
            chooser.setDialogTitle("Save Map Screen Capture");
            int result = chooser.showSaveDialog(Swarm.getApplication());
            File f = null;
            if (result == 0) {
                int choice;
                f = chooser.getSelectedFile();
                if (f.exists() && (choice = JOptionPane.showConfirmDialog(Swarm.getApplication(), "File exists, overwrite?", "Confirm", 0)) != 0) {
                    return;
                }
                Swarm.config.lastPath = f.getParent();
            }
            if (f == null) {
                return;
            }
            Insets i = MapFrame.this.mapPanel.getInsets();
            BufferedImage image = new BufferedImage(MapFrame.this.mapPanel.getWidth() - i.left - i.right, MapFrame.this.mapPanel.getHeight() - i.top - i.bottom, 6);
            Graphics g = image.getGraphics();
            g.translate(-i.left, -i.top);
            MapFrame.this.mapPanel.paint(g);
            try {
                PngEncoderB png = new PngEncoderB(image, false, 0, 7);
                FileOutputStream out = new FileOutputStream(f);
                byte[] bytes = png.pngEncode();
                out.write(bytes);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

