/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.map;

import gov.usgs.plot.Plot;
import gov.usgs.plot.TextRenderer;
import gov.usgs.plot.map.GeoImageSet;
import gov.usgs.plot.map.GeoLabelSet;
import gov.usgs.plot.map.MapRenderer;
import gov.usgs.plot.map.WMSGeoImageSet;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Mercator;
import gov.usgs.proj.Projection;
import gov.usgs.proj.TransverseMercator;
import gov.usgs.swarm.Images;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.Throbber;
import gov.usgs.swarm.TimeListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.map.ClickableGeoLabel;
import gov.usgs.swarm.map.LabelSource;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.swarm.map.MapMiniPanel;
import gov.usgs.swarm.wave.WaveClipboardFrame;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Pair;
import gov.usgs.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MapPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int INSET = 30;
    private List<Line2D.Double> lines;
    private GeoImageSet images;
    private GeoLabelSet labels;
    private GeoRange range;
    private Projection projection;
    private RenderedImage image;
    private Point2D.Double center;
    private double scale = 100000.0;
    private JLayeredPane pane;
    private MapImagePanel mapImagePanel;
    private BufferedImage mapImage;
    private MapRenderer renderer;
    private Map<Double, MapMiniPanel> miniPanels;
    private Map<Double, ConfigFile> layouts;
    private List<MapMiniPanel> visiblePanels;
    private DragMode dragMode = DragMode.DRAG_MAP;
    private Point mouseDown;
    private Point mouseNow;
    private Rectangle dragRectangle;
    private MapFrame parent;
    private Stack<double[]> mapHistory;
    private Stack<double[]> timeHistory;
    private int missing;
    private Set<MapMiniPanel> selectedPanels;
    private boolean allowMultiSelection = false;
    private double startTime;
    private double endTime;
    private int dragDX = Integer.MAX_VALUE;
    private int dragDY = Integer.MAX_VALUE;
    private LabelSetting labelSetting = LabelSetting.SOME;
    private List<? extends ClickableGeoLabel> clickableLabels;
    private Semaphore lock = new Semaphore(1);

    public MapPanel(MapFrame f) {
        this.parent = f;
        this.mapHistory = new Stack();
        this.timeHistory = new Stack();
        this.lines = new ArrayList<Line2D.Double>();
        this.miniPanels = Collections.synchronizedMap(new HashMap());
        this.layouts = Collections.synchronizedMap(new HashMap());
        this.visiblePanels = Collections.synchronizedList(new ArrayList());
        this.selectedPanels = new HashSet<MapMiniPanel>();
        Cursor crosshair = new Cursor(1);
        this.setCursor(crosshair);
        this.createUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayout(ConfigFile cf, String prefix) {
        cf.put(String.valueOf(prefix) + ".longitude", Double.toString(this.center.x));
        cf.put(String.valueOf(prefix) + ".latitude", Double.toString(this.center.y));
        cf.put(String.valueOf(prefix) + ".scale", Double.toString(this.scale));
        cf.put(String.valueOf(prefix) + ".labelSetting", this.labelSetting.code);
        List<MapMiniPanel> list = this.visiblePanels;
        synchronized (list) {
            int waves = 0;
            for (MapMiniPanel panel : this.visiblePanels) {
                if (!panel.isWaveVisible()) continue;
                cf.put(String.valueOf(prefix) + ".wave-" + waves + ".hash", Double.toString(panel.getActiveMetadata().getLocationHashCode()));
                panel.saveLayout(cf, String.valueOf(prefix) + ".wave-" + waves++);
            }
            cf.put(String.valueOf(prefix) + ".waves", Integer.toString(waves));
        }
    }

    public void processLayout(ConfigFile cf) {
        int waves = Integer.parseInt(cf.getString("waves"));
        int i = 0;
        while (i < waves) {
            String w = "wave-" + i;
            double hash = Double.parseDouble(cf.getString(String.valueOf(w) + ".hash"));
            ConfigFile scf = cf.getSubConfig(w);
            this.layouts.put(hash, scf);
            ++i;
        }
        this.labelSetting = LabelSetting.fromString(cf.getString("labelSetting"));
        double lon = Double.parseDouble(cf.getString("longitude"));
        double lat = Double.parseDouble(cf.getString("latitude"));
        Point2D.Double c = new Point2D.Double(lon, lat);
        double sc = Double.parseDouble(cf.getString("scale"));
        this.setCenterAndScale(c, sc);
    }

    public void loadMaps(boolean redraw) {
        Pair<GeoImageSet, GeoLabelSet> pair;
        if (Swarm.config.useWMS) {
            WMSGeoImageSet wms = new WMSGeoImageSet();
            wms.setServer(Swarm.config.wmsServer);
            wms.setLayer(Swarm.config.wmsLayer);
            wms.setStyle(Swarm.config.wmsStyles);
            pair = new Pair<WMSGeoImageSet, GeoLabelSet>(wms, new GeoLabelSet());
        } else {
            pair = GeoImageSet.loadMapPacks(Swarm.config.mapPath);
        }
        if (pair != null) {
            this.images = (GeoImageSet)pair.item1;
            this.labels = (GeoLabelSet)pair.item2;
        }
        if (this.images == null) {
            Swarm.logger.warning("No map images found in " + Swarm.config.mapPath + ".");
            this.images = new GeoImageSet();
        }
        this.images.setArealCacheSort(false);
        int mp = (int)Math.round((double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0 / 8.0);
        this.images.setMaxLoadedImagesSize(mp);
        if (redraw) {
            this.resetImage(true);
        }
    }

    private void createUI() {
        this.loadMaps(false);
        this.center = new Point2D.Double(Swarm.config.mapLongitude, Swarm.config.mapLatitude);
        this.scale = Swarm.config.mapScale;
        this.setLayout(new BorderLayout());
        this.pane = new JLayeredPane();
        this.mapImagePanel = new MapImagePanel();
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    int cnt = -e.getWheelRotation();
                    for (MapMiniPanel panel : MapPanel.this.miniPanels.values()) {
                        panel.changeSize(cnt);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                MapPanel.this.parent.setStatusText(" ");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MapPanel.this.clickableLabels != null) {
                    for (ClickableGeoLabel label : MapPanel.this.clickableLabels) {
                        Rectangle r = label.getClickBox();
                        Point2D.Double xy = MapPanel.this.getXY(label.location.x, label.location.y);
                        if (xy == null) continue;
                        r.translate((int)xy.x, (int)xy.y);
                        if (!r.contains(e.getPoint())) continue;
                        label.mouseClicked(e);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MapPanel.this.requestFocusInWindow();
                if (SwingUtilities.isRightMouseButton(e)) {
                    MapPanel.this.mapPush();
                    MapPanel.this.center = MapPanel.this.getLonLat(e.getX(), e.getY());
                    MapPanel.this.resetImage();
                } else {
                    if (MapPanel.this.dragMode == DragMode.DRAG_MAP) {
                        MapPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                    }
                    MapPanel.this.mouseDown = e.getPoint();
                    MapPanel.this.dragRectangle = new Rectangle();
                    MapPanel.this.dragRectangle.setFrameFromDiagonal(MapPanel.this.mouseDown, MapPanel.this.mouseDown);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MapPanel.this.setCursor(Cursor.getPredefinedCursor(1));
                if (MapPanel.this.dragMode == DragMode.DRAG_MAP && MapPanel.this.mouseDown != null && MapPanel.this.mouseNow != null) {
                    MapPanel.this.mapPush();
                    MapPanel.this.dragDX = ((MapPanel)MapPanel.this).mouseDown.x - ((MapPanel)MapPanel.this).mouseNow.x;
                    MapPanel.this.dragDY = ((MapPanel)MapPanel.this).mouseDown.y - ((MapPanel)MapPanel.this).mouseNow.y;
                    MapPanel.this.center = MapPanel.this.getLonLat(MapPanel.this.getWidth() / 2 + MapPanel.this.dragDX, MapPanel.this.getHeight() / 2 + MapPanel.this.dragDY);
                    MapPanel.this.resetImage();
                }
                if (MapPanel.this.dragMode == DragMode.BOX && MapPanel.this.dragRectangle != null) {
                    Point mouseUp = e.getPoint();
                    int x1 = Math.min(mouseUp.x, ((MapPanel)MapPanel.this).mouseDown.x);
                    int x2 = Math.max(mouseUp.x, ((MapPanel)MapPanel.this).mouseDown.x);
                    int y1 = Math.min(mouseUp.y, ((MapPanel)MapPanel.this).mouseDown.y);
                    int y2 = Math.max(mouseUp.y, ((MapPanel)MapPanel.this).mouseDown.y);
                    int dx = x2 - x1;
                    int dy = y2 - y1;
                    if (dx > 3 && dy > 3) {
                        MapPanel.this.mapPush();
                        double xs = (double)dx / (double)(MapPanel.this.getWidth() - 60);
                        double ys = (double)dy / (double)(MapPanel.this.getHeight() - 60);
                        MapPanel mapPanel = MapPanel.this;
                        mapPanel.scale = mapPanel.scale * Math.max(xs, ys);
                        MapPanel.this.center = MapPanel.this.getLonLat((int)Math.round(MapPanel.this.dragRectangle.getCenterX()), (int)Math.round(MapPanel.this.dragRectangle.getCenterY()));
                        MapPanel.this.resetImage();
                    }
                    MapPanel.this.dragRectangle = null;
                }
                MapPanel.this.mouseDown = null;
                MapPanel.this.mouseNow = null;
                MapPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point2D.Double latLon = MapPanel.this.getLonLat(e.getX(), e.getY());
                if (latLon != null) {
                    MapPanel.this.parent.setStatusText(Util.lonLatToString(latLon));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                MapPanel.this.mouseNow = e.getPoint();
                Point2D.Double lonLat = MapPanel.this.getLonLat(e.getX(), e.getY());
                if (MapPanel.this.dragMode == DragMode.DRAG_MAP) {
                    if (SwingUtilities.isLeftMouseButton(e) && MapPanel.this.pane.getComponentCount() != 1) {
                        MapPanel.this.lines.clear();
                        MapPanel.this.pane.removeAll();
                        MapPanel.this.pane.add((Component)MapPanel.this.mapImagePanel, new Integer(10));
                        MapPanel.this.repaint();
                    }
                } else if (MapPanel.this.dragMode == DragMode.BOX) {
                    if (lonLat != null) {
                        MapPanel.this.parent.setStatusText(Util.lonLatToString(lonLat));
                    }
                } else if (MapPanel.this.dragMode == DragMode.RULER) {
                    Point2D.Double origin = MapPanel.this.getLonLat(((MapPanel)MapPanel.this).mouseDown.x, ((MapPanel)MapPanel.this).mouseDown.y);
                    double d = Projection.distanceBetween(origin, lonLat);
                    double az = Projection.azimuthTo(origin, lonLat);
                    String label = "m";
                    if (d > 10000.0) {
                        d /= 1000.0;
                        label = "km";
                    }
                    MapPanel.this.parent.setStatusText(String.format("%s to %s, distance: %.1f %s, azimuth: %.2f%c", Util.lonLatToString(origin), Util.lonLatToString(lonLat), d, label, az, Character.valueOf('\u00b0')));
                }
                MapPanel.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapPanel.this.mapImagePanel.setSize(MapPanel.this.pane.getSize());
                MapPanel.this.resetImage();
                MapPanel.this.repaint();
            }
        });
        Swarm.getApplication().addTimeListener(new TimeListener(){

            @Override
            public void timeChanged(double j2k) {
                for (MapMiniPanel panel : MapPanel.this.miniPanels.values()) {
                    if (panel == null || panel.getWaveViewPanel() == null) continue;
                    panel.getWaveViewPanel().setCursorMark(j2k);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                if (MapPanel.this.allowMultiSelection && e.isControlDown() && e.getKeyCode() == 65) {
                    MapPanel.this.deselectAllPanels();
                    List list = MapPanel.this.visiblePanels;
                    synchronized (list) {
                        for (MapMiniPanel panel : MapPanel.this.visiblePanels) {
                            if (!panel.isWaveVisible()) continue;
                            MapPanel.this.addSelectedPanel(panel);
                        }
                    }
                }
                if (e.isShiftDown() && e.getKeyCode() == 82) {
                    MapPanel.this.resetAllAutoScaleMemory();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.pane.add((Component)this.mapImagePanel, new Integer(10));
        this.add((Component)this.pane, "Center");
        this.loadLabels();
    }

    public void loadLabels() {
        String c = Swarm.config.labelSource;
        if (c == null || c.length() == 0) {
            return;
        }
        try {
            Class<?> cl;
            if (!c.startsWith("nz.org.geonet")) {
                c = "gov.usgs.swarm.map.hypocenters." + c;
            }
            if ((cl = Class.forName(c)) == null) {
                Swarm.logger.log(Level.WARNING, "Can't find labelSource " + cl);
            }
            LabelSource src = (LabelSource)cl.newInstance();
            this.clickableLabels = src.getLabels();
            this.repaint();
        }
        catch (ClassNotFoundException e) {
            Swarm.logger.warning("Can't find class for " + Swarm.config.labelSource);
        }
        catch (Exception e) {
            Swarm.logger.log(Level.WARNING, e.getMessage());
        }
    }

    public Throbber getThrobber() {
        return this.parent.getThrobber();
    }

    public void setStatusText(String t) {
        this.parent.setStatusText(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wavesToClipboard() {
        List<MapMiniPanel> list = this.visiblePanels;
        synchronized (list) {
            WaveClipboardFrame cb = Swarm.getApplication().getWaveClipboard();
            int cnt = 0;
            for (MapMiniPanel panel : this.visiblePanels) {
                if (!panel.isWaveVisible()) continue;
                ++cnt;
                WaveViewPanel p = new WaveViewPanel(panel.getWaveViewPanel());
                SeismicDataSource src = panel.getWaveViewPanel().getDataSource();
                if (src != null) {
                    p.setDataSource(src.getCopy());
                }
                cb.addWave(p);
            }
            if (cnt > 0) {
                cb.setVisible(true);
                this.requestFocus();
            }
        }
    }

    public synchronized void deselectAllPanels() {
        for (MapMiniPanel panel : this.selectedPanels) {
            panel.setSelected(false);
        }
        this.selectedPanels.clear();
    }

    public synchronized void deselectPanel(MapMiniPanel p) {
        if (this.selectedPanels.contains(p)) {
            p.setSelected(false);
            this.selectedPanels.remove(p);
        }
    }

    public synchronized void addSelectedPanel(MapMiniPanel p) {
        if (this.allowMultiSelection) {
            p.setSelected(true);
            this.selectedPanels.add(p);
        } else {
            this.setSelectedPanel(p);
        }
    }

    public synchronized void setSelectedPanel(MapMiniPanel p) {
        this.deselectAllPanels();
        p.setSelected(true);
        this.parent.setSelectedWave(p.getWaveViewPanel());
        this.selectedPanels.add(p);
    }

    public void setDragMode(DragMode mode) {
        this.dragMode = mode;
    }

    public LabelSetting getLabelSetting() {
        return this.labelSetting;
    }

    public void setLabelSetting(LabelSetting ls) {
        this.labelSetting = ls;
        this.resetImage(false);
    }

    public void mapPush() {
        if (this.center != null) {
            this.mapHistory.push(new double[]{this.center.x, this.center.y, this.scale});
        }
    }

    public boolean mapPop() {
        if (!this.mapHistory.isEmpty()) {
            double[] last = this.mapHistory.pop();
            this.center = new Point2D.Double(last[0], last[1]);
            this.scale = last[2];
            this.resetImage();
            return true;
        }
        return false;
    }

    public void timePush() {
        this.timeHistory.push(new double[]{this.startTime, this.endTime});
    }

    public boolean timePop() {
        if (!this.timeHistory.isEmpty()) {
            double[] t = this.timeHistory.pop();
            this.setTimes(t[0], t[1]);
            return true;
        }
        return false;
    }

    public void zoom(double f) {
        this.mapPush();
        this.scale *= f;
        this.resetImage();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void scaleTime(double pct) {
        this.timePush();
        double dt = (this.endTime - this.startTime) * (1.0 - pct);
        double mt = (this.endTime - this.startTime) / 2.0 + this.startTime;
        this.startTime = mt - dt / 2.0;
        this.endTime = mt + dt / 2.0;
        this.setTimes(this.startTime, this.endTime, true);
    }

    public void shiftTime(double pct) {
        this.timePush();
        double dt = (this.endTime - this.startTime) * pct;
        this.startTime += dt;
        this.endTime += dt;
        this.setTimes(this.startTime, this.endTime, true);
    }

    public void gotoTime(double j2k) {
        this.timePush();
        double dt = this.endTime - this.startTime;
        this.startTime = j2k - dt / 2.0;
        this.endTime = j2k + dt / 2.0;
        this.setTimes(this.startTime, this.endTime, true);
    }

    public Point2D.Double getXY(double lon, double lat) {
        if (this.range == null || this.projection == null || this.image == null || this.renderer == null) {
            return null;
        }
        Point2D.Double xy = this.projection.forward(new Point2D.Double(lon, lat));
        double[] ext = this.range.getProjectedExtents(this.projection);
        double dx = ext[1] - ext[0];
        double dy = ext[3] - ext[2];
        Point2D.Double res = new Point2D.Double();
        res.x = (xy.x - ext[0]) / dx * (double)this.renderer.getGraphWidth() + 30.0;
        res.y = (1.0 - (xy.y - ext[2]) / dy) * (double)this.renderer.getGraphHeight() + 30.0;
        return res;
    }

    public Point2D.Double getLonLat(int x, int y) {
        if (this.range == null || this.projection == null || this.renderer == null) {
            return null;
        }
        int tx = x - 30;
        int ty = y - 30;
        double[] ext = this.range.getProjectedExtents(this.projection);
        double dx = (ext[1] - ext[0]) / (double)this.renderer.getGraphWidth();
        double dy = (ext[3] - ext[2]) / (double)this.renderer.getGraphHeight();
        double px = (double)tx * dx + ext[0];
        double py = ext[3] - (double)ty * dy;
        Point2D.Double pt = this.projection.inverse(new Point2D.Double(px, py));
        pt.x %= 360.0;
        if (pt.x > 180.0) {
            pt.x -= 360.0;
        }
        if (pt.x < -180.0) {
            pt.x += 360.0;
        }
        return pt;
    }

    public void setTimes(double st, double et) {
        this.setTimes(st, et, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimes(double st, double et, boolean repaint) {
        this.startTime = st;
        this.endTime = et;
        boolean updated = false;
        List<MapMiniPanel> list = this.visiblePanels;
        synchronized (list) {
            for (MapMiniPanel panel : this.visiblePanels) {
                if (!panel.isWaveVisible()) continue;
                updated = true;
                panel.updateWave(this.startTime, this.endTime, false, repaint);
            }
            if (updated) {
                this.repaint();
            }
        }
    }

    public Point2D.Double getCenter() {
        return this.center;
    }

    public double getScale() {
        return this.scale;
    }

    public void setCenterAndScale(Point2D.Double c, double s) {
        this.center = c;
        this.scale = s;
        this.resetImage();
    }

    public void setCenterAndScale(GeoRange gr) {
        this.mapPush();
        int width = this.mapImagePanel.getWidth() - 60;
        int height = this.mapImagePanel.getHeight() - 60;
        this.center = gr.getCenter();
        TransverseMercator tm = new TransverseMercator();
        tm.setOrigin(this.center);
        this.scale = gr.getScale(tm, width, height) * 1.1;
        if (this.scale > 6000.0) {
            Mercator merc = new Mercator();
            merc.setOrigin(this.center);
            this.scale = gr.getScale(merc, width, height) * 1.1;
        }
        this.resetImage();
    }

    public void pickMapParameters(int width, int height) {
        double xm = this.scale * (double)width;
        double ym = this.scale * (double)height;
        if (xm > 3000000.0) {
            this.projection = new Mercator();
            this.projection.setOrigin(this.center);
            if (xm > Mercator.getMaxWidth()) {
                xm = Mercator.getMaxWidth() * 0.999999;
                this.scale = xm / (double)width;
                ym = this.scale * (double)height;
            }
            this.range = this.projection.getGeoRange(this.center, xm, ym);
        } else {
            TransverseMercator tm = new TransverseMercator();
            tm.setOrigin(this.center);
            this.projection = tm;
            this.range = this.projection.getGeoRange(this.center, xm, ym);
        }
    }

    private Point getLabelPosition(GeneralPath boxes, int x, int y, int w, int h) {
        int[] dxy = new int[]{x + 5, y - 5, x + 5, y, x + 5, y - 10, x - w - 5, y - 5, x - w - 5, y, x - w - 5, y - 10, x + 5, y - 15, x + 5, y + 5, x, y - 15, x, y + 5, x, y - 20, x, y + 10, x - w - 5, y - 15, x - w - 5, y + 5, x, y - 20, x + 40, y + 10, x - w - 40, y - 15};
        int i = 0;
        while (i < dxy.length / 2) {
            Rectangle rect;
            int px = dxy[i * 2];
            int py = dxy[i * 2 + 1];
            if (px >= 0 && py >= 0 && !boxes.intersects(rect = new Rectangle(px, py, w, h))) {
                return new Point(px, py);
            }
            ++i;
        }
        return null;
    }

    public int getMissing() {
        return this.missing;
    }

    public boolean imageValid() {
        return this.mapImage != null;
    }

    public void resetAllAutoScaleMemory() {
        for (MapMiniPanel panel : this.visiblePanels) {
            panel.getWaveViewPanel().resetAutoScaleMemory();
        }
    }

    public void resetImage() {
        this.resetImage(true);
    }

    private void checkLayouts() {
        if (this.layouts.size() == 0) {
            return;
        }
        Set<Double> ks = this.layouts.keySet();
        HashSet<Double> toRemove = new HashSet<Double>();
        for (double hash : ks) {
            MapMiniPanel mmp = this.miniPanels.get(hash);
            if (mmp == null) continue;
            mmp.processLayout(this.layouts.get(hash));
            toRemove.add(hash);
        }
        for (double hash : toRemove) {
            this.layouts.remove(hash);
        }
    }

    private BufferedImage updateMapRenderer() {
        BufferedImage mi = null;
        CodeTimer ct = new CodeTimer("whole map");
        try {
            try {
                Swarm.config.mapScale = this.scale;
                Swarm.config.mapLongitude = this.center.x;
                Swarm.config.mapLatitude = this.center.y;
                this.parent.getThrobber().increment();
                int width = this.mapImagePanel.getWidth() - 60;
                int height = this.mapImagePanel.getHeight() - 60;
                this.pickMapParameters(width, height);
                Swarm.logger.finest("map scale: " + this.scale);
                Swarm.logger.finest("center: " + this.center.x + " " + this.center.y);
                MapRenderer mr = new MapRenderer(this.range, this.projection);
                ct.mark("pre bg");
                this.image = this.images.getMapBackground(this.projection, this.range, width, this.scale);
                ct.mark("bg");
                mr.setLocation(30, 30, width);
                mr.setMapImage(this.image);
                mr.setGeoLabelSet(this.labels);
                mr.createGraticule(6, true);
                mr.createBox(6);
                mr.createScaleRenderer(1.0 / this.projection.getScale(this.center), 30, 14);
                TextRenderer tr = new TextRenderer(this.mapImagePanel.getWidth() - 30, 14.0, String.valueOf(this.projection.getName()) + " Projection");
                tr.antiAlias = false;
                tr.font = new Font("Arial", 0, 10);
                tr.horizJustification = 3;
                mr.addRenderer(tr);
                this.renderer = mr;
                Plot plot = new Plot();
                plot.setSize(this.mapImagePanel.getWidth(), this.mapImagePanel.getHeight());
                plot.addRenderer(this.renderer);
                ct.mark("pre plot");
                mi = plot.getAsBufferedImage(false);
                ct.mark("plot");
                this.dragDX = Integer.MAX_VALUE;
                this.dragDY = Integer.MAX_VALUE;
                ct.stop();
            }
            catch (Exception e) {
                Swarm.logger.log(Level.SEVERE, "Exception during map creation.", e);
                this.parent.getThrobber().decrement();
            }
        }
        finally {
            this.parent.getThrobber().decrement();
        }
        return mi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<List<JComponent>, List<Line2D.Double>> updateMiniPanels() {
        Map<String, Metadata> allMetadata;
        ArrayList<JComponent> compsToAdd = new ArrayList<JComponent>();
        ArrayList<Line2D.Double> linesToAdd = new ArrayList<Line2D.Double>();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        GeneralPath boxes = new GeneralPath();
        this.missing = 0;
        Map<String, Metadata> map = allMetadata = Swarm.config.getMetadata();
        synchronized (map) {
            for (MapMiniPanel panel : this.miniPanels.values()) {
                if (panel.getPosition() == MapMiniPanel.Position.MANUAL_SET) {
                    panel.setPosition(MapMiniPanel.Position.MANUAL_UNSET);
                    continue;
                }
                panel.setPosition(MapMiniPanel.Position.UNSET);
            }
            for (Metadata md : allMetadata.values()) {
                if (!this.range.contains(new Point2D.Double(md.getLongitude(), md.getLatitude()))) {
                    MapMiniPanel mmp = this.miniPanels.get(md.getLocationHashCode());
                    if (mmp == null) continue;
                    this.miniPanels.remove(md.getLocationHashCode());
                    this.deselectPanel(mmp);
                    continue;
                }
                MapMiniPanel cmp = this.miniPanels.get(md.getLocationHashCode());
                Point2D.Double xy = this.getXY(md.getLongitude(), md.getLatitude());
                if (xy == null) continue;
                int iconX = (int)xy.x - 8;
                int iconY = (int)xy.y - 8;
                if (cmp == null || cmp.getPosition() == MapMiniPanel.Position.UNSET || cmp.getPosition() == MapMiniPanel.Position.MANUAL_UNSET) {
                    JLabel icon = new JLabel(Images.getIcon("bullet"));
                    icon.setBounds(iconX, iconY, 16, 16);
                    compsToAdd.add(icon);
                    if (cmp == null) {
                        cmp = new MapMiniPanel(this);
                    }
                }
                if (cmp.getPosition() == MapMiniPanel.Position.UNSET || cmp.getPosition() == MapMiniPanel.Position.MANUAL_UNSET) {
                    if (this.labelSetting == LabelSetting.NONE && !this.layouts.containsKey(md.getLocationHashCode()) && (cmp.getPosition() == MapMiniPanel.Position.UNSET || cmp.getPosition() == MapMiniPanel.Position.MANUAL_UNSET && !cmp.isWaveVisible())) continue;
                    int w = (int)Math.round(MapMiniPanel.FONT.getStringBounds(String.valueOf(md.getSCNL().station) + 6, frc).getWidth());
                    int locX = (int)xy.x;
                    int locY = (int)xy.y;
                    Point pt = null;
                    if (cmp.getPosition() == MapMiniPanel.Position.MANUAL_UNSET) {
                        Point2D.Double mp;
                        Point2D.Double xy2 = mp = cmp.getManualPosition();
                        locX = (int)xy2.x;
                        locY = (int)xy2.y;
                        cmp.setPosition(MapMiniPanel.Position.MANUAL_SET);
                        pt = new Point(locX, locY);
                    } else {
                        pt = this.getLabelPosition(boxes, locX, locY, w, 13);
                    }
                    if (pt == null && this.labelSetting == LabelSetting.ALL) {
                        pt = new Point(locX, locY);
                    }
                    if (pt != null) {
                        locX = pt.x;
                        locY = pt.y;
                        boxes.append(new Rectangle(locX, locY, w, 13), false);
                        cmp.setLocation(locX, locY);
                        if (cmp.getPosition() == MapMiniPanel.Position.UNSET) {
                            cmp.setPosition(MapMiniPanel.Position.AUTOMATIC);
                        }
                        Line2D.Double line = new Line2D.Double(locX, locY, iconX + 8, iconY + 8);
                        cmp.setLine(line);
                        cmp.adjustLine();
                        linesToAdd.add(line);
                        compsToAdd.add(cmp);
                        this.miniPanels.put(md.getLocationHashCode(), cmp);
                    } else {
                        ++this.missing;
                        cmp.setPosition(MapMiniPanel.Position.HIDDEN);
                    }
                }
                cmp.addMetadata(md);
            }
        }
        return new Pair<List<JComponent>, List<Line2D.Double>>(compsToAdd, linesToAdd);
    }

    public void resetImage(final boolean doMap) {
        if (!this.parent.isVisible() || this.mapImagePanel.getHeight() == 0 || this.mapImagePanel.getWidth() == 0) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            private List<JComponent> compsToAdd;
            private List<Line2D.Double> linesToAdd;
            private BufferedImage tempMapImage;

            @Override
            public Object construct() {
                try {
                    MapPanel.this.lock.acquire();
                }
                catch (InterruptedException ex) {
                    return new Boolean(false);
                }
                if (MapPanel.this.lock.hasQueuedThreads()) {
                    return new Boolean(false);
                }
                if (doMap) {
                    this.tempMapImage = MapPanel.this.updateMapRenderer();
                }
                return new Boolean(true);
            }

            @Override
            public void finished() {
                if (this.tempMapImage != null) {
                    MapPanel.this.mapImage = this.tempMapImage;
                }
                if (((Boolean)this.get()).booleanValue() && !MapPanel.this.lock.hasQueuedThreads()) {
                    Pair p = MapPanel.this.updateMiniPanels();
                    this.compsToAdd = (List)p.item1;
                    this.linesToAdd = (List)p.item2;
                    if (MapPanel.this.lines != null) {
                        MapPanel.this.lines.clear();
                    }
                    MapPanel.this.pane.removeAll();
                    MapPanel.this.pane.add((Component)MapPanel.this.mapImagePanel, new Integer(10));
                    MapPanel.this.visiblePanels.clear();
                    for (MapMiniPanel mp : MapPanel.this.miniPanels.values()) {
                        MapPanel.this.visiblePanels.add(mp);
                    }
                    MapPanel.this.pane.removeAll();
                    MapPanel.this.pane.add((Component)MapPanel.this.mapImagePanel, new Integer(10));
                    int i = 0;
                    if (this.compsToAdd != null) {
                        for (JComponent comp : this.compsToAdd) {
                            if (comp instanceof JLabel) {
                                MapPanel.this.pane.add((Component)comp, new Integer(15));
                                continue;
                            }
                            ++i;
                            MapPanel.this.pane.add((Component)comp, new Integer(20));
                        }
                    }
                    MapPanel.this.lines = this.linesToAdd;
                    MapPanel.this.parent.setStatusText(" ");
                    MapPanel.this.checkLayouts();
                    MapPanel.this.repaint();
                }
                MapPanel.this.lock.release();
            }
        };
        worker.start();
    }

    public static enum DragMode {
        DRAG_MAP,
        BOX,
        RULER;

    }

    public static enum LabelSetting {
        NONE("N", "label_none"),
        SOME("S", "label_some"),
        ALL("A", "label_all");

        public String code;
        public String image;

        private LabelSetting(String s, String i) {
            this.code = s;
            this.image = i;
        }

        public LabelSetting next() {
            switch (this) {
                case SOME: {
                    return ALL;
                }
                case ALL: {
                    return NONE;
                }
            }
            return SOME;
        }

        public Icon getIcon() {
            return Images.getIcon(this.image);
        }

        public static LabelSetting fromString(String s) {
            if (s == null) {
                return SOME;
            }
            if (s.equals("N")) {
                return NONE;
            }
            if (s.equals("A")) {
                return ALL;
            }
            if (s.equals("S")) {
                return SOME;
            }
            return SOME;
        }
    }

    private class MapImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private MapImagePanel() {
        }

        private void paintRadius(Graphics2D g2) {
            Point2D.Double lonLat = MapPanel.this.getLonLat(((MapPanel)MapPanel.this).mouseNow.x, ((MapPanel)MapPanel.this).mouseNow.y);
            Point2D.Double origin = MapPanel.this.getLonLat(((MapPanel)MapPanel.this).mouseDown.x, ((MapPanel)MapPanel.this).mouseDown.y);
            double d = Projection.distanceBetween(origin, lonLat);
            int n = 720;
            Point2D.Double[] pts = Projection.getPointsFrom(origin, d, n);
            GeneralPath gp = new GeneralPath();
            Point2D.Double xy = MapPanel.this.getXY(pts[0].x, pts[0].y);
            Point lastXY = new Point();
            lastXY.x = (int)Math.round(xy.x);
            lastXY.y = (int)Math.round(xy.y);
            gp.moveTo(lastXY.x - 2, lastXY.y - 1);
            int i = 1;
            while (i <= pts.length) {
                xy = MapPanel.this.getXY(pts[i % n].x, pts[i % n].y);
                Point thisXY = new Point();
                thisXY.x = (int)Math.round(xy.x);
                thisXY.y = (int)Math.round(xy.y);
                double a = thisXY.x - lastXY.x;
                double b = thisXY.y - lastXY.y;
                double dist = Math.sqrt(a * a + b * b);
                if (dist > 100.0) {
                    gp.moveTo(thisXY.x - 2, thisXY.y - 1);
                } else {
                    gp.lineTo(thisXY.x - 2, thisXY.y - 1);
                }
                lastXY = thisXY;
                ++i;
            }
            g2.setColor(Color.YELLOW);
            g2.draw(gp);
        }

        private void paintGreatCircleRoute(Graphics2D g2) {
            Point2D.Double lonLat = MapPanel.this.getLonLat(((MapPanel)MapPanel.this).mouseNow.x, ((MapPanel)MapPanel.this).mouseNow.y);
            Point2D.Double origin = MapPanel.this.getLonLat(((MapPanel)MapPanel.this).mouseDown.x, ((MapPanel)MapPanel.this).mouseDown.y);
            GeneralPath gp = new GeneralPath();
            Point2D.Double xy = MapPanel.this.getXY(origin.x, origin.y);
            Point lastXY = new Point();
            lastXY.x = (int)Math.round(xy.x);
            lastXY.y = (int)Math.round(xy.y);
            gp.moveTo(lastXY.x - 2, lastXY.y - 1);
            double d = Projection.distanceBetween(origin, lonLat);
            while (d > 20000.0) {
                double az = Projection.azimuthTo(origin, lonLat);
                Point2D.Double p0 = Projection.getPointFrom(origin, 20000.0, az);
                xy = MapPanel.this.getXY(p0.x, p0.y);
                Point thisXY = new Point();
                thisXY.x = (int)Math.round(xy.x);
                thisXY.y = (int)Math.round(xy.y);
                double a = thisXY.x - lastXY.x;
                double b = thisXY.y - lastXY.y;
                double dist = Math.sqrt(a * a + b * b);
                if (dist > 100.0) {
                    gp.moveTo(thisXY.x - 2, thisXY.y - 1);
                } else {
                    gp.lineTo(thisXY.x - 2, thisXY.y - 1);
                }
                lastXY = thisXY;
                origin = p0;
                d = Projection.distanceBetween(origin, lonLat);
            }
            g2.setColor(Color.GREEN);
            g2.draw(gp);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (MapPanel.this.renderer == null || MapPanel.this.mapImage == null) {
                Dimension d = this.getSize();
                g.drawString("Loading map...", d.width / 2 - 50, d.height / 2);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                int dx = 0;
                int dy = 0;
                if (MapPanel.this.dragMode == DragMode.DRAG_MAP && MapPanel.this.mouseDown != null && MapPanel.this.mouseNow != null) {
                    dx = ((MapPanel)MapPanel.this).mouseDown.x - ((MapPanel)MapPanel.this).mouseNow.x;
                    dy = ((MapPanel)MapPanel.this).mouseDown.y - ((MapPanel)MapPanel.this).mouseNow.y;
                    g2.drawImage((Image)MapPanel.this.mapImage, -dx, -dy, null);
                } else if (MapPanel.this.dragDX != Integer.MAX_VALUE && MapPanel.this.dragDY != Integer.MAX_VALUE) {
                    g2.drawImage((Image)MapPanel.this.mapImage, -MapPanel.this.dragDX, -MapPanel.this.dragDY, null);
                } else {
                    g2.drawImage((Image)MapPanel.this.mapImage, 0, 0, null);
                }
                g.setXORMode(Color.WHITE);
                if (MapPanel.this.lines != null) {
                    for (Line2D.Double line : MapPanel.this.lines) {
                        g2.draw(line);
                    }
                }
                g.setPaintMode();
                g.setColor(Color.RED);
                if (MapPanel.this.dragRectangle != null) {
                    if (MapPanel.this.dragMode == DragMode.BOX && MapPanel.this.mouseNow != null) {
                        MapPanel.this.dragRectangle.setFrameFromDiagonal(MapPanel.this.mouseDown, MapPanel.this.mouseNow);
                        g2.draw(MapPanel.this.dragRectangle);
                    } else if (MapPanel.this.dragMode == DragMode.RULER && MapPanel.this.mouseDown != null && MapPanel.this.mouseNow != null) {
                        g2.drawLine(((MapPanel)MapPanel.this).mouseDown.x - MapPanel.this.getInsets().left, ((MapPanel)MapPanel.this).mouseDown.y - MapPanel.this.getInsets().top, ((MapPanel)MapPanel.this).mouseNow.x - MapPanel.this.getInsets().left, ((MapPanel)MapPanel.this).mouseNow.y - MapPanel.this.getInsets().top);
                        this.paintRadius(g2);
                        this.paintGreatCircleRoute(g2);
                    }
                }
                Object oldaa = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                AffineTransform at = g2.getTransform();
                g2.setFont(Font.decode("dialog-plain-12"));
                if (MapPanel.this.clickableLabels != null) {
                    for (ClickableGeoLabel label : MapPanel.this.clickableLabels) {
                        Point2D.Double xy = MapPanel.this.getXY(label.location.x, label.location.y);
                        if (xy == null) continue;
                        g2.translate(xy.x - (double)dx, xy.y - (double)dy);
                        label.draw(g2);
                        g2.translate(-xy.x + (double)dx, -xy.y + (double)dy);
                    }
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldaa);
                g2.setTransform(at);
            }
        }
    }
}

