/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.map.hypocenters.NEIC;

import gov.usgs.swarm.map.ClickableGeoLabel;
import gov.usgs.swarm.map.Hypocenter;
import gov.usgs.swarm.map.LabelSource;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Time;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class NEICHypocenters
implements LabelSource {
    public String URL;

    @Override
    public List<? extends ClickableGeoLabel> getLabels() {
        ResourceReader rr = ResourceReader.getResourceReader(this.URL);
        ArrayList<Hypocenter> hypos = new ArrayList<Hypocenter>();
        try {
            String s = rr.nextLine();
            s = rr.nextLine();
            while (s != null) {
                Hypocenter h = new Hypocenter();
                String[] f = s.split(",");
                String d = String.valueOf(f[4]) + "," + f[5];
                d = d.substring(0, d.length() - 1).trim();
                String dateFmt = "MMMM dd, yyyy hh:mm:ss z";
                h.time = Time.parse(dateFmt, d);
                hypos.add(h);
                double lat = Double.parseDouble(f[6]);
                double lon = Double.parseDouble(f[7]);
                h.location = new Point2D.Double(lon, lat);
                h.text = "M" + f[8];
                h.depth = Double.parseDouble(f[9]);
                hypos.add(h);
                s = rr.nextLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hypos;
    }

    public static void main(String[] args) {
        List<? extends ClickableGeoLabel> clickableLabels = new NEICHypocenters().getLabels();
        System.out.println("Got " + clickableLabels.size() + " events");
        for (ClickableGeoLabel clickableGeoLabel : clickableLabels) {
            System.out.println(String.valueOf(clickableGeoLabel.text) + " " + clickableGeoLabel.location.x + "," + clickableGeoLabel.location.y);
        }
    }
}

