/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import gov.usgs.math.Filter;
import gov.usgs.plot.FrameDecorator;
import gov.usgs.plot.Plot;
import gov.usgs.plot.TextRenderer;
import gov.usgs.swarm.Images;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.wave.WaveViewPanelListener;
import gov.usgs.swarm.wave.WaveViewSettings;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.SliceWave;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.vdx.data.wave.plot.SliceWaveRenderer;
import gov.usgs.vdx.data.wave.plot.SpectraRenderer;
import gov.usgs.vdx.data.wave.plot.SpectrogramRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class WaveViewPanel
extends JComponent {
    public static final long serialVersionUID = -1L;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private int xOffset = 60;
    private int yOffset = 20;
    private int rightWidth = 20;
    private int bottomHeight = 20;
    private FrameDecorator decorator;
    private SliceWaveRenderer waveRenderer;
    private SpectrogramRenderer spectrogramRenderer;
    private SpectraRenderer spectraRenderer;
    private Wave wave;
    private double startTime;
    private double endTime;
    private WaveViewSettings settings;
    private int bias;
    private double minAmp = 1.0E300;
    private double maxAmp = -1.0E300;
    private double maxSpectraPower = -1.0E300;
    private double maxSpectrogramPower = -1.0E300;
    private double[] translation;
    private boolean timeSeries;
    private String channel;
    private static boolean shownNyquistWarning = false;
    private SeismicDataSource source;
    private boolean displayTitle;
    private Color backgroundColor;
    private Color bottomBorderColor;
    private JLabel statusLabel;
    private boolean allowDragging;
    private boolean dragging;
    private double j2k1;
    private double j2k2;
    private int highlightX1;
    private int highlightX2;
    private static Image closeImg;
    private boolean allowClose;
    private EventListenerList listeners = new EventListenerList();
    private boolean working;
    private BufferedImage image;
    private double mark1 = Double.NaN;
    private double mark2 = Double.NaN;
    private double cursorMark = Double.NaN;
    private boolean useFilterLabel = true;
    private Color borderColor;
    private static final Color DARK_RED;
    private static final Color DARK_GREEN;

    static {
        DARK_RED = new Color(168, 0, 0);
        DARK_GREEN = new Color(0, 168, 0);
    }

    public WaveViewPanel() {
        this(new WaveViewSettings());
    }

    public WaveViewPanel(WaveViewSettings s) {
        this.settings = s;
        s.view = this;
        this.backgroundColor = new Color(247, 247, 247);
        this.setupMouseHandler();
    }

    public WaveViewPanel(WaveViewPanel p) {
        this.channel = p.channel;
        this.source = p.source;
        this.startTime = p.startTime;
        this.endTime = p.endTime;
        this.bias = p.bias;
        this.maxSpectraPower = p.maxSpectraPower;
        this.maxSpectrogramPower = p.maxSpectrogramPower;
        this.translation = new double[8];
        if (p.translation != null) {
            System.arraycopy(p.translation, 0, this.translation, 0, 8);
        }
        this.timeSeries = p.timeSeries;
        this.allowDragging = p.allowDragging;
        this.settings = new WaveViewSettings(p.settings);
        this.settings.view = this;
        this.wave = p.wave;
        this.displayTitle = p.displayTitle;
        this.backgroundColor = p.backgroundColor;
        this.setupMouseHandler();
        this.processSettings();
    }

    public void setOffsets(int xo, int yo, int rw, int bh) {
        this.xOffset = xo;
        this.yOffset = yo;
        this.rightWidth = rw;
        this.bottomHeight = bh;
    }

    public void addListener(WaveViewPanelListener listener) {
        this.listeners.add(WaveViewPanelListener.class, listener);
    }

    public void removeListener(WaveViewPanelListener listener) {
        this.listeners.remove(WaveViewPanelListener.class, listener);
    }

    public void fireZoomed(MouseEvent e, double oldST, double oldET, double newST, double newET) {
        Object[] ls = this.listeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == WaveViewPanelListener.class) {
                ((WaveViewPanelListener)ls[i + 1]).waveZoomed(this, oldST, oldET, newST, newET);
            }
            i -= 2;
        }
    }

    public void fireTimePressed(MouseEvent e, double j2k) {
        Object[] ls = this.listeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == WaveViewPanelListener.class) {
                ((WaveViewPanelListener)ls[i + 1]).waveTimePressed(this, e, j2k);
            }
            i -= 2;
        }
    }

    public void fireMousePressed(MouseEvent e) {
        Object[] ls = this.listeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == WaveViewPanelListener.class) {
                ((WaveViewPanelListener)ls[i + 1]).mousePressed(this, e, this.dragging);
            }
            i -= 2;
        }
    }

    public void fireClose() {
        Object[] ls = this.listeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == WaveViewPanelListener.class) {
                ((WaveViewPanelListener)ls[i + 1]).waveClosed(this);
            }
            i -= 2;
        }
    }

    public void setAllowClose(boolean b) {
        this.allowClose = b;
    }

    private void setupMouseHandler() {
        Cursor crosshair = new Cursor(1);
        this.setCursor(crosshair);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Swarm.getApplication().touchUITime();
                double[] t = WaveViewPanel.this.getTranslation();
                if (t != null) {
                    int x = e.getX();
                    double j2k = (double)x * t[0] + t[1];
                    if (WaveViewPanel.this.timeSeries) {
                        Swarm.logger.fine(String.format("%s UTC: %s j2k: %.3f ew: %.3f\n", WaveViewPanel.this.channel, Time.format(WaveViewPanel.DATE_FORMAT, Util.j2KToDate(j2k)), j2k, Util.j2KToEW(j2k)));
                    }
                    if (SwingUtilities.isRightMouseButton(e)) {
                        WaveViewPanel.this.settings.cycleType();
                    }
                    if (WaveViewPanel.this.timeSeries && j2k >= WaveViewPanel.this.startTime && j2k <= WaveViewPanel.this.endTime) {
                        WaveViewPanel.this.fireTimePressed(e, j2k);
                    }
                    if (WaveViewPanel.this.timeSeries && WaveViewPanel.this.allowDragging && SwingUtilities.isLeftMouseButton(e)) {
                        Dimension size = WaveViewPanel.this.getSize();
                        int y = e.getY();
                        if (t != null && y > WaveViewPanel.this.yOffset && y < size.height - WaveViewPanel.this.bottomHeight && x > WaveViewPanel.this.xOffset && x < size.width - WaveViewPanel.this.rightWidth) {
                            double d = j2k;
                            WaveViewPanel.this.j2k2 = d;
                            WaveViewPanel.this.j2k1 = d;
                            if (e.isControlDown()) {
                                System.out.println(String.valueOf(WaveViewPanel.this.channel) + ": " + Time.format(WaveViewPanel.DATE_FORMAT, Util.j2KToDate(WaveViewPanel.this.j2k1)));
                            } else if (!e.isShiftDown()) {
                                int n = x;
                                WaveViewPanel.this.highlightX2 = n;
                                WaveViewPanel.this.highlightX1 = n;
                                WaveViewPanel.this.dragging = true;
                            }
                        }
                    }
                }
                WaveViewPanel.this.fireMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Swarm.getApplication().touchUITime();
                if (SwingUtilities.isLeftMouseButton(e) && WaveViewPanel.this.dragging) {
                    WaveViewPanel.this.dragging = false;
                    if (WaveViewPanel.this.j2k1 != WaveViewPanel.this.j2k2 && WaveViewPanel.this.source != null) {
                        double st = Math.min(WaveViewPanel.this.j2k1, WaveViewPanel.this.j2k2);
                        double et = Math.max(WaveViewPanel.this.j2k1, WaveViewPanel.this.j2k2);
                        WaveViewPanel.this.zoom(st, et);
                        WaveViewPanel.this.fireZoomed(e, WaveViewPanel.this.getStartTime(), WaveViewPanel.this.getEndTime(), st, et);
                    }
                    WaveViewPanel.this.repaint();
                }
                int mx = e.getX();
                int my = e.getY();
                if (WaveViewPanel.this.allowClose && SwingUtilities.isLeftMouseButton(e) && mx > WaveViewPanel.this.getWidth() - 17 && mx < WaveViewPanel.this.getWidth() - 3 && my > 2 && my < 17) {
                    WaveViewPanel.this.fireClose();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Swarm.getApplication().fireTimeChanged(Double.NaN);
                WaveViewPanel.this.dragging = false;
                WaveViewPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Swarm.getApplication().touchUITime();
                WaveViewPanel.this.processMousePosition(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Swarm.getApplication().touchUITime();
                WaveViewPanel.this.processMousePosition(e.getX(), e.getY());
                if (SwingUtilities.isLeftMouseButton(e) && !e.isControlDown() && WaveViewPanel.this.dragging) {
                    double[] t = WaveViewPanel.this.getTranslation();
                    int x = e.getX();
                    int y = e.getY();
                    Dimension size = WaveViewPanel.this.getSize();
                    if (t != null && y > WaveViewPanel.this.yOffset && y < size.height - WaveViewPanel.this.bottomHeight && x > WaveViewPanel.this.xOffset && x < size.width - WaveViewPanel.this.rightWidth) {
                        WaveViewPanel.this.j2k2 = (double)x * t[0] + t[1];
                        WaveViewPanel.this.highlightX2 = x;
                        WaveViewPanel.this.repaint();
                    }
                }
            }
        });
    }

    public void zoom(final double st, final double et) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Wave sw = null;
                sw = WaveViewPanel.this.source instanceof CachedDataSource ? ((CachedDataSource)WaveViewPanel.this.source).getBestWave(WaveViewPanel.this.channel, st, et) : WaveViewPanel.this.source.getWave(WaveViewPanel.this.channel, st, et);
                WaveViewPanel.this.setWave(sw, st, et);
                return null;
            }

            @Override
            public void finished() {
                WaveViewPanel.this.repaint();
            }
        };
        worker.start();
    }

    public void setWorking(boolean b) {
        this.working = b;
    }

    public void setAllowDragging(boolean b) {
        this.allowDragging = b;
    }

    public void setStatusLabel(JLabel l) {
        this.statusLabel = l;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public WaveViewSettings getSettings() {
        return this.settings;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public Wave getWave() {
        return this.wave;
    }

    public WaveViewSettings getWaveViewSettings() {
        return this.settings;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String c) {
        this.channel = c;
    }

    public void setSettings(WaveViewSettings s) {
        this.settings = s;
        this.processSettings();
    }

    public SeismicDataSource getDataSource() {
        return this.source;
    }

    public void setDataSource(SeismicDataSource s) {
        this.source = s;
    }

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void setDisplayTitle(boolean b) {
        this.displayTitle = b;
    }

    public void settingsChanged() {
        this.processSettings();
    }

    public boolean isTimeSeries() {
        return this.timeSeries;
    }

    public double[] getTranslation() {
        return this.translation;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public void setBottomBorderColor(Color c) {
        this.bottomBorderColor = c;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public boolean processMousePosition(int x, int y) {
        String status = null;
        Dimension size = this.getSize();
        double[] t = this.getTranslation();
        double j2k = Double.NaN;
        if (t != null && y > this.yOffset && y < size.height - this.bottomHeight && x > this.xOffset && x < size.width - this.rightWidth) {
            j2k = (double)x * t[0] + t[1];
            double yi = (double)y * -t[2] + t[3];
            if (this.timeSeries) {
                String utc = Time.format(DATE_FORMAT, Util.j2KToDate(j2k));
                TimeZone tz = Swarm.config.getTimeZone(this.channel);
                double tzo = Time.getTimeZoneOffset(tz, j2k);
                if (tzo != 0.0) {
                    String tza = tz.getDisplayName(tz.inDaylightTime(Util.j2KToDate(j2k)), 0);
                    status = String.valueOf(Time.format(DATE_FORMAT, Util.j2KToDate(j2k + tzo))) + " (" + tza + "), " + utc + " (UTC)";
                } else {
                    status = utc;
                }
                double offset = 0.0;
                double multiplier = 1.0;
                Metadata md = Swarm.config.getMetadata(this.channel);
                if (md != null) {
                    offset = md.getOffset();
                    multiplier = md.getMultiplier();
                }
                status = String.format("%s, Y: %.3f", status, multiplier * yi + offset);
            } else {
                double xi = j2k;
                if (this.settings.viewType == WaveViewSettings.ViewType.SPECTRA && this.settings.logFreq) {
                    xi = Math.pow(10.0, xi);
                }
                if (this.settings.viewType == WaveViewSettings.ViewType.SPECTRA && this.settings.logPower) {
                    yi = Math.pow(10.0, yi);
                }
                status = String.format("X: %.3f, Y: %.3f", xi, yi);
            }
        } else {
            status = " ";
        }
        Swarm.getApplication().fireTimeChanged(j2k);
        if (status == null) {
            status = " ";
        }
        if (!Double.isNaN(this.mark1) && !Double.isNaN(this.mark2)) {
            double dur = Math.abs(this.mark1 - this.mark2);
            String pre = String.format("Duration: %.2fs (Md: %.2f)", dur, Swarm.config.getDurationMagnitude(dur));
            status = status.length() > 2 ? String.valueOf(pre) + ", " + status : pre;
        }
        if (status != null && this.statusLabel != null) {
            final String st = status;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaveViewPanel.this.statusLabel.setText(st);
                }
            });
        }
        return !status.equals(" ");
    }

    public void setWave(Wave sw, double st, double et) {
        this.wave = sw;
        this.startTime = st;
        this.endTime = et;
        this.processSettings();
    }

    public void resetAutoScaleMemory() {
        this.minAmp = 1.0E300;
        this.maxAmp = -1.0E300;
        this.maxSpectraPower = -1.0E300;
        this.maxSpectrogramPower = -1.0E300;
        this.settings.autoScaleAmp = true;
        this.settings.autoScalePower = true;
        this.processSettings();
    }

    public void adjustScale(double pct) {
        double maxa = this.settings.autoScaleAmp ? this.maxAmp : this.settings.maxAmp;
        double mina = this.settings.autoScaleAmp ? this.minAmp : this.settings.minAmp;
        this.settings.autoScaleAmp = false;
        double range = maxa - mina;
        double center = range / 2.0 + mina;
        double newRange = range * pct;
        this.settings.minAmp = center - newRange / 2.0;
        this.settings.maxAmp = center + newRange / 2.0;
        this.processSettings();
    }

    private synchronized void setImage(BufferedImage bi) {
        this.image = bi;
    }

    private synchronized BufferedImage getImage() {
        return this.image;
    }

    public void createImage() {
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                if (WaveViewPanel.this.getWidth() > 0 && WaveViewPanel.this.getHeight() > 0) {
                    BufferedImage bi = new BufferedImage(WaveViewPanel.this.getWidth(), WaveViewPanel.this.getHeight(), 6);
                    Graphics2D ig = (Graphics2D)bi.getGraphics();
                    WaveViewPanel.this.constructPlot(ig);
                    WaveViewPanel.this.setImage(bi);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    r.run();
                    return null;
                }

                @Override
                public void finished() {
                    WaveViewPanel.this.repaint();
                }
            };
            worker.start();
        } else {
            r.run();
        }
    }

    private void processSettings() {
        if (this.wave == null || this.wave.buffer == null || this.wave.buffer.length == 0) {
            return;
        }
        if (this.settings.maxFreq > this.wave.getSamplingRate() / 2.0) {
            if (!shownNyquistWarning) {
                JOptionPane.showMessageDialog(Swarm.getApplication(), "The maximum frequency was set too high and has been automatically adjusted to the Nyquist frequency. This window will not be shown again.", "Warning", 2);
            }
            this.settings.maxFreq = this.wave.getSamplingRate() / 2.0;
            shownNyquistWarning = true;
        }
        this.timeSeries = this.settings.viewType != WaveViewSettings.ViewType.SPECTRA;
        this.createImage();
    }

    private void filter(Wave w) {
        double mean = w.mean();
        double[] dBuf = new double[w.buffer.length + (int)((double)w.buffer.length * 0.5)];
        Arrays.fill(dBuf, mean);
        int trueStart = (int)((double)w.buffer.length * 0.25);
        int i = 0;
        while (i < w.buffer.length) {
            if (w.buffer[i] != Wave.NO_DATA) {
                dBuf[i + trueStart] = w.buffer[i];
            }
            ++i;
        }
        this.settings.filter.setSamplingRate(w.getSamplingRate());
        this.settings.filter.create();
        Filter.filter(dBuf, this.settings.filter.getSize(), this.settings.filter.getXCoeffs(), this.settings.filter.getYCoeffs(), this.settings.filter.getGain(), 0.0, 0.0);
        if (this.settings.zeroPhaseShift) {
            double[] dBuf2 = new double[dBuf.length];
            int i2 = 0;
            int j = dBuf.length - 1;
            while (i2 < dBuf.length) {
                dBuf2[j] = dBuf[i2];
                ++i2;
                --j;
            }
            Filter.filter(dBuf2, this.settings.filter.getSize(), this.settings.filter.getXCoeffs(), this.settings.filter.getYCoeffs(), this.settings.filter.getGain(), 0.0, 0.0);
            i2 = 0;
            j = dBuf2.length - 1 - trueStart;
            while (i2 < w.buffer.length) {
                w.buffer[i2] = (int)Math.round(dBuf2[j]);
                ++i2;
                --j;
            }
        } else {
            i = 0;
            while (i < w.buffer.length) {
                w.buffer[i] = (int)Math.round(dBuf[i + trueStart]);
                ++i;
            }
        }
        w.invalidateStatistics();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        if (this.wave == null) {
            g2.setColor(this.backgroundColor);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
            if (this.working) {
                g2.drawString("Retrieving data...", dim.width / 2 - 50, dim.height / 2);
            } else {
                String error = "No wave data.";
                if (this.channel != null) {
                    error = "No wave data for " + this.channel + ".";
                }
                int w = g2.getFontMetrics().stringWidth(error);
                g2.drawString(error, dim.width / 2 - w / 2, dim.height / 2);
            }
        } else {
            BufferedImage bi = this.getImage();
            if (bi != null) {
                g2.drawImage((Image)bi, 0, 0, null);
            }
            if (this.dragging) {
                this.paintDragBox(g2);
            }
            if (!Double.isNaN(this.mark1)) {
                this.paintMark(g2, this.mark1);
            }
            if (!Double.isNaN(this.mark2)) {
                this.paintMark(g2, this.mark2);
            }
            if (!Double.isNaN(this.cursorMark)) {
                this.paintCursor(g2);
            }
        }
        if (this.allowClose) {
            if (closeImg == null) {
                closeImg = Images.getIcon("close_view").getImage();
            }
            g2.drawImage(closeImg, dim.width - 17, 3, null);
        }
        if (this.bottomBorderColor != null) {
            g2.setColor(this.bottomBorderColor);
            g2.drawLine(0, dim.height - 1, dim.width, dim.height - 1);
        }
        if (this.borderColor != null) {
            g2.setColor(this.borderColor);
            g2.drawRect(0, 0, dim.width - 1, dim.height - 2);
        }
    }

    public void setUseFilterLabel(boolean b) {
        this.useFilterLabel = b;
    }

    public TextRenderer getFilterLabel() {
        String ft = "";
        switch (this.settings.filter.getType()) {
            case BANDPASS: {
                ft = "Band pass [" + this.settings.filter.getCorner1() + "-" + this.settings.filter.getCorner2() + " Hz]";
                break;
            }
            case HIGHPASS: {
                ft = "High pass [" + this.settings.filter.getCorner1() + " Hz]";
                break;
            }
            case LOWPASS: {
                ft = "Low pass [" + this.settings.filter.getCorner1() + " Hz]";
            }
        }
        TextRenderer tr = new TextRenderer(this.xOffset + 5, 148.0, ft);
        tr.color = Color.red;
        return tr;
    }

    private synchronized void constructPlot(Graphics2D g2) {
        Dimension dim = this.getSize();
        Plot plot = new Plot();
        plot.setBackgroundColor(this.backgroundColor);
        plot.setSize(dim);
        Wave renderWave = this.wave;
        if (this.settings.filterOn) {
            renderWave = new Wave(this.wave);
            this.filter(renderWave);
            if (this.settings.removeBias) {
                this.bias = (int)Math.round(renderWave.mean());
            }
        }
        switch (this.settings.viewType) {
            case WAVE: {
                this.plotWave(plot, renderWave);
                break;
            }
            case SPECTRA: {
                this.plotSpectra(plot, renderWave);
                break;
            }
            case SPECTROGRAM: {
                this.plotSpectrogram(plot, renderWave);
            }
        }
        plot.render(g2);
    }

    private void plotWave(Plot plot, Wave renderWave) {
        if (renderWave == null || renderWave.samples() == 0) {
            return;
        }
        SliceWave wv = new SliceWave(renderWave);
        wv.setSlice(this.startTime, this.endTime);
        double offset = 0.0;
        double multiplier = 1.0;
        Metadata md = Swarm.config.getMetadata(this.channel);
        if (this.settings.useUnits && md != null) {
            offset = md.getOffset();
            multiplier = md.getMultiplier();
        }
        double bias = 0.0;
        if (this.settings.removeBias) {
            bias = wv.mean();
        }
        double minY = (this.settings.minAmp - offset) / multiplier;
        double maxY = (this.settings.maxAmp - offset) / multiplier;
        if (this.settings.autoScaleAmp) {
            double[] dr = new double[]{wv.min(), wv.max()};
            if (this.settings.autoScaleAmpMemory) {
                minY = Math.min(this.minAmp, dr[0] - bias);
                maxY = Math.max(this.maxAmp, dr[1] - bias);
                this.minAmp = Math.min(minY, this.minAmp);
                this.maxAmp = Math.max(maxY, this.maxAmp);
            } else {
                minY = dr[0] - bias;
                maxY = dr[1] - bias;
            }
        }
        if (this.waveRenderer == null) {
            this.waveRenderer = new SliceWaveRenderer();
        }
        if (this.decorator != null) {
            this.waveRenderer.setFrameDecorator(this.decorator);
        }
        if (this.settings.useUnits && md != null && md.getUnit() != null) {
            this.waveRenderer.setYLabel(md.getUnit());
        } else {
            this.waveRenderer.setYLabel("Counts");
        }
        this.waveRenderer.setYAxisCoefficients(multiplier, offset);
        this.waveRenderer.setLocation(this.xOffset, this.yOffset, this.getWidth() - this.xOffset - this.rightWidth, this.getHeight() - this.yOffset - this.bottomHeight);
        this.waveRenderer.setYLimits(minY, maxY);
        this.waveRenderer.setViewTimes(this.startTime, this.endTime);
        this.waveRenderer.setWave(wv);
        this.waveRenderer.setRemoveBias(this.settings.removeBias);
        this.waveRenderer.setAutoScale(true);
        if (this.channel != null && this.displayTitle) {
            this.waveRenderer.setTitle(this.channel);
        }
        this.waveRenderer.update();
        plot.addRenderer(this.waveRenderer);
        if (this.useFilterLabel && this.settings.filterOn) {
            plot.addRenderer(this.getFilterLabel());
        }
        this.translation = this.waveRenderer.getDefaultTranslation();
    }

    private void plotSpectra(Plot plot, Wave renderWave) {
        if (renderWave == null || renderWave.samples() == 0) {
            return;
        }
        SliceWave wv = new SliceWave(renderWave);
        wv.setSlice(this.startTime, this.endTime);
        if (this.spectraRenderer == null) {
            this.spectraRenderer = new SpectraRenderer();
        }
        if (this.decorator != null) {
            this.spectraRenderer.setFrameDecorator(this.decorator);
        }
        this.spectraRenderer.setLocation(this.xOffset, this.yOffset, this.getWidth() - this.rightWidth - this.xOffset, this.getHeight() - this.bottomHeight - this.yOffset);
        this.spectraRenderer.setWave(wv);
        this.spectraRenderer.setAutoScale(this.settings.autoScalePower);
        this.spectraRenderer.setLogPower(this.settings.logPower);
        this.spectraRenderer.setLogFreq(this.settings.logFreq);
        this.spectraRenderer.setMaxFreq(this.settings.maxFreq);
        this.spectraRenderer.setMinFreq(this.settings.minFreq);
        if (this.channel != null && this.displayTitle) {
            this.spectraRenderer.setTitle(this.channel);
        }
        double power = this.spectraRenderer.update(this.maxSpectraPower);
        this.maxSpectraPower = Math.max(this.maxSpectraPower, power);
        if (this.useFilterLabel && this.settings.filterOn) {
            plot.addRenderer(this.getFilterLabel());
        }
        this.translation = this.spectraRenderer.getDefaultTranslation();
        plot.addRenderer(this.spectraRenderer);
    }

    private void plotSpectrogram(Plot plot, Wave renderWave) {
        if (renderWave == null || renderWave.samples() == 0) {
            return;
        }
        SliceWave wv = new SliceWave(renderWave);
        wv.setSlice(this.startTime, this.endTime);
        if (this.spectrogramRenderer == null) {
            this.spectrogramRenderer = new SpectrogramRenderer();
        }
        if (this.decorator != null) {
            this.spectrogramRenderer.setFrameDecorator(this.decorator);
        }
        this.spectrogramRenderer.setLocation(this.xOffset, this.yOffset, this.getWidth() - this.rightWidth - this.xOffset, this.getHeight() - this.bottomHeight - this.yOffset);
        this.spectrogramRenderer.setWave(wv);
        this.spectrogramRenderer.setViewStartTime(this.startTime);
        this.spectrogramRenderer.setViewEndTime(this.endTime);
        this.spectrogramRenderer.setAutoScale(this.settings.autoScalePower);
        this.spectrogramRenderer.setFftSize(this.settings.fftSize);
        this.spectrogramRenderer.setLogPower(this.settings.logPower);
        this.spectrogramRenderer.setOverlap(this.settings.spectrogramOverlap);
        this.spectrogramRenderer.setMaxFreq(this.settings.maxFreq);
        this.spectrogramRenderer.setMinFreq(this.settings.minFreq);
        if (this.channel != null && this.displayTitle) {
            this.spectrogramRenderer.setTitle(this.channel);
        }
        double power = this.spectrogramRenderer.update(this.maxSpectrogramPower);
        this.maxSpectrogramPower = Math.max(this.maxSpectrogramPower, power);
        plot.addRenderer(this.spectrogramRenderer);
        if (this.useFilterLabel && this.settings.filterOn) {
            plot.addRenderer(this.getFilterLabel());
        }
        this.translation = this.spectrogramRenderer.getDefaultTranslation();
    }

    private void paintDragBox(Graphics2D g2) {
        int x1 = Math.min(this.highlightX1, this.highlightX2);
        int x2 = Math.max(this.highlightX1, this.highlightX2);
        int width = x2 - x1 + 1;
        Paint pnt = g2.getPaint();
        g2.setPaint(new Color(255, 255, 0, 128));
        g2.fillRect(x1, this.yOffset + 1, width, this.getSize().height - this.bottomHeight - this.yOffset);
        g2.setPaint(pnt);
    }

    public void setCursorMark(double j2k) {
        this.cursorMark = j2k;
        this.repaint();
    }

    private void paintCursor(Graphics2D g2) {
        if (Double.isNaN(this.cursorMark) || this.cursorMark < this.startTime || this.cursorMark > this.endTime) {
            return;
        }
        double[] t = this.getTranslation();
        if (t == null) {
            return;
        }
        double x = (this.cursorMark - t[1]) / t[0];
        g2.setColor(DARK_RED);
        g2.draw(new Line2D.Double(x, this.yOffset + 1, x, this.getHeight() - this.bottomHeight - 1));
    }

    private void paintMark(Graphics2D g2, double j2k) {
        if (Double.isNaN(j2k) || j2k < this.startTime || j2k > this.endTime) {
            return;
        }
        double[] t = this.getTranslation();
        if (t == null) {
            return;
        }
        double x = (j2k - t[1]) / t[0];
        g2.setColor(DARK_GREEN);
        g2.draw(new Line2D.Double(x, this.yOffset, x, this.getHeight() - this.bottomHeight - 1));
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)x, this.yOffset);
        gp.lineTo((float)x - 5.0f, this.yOffset - 7);
        gp.lineTo((float)x + 5.0f, this.yOffset - 7);
        gp.closePath();
        g2.setPaint(Color.GREEN);
        g2.fill(gp);
        g2.setColor(DARK_GREEN);
        g2.draw(gp);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    public void setMarks(double m1, double m2) {
        this.mark1 = m1;
        this.mark2 = m2;
    }
}

