/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Arguments {
    private String[] args;
    private Set<String> allArgs;
    private Map<String, String> mappedArgs;
    private Set<String> flaggedArgs;
    private List<String> unusedArgs;

    public Arguments(String[] a, Set<String> flags, Set<String> kvs) {
        this.args = a;
        if (this.args == null) {
            return;
        }
        this.mappedArgs = new HashMap<String, String>();
        this.allArgs = new HashSet<String>();
        this.flaggedArgs = new HashSet<String>();
        this.unusedArgs = new ArrayList<String>();
        int i = 0;
        while (i < this.args.length) {
            this.allArgs.add(this.args[i]);
            if (flags != null && flags.contains(this.args[i])) {
                this.flaggedArgs.add(this.args[i]);
            } else if (kvs != null && kvs.contains(this.args[i])) {
                String key = this.args[i];
                String val = "";
                if (this.args.length > i + 1) {
                    val = this.args[i + 1];
                    ++i;
                }
                this.mappedArgs.put(key, val);
            } else {
                this.unusedArgs.add(this.args[i]);
            }
            ++i;
        }
    }

    public int size() {
        if (this.args == null) {
            return 0;
        }
        return this.args.length;
    }

    public String get(String key) {
        return this.mappedArgs.get(key);
    }

    public String get(int i) {
        return this.args[i];
    }

    public boolean flagged(String arg) {
        return this.flaggedArgs.contains(arg);
    }

    public boolean contains(String arg) {
        return this.allArgs.contains(arg);
    }

    public List<String> unused() {
        return this.unusedArgs;
    }

    public String last() {
        return this.args[this.args.length - 1];
    }

    public String[] lastN(int n) {
        String[] result = new String[n];
        int i = this.args.length - n;
        int j = 0;
        while (i < this.args.length) {
            result[j] = this.args[i];
            ++i;
            ++j;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperties());
    }
}

