/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.Log;

public abstract class Retriable<T> {
    public static boolean defaultOutput = true;
    public static int defaultMaxAttempts = 3;
    protected int maxAttempts = defaultMaxAttempts;
    protected String name = "";
    protected T result;
    protected boolean output = defaultOutput;

    public Retriable() {
    }

    public Retriable(int mr) {
        this();
        this.maxAttempts = mr;
    }

    public Retriable(String n, int mr) {
        this(mr);
        this.name = n;
        this.maxAttempts = mr;
    }

    public static void setDefaultMaxAttempts(int m) {
        defaultMaxAttempts = m;
    }

    public static void setDefaultOutput(boolean b) {
        defaultOutput = b;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public boolean isOutput() {
        return this.output;
    }

    public T getResult() {
        return this.result;
    }

    public void attemptFix() {
    }

    public void giveUp() {
    }

    public abstract boolean attempt();

    public T go() {
        int attempts = 0;
        boolean success = false;
        while (!success && attempts < this.getMaxAttempts()) {
            ++attempts;
            success = this.attempt();
            if (success) continue;
            if (this.isOutput()) {
                Log.getLogger("gov.usgs.util").fine(String.valueOf(this.getName()) + ": failed on attempt " + attempts + ".");
            }
            this.attemptFix();
        }
        if (!success) {
            if (this.isOutput()) {
                Log.getLogger("gov.usgs.util").warning(String.valueOf(this.getName()) + ": giving up.");
            }
            this.giveUp();
        }
        return this.getResult();
    }
}

