/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class GlobalKeyManager
extends EventQueue {
    private static final GlobalKeyManager instance = new GlobalKeyManager();
    private final InputMap keyStrokes = new InputMap();
    private final ActionMap actions = new ActionMap();
    private InputMap currentInputMap;

    static {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(instance);
    }

    private GlobalKeyManager() {
    }

    public static GlobalKeyManager getInstance() {
        return instance;
    }

    public InputMap getInputMap() {
        return this.keyStrokes;
    }

    public ActionMap getActionMap() {
        return this.actions;
    }

    public void setCurrentMap(InputMap imap) {
        this.currentInputMap = imap;
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        if (event instanceof KeyEvent) {
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent((KeyEvent)event);
            String actionKey = (String)this.keyStrokes.get(ks);
            Action action = null;
            if (actionKey != null) {
                action = this.actions.get(actionKey);
            } else if (this.currentInputMap != null) {
                String key = (String)this.currentInputMap.get(ks);
                action = this.actions.get(key);
            }
            if (action != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(event.getSource(), event.getID(), actionKey, ((KeyEvent)event).getModifiers()));
                return;
            }
        }
        super.dispatchEvent(event);
    }
}

