/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.valid;

import gov.usgs.util.valid.Constraint;
import gov.usgs.util.valid.Invalid;

public class IntConstraint
implements Constraint {
    public int minimum = -2147483647;
    public int maximum = 0x7FFFFFFE;
    public int defaultValue = Integer.MIN_VALUE;
    public boolean allowNull = false;

    public IntConstraint(int min, int max, int def, boolean n) {
        this.minimum = min;
        this.maximum = max;
        this.defaultValue = def;
        this.allowNull = n;
    }

    @Override
    public Object isValid(String input) {
        if (input == null) {
            return this.allowNull ? new Integer(this.defaultValue) : new Invalid("null value");
        }
        int i = 0;
        try {
            i = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return new Invalid("illegal number format");
        }
        if (i < this.minimum) {
            return new Invalid("number less than minimum");
        }
        if (i > this.maximum) {
            return new Invalid("number greater than maximum");
        }
        return new Integer(i);
    }
}

