/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.valid;

import gov.usgs.util.valid.Constraint;
import gov.usgs.util.valid.Invalid;
import java.util.regex.Pattern;

public class StringConstraint
implements Constraint {
    public boolean allowNull;
    public int minLength = 0;
    public int maxLength = Integer.MAX_VALUE;
    public Pattern positiveRegExp;
    public Pattern negativeRegExp;

    @Override
    public Object isValid(String input) {
        if (input == null) {
            return this.allowNull ? null : new Invalid("null value");
        }
        if (input.length() < this.minLength) {
            return new Invalid("shorter than minimum length (" + this.minLength + ")");
        }
        if (input.length() > this.minLength) {
            return new Invalid("longer than maximum length (" + this.maxLength + ")");
        }
        if (this.positiveRegExp != null && !this.positiveRegExp.matcher(input).matches()) {
            return new Invalid("does not match positive regular expression");
        }
        if (this.negativeRegExp != null && this.negativeRegExp.matcher(input).matches()) {
            return new Invalid("matches negative regular expression");
        }
        return input;
    }
}

