/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.BinaryDataSet;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GenericDataMatrix
implements BinaryDataSet {
    protected DoubleMatrix2D data = null;
    protected HashMap<String, Integer> columnMap = new HashMap();

    public GenericDataMatrix() {
        this.setColumnNames();
    }

    public GenericDataMatrix(DoubleMatrix2D d) {
        this();
        this.data = d;
    }

    public GenericDataMatrix(ByteBuffer bb) {
        this();
        this.fromBinary(bb);
    }

    public GenericDataMatrix(List<double[]> list) {
        this();
        if (list == null || list.size() == 0) {
            return;
        }
        int rows = list.size();
        int cols = list.get(0).length;
        this.data = DoubleFactory2D.dense.make(rows, cols);
        int i = 0;
        while (i < rows) {
            double[] d = list.get(i);
            int j = 0;
            while (j < cols) {
                this.data.setQuick(i, j, d[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public ByteBuffer toBinary() {
        int rows = this.rows();
        int cols = this.columns();
        ByteBuffer bb = ByteBuffer.allocate(4 + rows * cols * 8);
        bb.putInt(rows);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                bb.putDouble(this.data.getQuick(i, j));
                ++j;
            }
            ++i;
        }
        return bb;
    }

    @Override
    public void fromBinary(ByteBuffer bb) {
        int rows = bb.getInt();
        int cols = (bb.limit() - 4) / rows / 8;
        this.data = DoubleFactory2D.dense.make(rows, cols);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                this.data.setQuick(i, j, bb.getDouble());
                ++j;
            }
            ++i;
        }
    }

    public String toCSV() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.rows()) {
            sb.append(String.valueOf(Util.j2KToDateString(this.data.getQuick(i, 0))) + ",");
            int j = 1;
            while (j < this.columns()) {
                sb.append(this.data.getQuick(i, j));
                sb.append(",");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public void setData(DoubleMatrix2D d) {
        this.data = d;
    }

    public void setColumnNames() {
    }

    public void setColumnNames(String[] s) {
        int i = 0;
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.columnMap.put(name, i++);
            ++n2;
        }
    }

    public String[] getColumnNames() {
        String[] c = new String[this.columnMap.size()];
        Iterator<String> iterator = this.columnMap.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            c[this.columnMap.get((Object)s).intValue()] = s = iterator.next();
        }
        return c;
    }

    public int rows() {
        if (this.data != null) {
            return this.data.rows();
        }
        return 0;
    }

    public int columns() {
        if (this.data != null) {
            return this.data.columns();
        }
        return 0;
    }

    public void add(String c, double v) {
        Integer i = this.columnMap.get(c);
        if (i != null) {
            this.add(i, v);
        }
    }

    public void add(int c, double v) {
        int i = 0;
        while (i < this.rows()) {
            this.data.setQuick(i, c, this.data.getQuick(i, c) + v);
            ++i;
        }
    }

    public void mult(String c, double v) {
        Integer i = this.columnMap.get(c);
        if (i != null) {
            this.mult(i, v);
        }
    }

    public void mult(int c, double v) {
        int i = 0;
        while (i < this.rows()) {
            this.data.setQuick(i, c, this.data.getQuick(i, c) * v);
            ++i;
        }
    }

    public void sum(int c) {
        int i = 1;
        while (i < this.rows()) {
            double d = this.data.getQuick(i - 1, c);
            this.data.setQuick(i, c, d += this.data.getQuick(i, c));
            ++i;
        }
    }

    public void detrend(int c) {
        double xm = this.mean(0);
        double ym = this.mean(c);
        double ssxx = 0.0;
        double ssxy = 0.0;
        int i = 0;
        while (i < this.rows()) {
            ssxy += (this.data.getQuick(i, 0) - xm) * (this.data.getQuick(i, c) - ym);
            ssxx += (this.data.getQuick(i, 0) - xm) * (this.data.getQuick(i, 0) - xm);
            ++i;
        }
        double m = ssxy / ssxx;
        double b = ym - m * xm;
        int i2 = 0;
        while (i2 < this.rows()) {
            this.data.setQuick(i2, c, this.data.getQuick(i2, c) - (this.data.getQuick(i2, 0) * m + b));
            ++i2;
        }
    }

    public double max(int c) {
        double m = -1.0E300;
        int i = 0;
        while (i < this.rows()) {
            m = Math.max(m, this.data.getQuick(i, c));
            ++i;
        }
        return m;
    }

    public double min(int c) {
        double m = 1.0E300;
        int i = 0;
        while (i < this.rows()) {
            m = Math.min(m, this.data.getQuick(i, c));
            ++i;
        }
        return m;
    }

    public double mean(int c) {
        double t = 0.0;
        int i = 0;
        while (i < this.rows()) {
            t += this.data.getQuick(i, c);
            ++i;
        }
        return t / (double)this.rows();
    }

    public double getStartTime() {
        if (this.data == null || this.data.size() == 0) {
            return Double.NaN;
        }
        return this.data.get(0, 0);
    }

    public double getEndTime() {
        if (this.data == null || this.data.size() == 0) {
            return Double.NaN;
        }
        return this.data.get(this.rows() - 1, 0);
    }

    public void adjustTime(double adj) {
        this.add(0, adj);
    }

    public DoubleMatrix2D getTimes() {
        return this.data.viewPart(0, 0, this.rows(), 1);
    }

    public DoubleMatrix2D getColumn(int c) {
        return this.data.viewPart(0, c, this.rows(), 1);
    }

    public DoubleMatrix2D getColumn(String c) {
        Integer i = this.columnMap.get(c);
        if (i != null) {
            return this.getColumn(i);
        }
        return null;
    }

    public DoubleMatrix2D getData() {
        return this.data;
    }

    public void concatenate(GenericDataMatrix dm) {
        DoubleMatrix2D[][] ms = new DoubleMatrix2D[2][1];
        ms[0][0] = this.data;
        ms[1][0] = dm.getData();
        this.data = DoubleFactory2D.dense.compose(ms);
    }

    public int getMemorySize() {
        return this.data.rows() * this.data.columns() * 8;
    }
}

