/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.hypo.HypocenterList;
import hep.aida.IAxis;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.Histogram1D;
import hep.aida.ref.VariableAxis;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class RSAMData
extends GenericDataMatrix {
    protected static final int MAX_BINS = 1000000;
    protected DoubleMatrix2D events;

    public RSAMData() {
        this.columnMap.put("time", 0);
        this.columnMap.put("rsam", 0);
    }

    public RSAMData(ByteBuffer bb) {
        super(bb);
    }

    public RSAMData(List<double[]> list) {
        super(list);
    }

    public DoubleMatrix2D getRSAM() {
        return this.data.viewPart(0, 1, this.rows(), 1);
    }

    protected IAxis getHistogramAxis(HypocenterList.BinSize bin) {
        int i;
        Date de;
        Date ds;
        double startTime = this.getStartTime();
        double endTime = this.getEndTime();
        int bins = -1;
        FixedAxis axis = null;
        if (bin == HypocenterList.BinSize.MINUTE) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 60.0 - 60.0) - (startTime -= (startTime - 43200.0) % 60.0)) / 60) > 1000000) {
                bin = HypocenterList.BinSize.HOUR;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == HypocenterList.BinSize.TENMINUTE) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 600.0 - 600.0) - (startTime -= (startTime - 43200.0) % 600.0)) / 600) > 1000000) {
                bin = HypocenterList.BinSize.HOUR;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == HypocenterList.BinSize.HOUR) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 3600.0 - 3600.0) - (startTime -= (startTime - 43200.0) % 3600.0)) / 3600) > 1000000) {
                bin = HypocenterList.BinSize.DAY;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == HypocenterList.BinSize.DAY) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 86400.0 - 86400.0) - (startTime -= (startTime - 43200.0) % 86400.0)) / 86400) > 1000000) {
                bin = HypocenterList.BinSize.WEEK;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == HypocenterList.BinSize.WEEK) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 604800.0 - 604800.0) - (startTime -= (startTime - 43200.0) % 604800.0)) / 604800) > 1000000) {
                bin = HypocenterList.BinSize.MONTH;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == HypocenterList.BinSize.MONTH) {
            ds = Util.j2KToDate(startTime);
            bins = Util.getMonthsBetween(ds, de = Util.j2KToDate(endTime)) + 1;
            if (bins <= 1000000) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(ds);
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                double[] edges = new double[bins + 1];
                i = 0;
                while (i < bins + 1) {
                    edges[i] = Util.dateToJ2K(cal.getTime());
                    cal.add(2, 1);
                    ++i;
                }
                axis = new VariableAxis(edges);
            } else {
                bin = HypocenterList.BinSize.YEAR;
            }
        }
        if (bin == HypocenterList.BinSize.YEAR) {
            ds = Util.j2KToDate(startTime);
            de = Util.j2KToDate(endTime);
            bins = Util.getYear(de) - Util.getYear(ds) + 1;
            double[] edges = new double[bins + 1];
            Calendar cal = Calendar.getInstance();
            cal.setTime(ds);
            cal.set(2, 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            i = 0;
            while (i < bins + 1) {
                edges[i] = Util.dateToJ2K(cal.getTime());
                cal.add(1, 1);
                ++i;
            }
            axis = new VariableAxis(edges);
        }
        return axis;
    }

    public void countEvents(double threshold, double ratio, double maxLength) {
        double oldValue = 0.0;
        double olderValue = 0.0;
        boolean eventOngoing = false;
        double eventStart = 0.0;
        int eventCount = 0;
        double[] eventTimes = new double[this.data.rows()];
        int i = 1;
        while (i < this.data.rows()) {
            double currentTime = this.data.get(i, 0);
            double currentValue = this.data.get(i, 1);
            if (currentValue >= threshold && currentValue >= olderValue * ratio) {
                if (currentTime - eventStart > maxLength) {
                    eventOngoing = false;
                    eventStart = currentTime;
                } else if (!eventOngoing) {
                    eventStart = currentTime;
                    eventOngoing = true;
                    eventTimes[eventCount++] = currentTime;
                }
            } else {
                eventOngoing = false;
                eventStart = currentTime;
            }
            olderValue = oldValue;
            oldValue = currentValue;
            ++i;
        }
        this.events = DoubleFactory2D.dense.make(eventCount + 2, 2);
        this.events.setQuick(0, 0, this.data.get(0, 0));
        this.events.setQuick(0, 1, 0.0);
        int c = 1;
        int i2 = 1;
        while (i2 <= eventCount) {
            this.events.setQuick(i2, 0, eventTimes[i2 - 1]);
            this.events.setQuick(i2, 1, (double)c++);
            ++i2;
        }
        this.events.setQuick(eventCount + 1, 0, this.data.get(this.data.rows() - 1, 0));
        this.events.setQuick(eventCount + 1, 1, (double)eventCount);
    }

    public RSAMData getRatSAM(RSAMData d) {
        DoubleMatrix2D other = d.getData();
        ArrayList<double[]> ratList = new ArrayList<double[]>();
        int i = 0;
        int j = 0;
        while (i < this.rows() && j < other.rows()) {
            double t2;
            double t1 = this.data.getQuick(i, 0);
            if (t1 < (t2 = other.getQuick(j, 0))) {
                ++i;
                continue;
            }
            if (t1 > t2) {
                ++j;
                continue;
            }
            try {
                double[] pt = new double[]{t1, this.data.getQuick(i++, 1) / other.getQuick(j++, 1)};
                ratList.add(pt);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return new RSAMData(ratList);
    }

    public DoubleMatrix2D getCumulativeCounts() {
        return this.events;
    }

    public String getCountsCSV() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.events.rows()) {
            sb.append(String.valueOf(Util.j2KToDateString(this.events.getQuick(i, 0))) + ",");
            int j = 1;
            while (j < this.events.columns()) {
                sb.append(this.events.getQuick(i, j));
                sb.append(",");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public Histogram1D getCountsHistogram(HypocenterList.BinSize bin) {
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        Histogram1D hist = new Histogram1D("", this.getHistogramAxis(bin));
        int i = 1;
        while (i < this.events.rows() - 1) {
            hist.fill(this.events.get(i, 0));
            ++i;
        }
        return hist;
    }
}

